package ucar.nc2.ui.image;

import java.awt.*;
import java.awt.image.*;
import java.net.URL;
import java.net.MalformedURLException;
import javax.swing.*;

import ucar.nc2.image.ImageDatasetFactory;

public class ImageViewPanel extends JPanel {
  private static boolean debug = false;

  private ImageDatasetFactory imageFactory = new ImageDatasetFactory();

  private PicturePane pixPane;

  public ImageViewPanel() {
    pixPane = new PicturePane();
    setLayout(new BorderLayout());
    add( pixPane, BorderLayout.CENTER);
  }

   public boolean setImageFromUrl( String location) {

     if (location.startsWith("http")) {
       URL url = null;
       try {
         url = new URL( location);
       } catch (MalformedURLException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
       }

       // uses ImageIO.createImageInputStream()
       pixPane.setPicture( url, "legendParam", 0.0);

     } else {

      try {
        BufferedImage image = imageFactory.open( location);
        setImage( image);

      } catch (Exception e2) {
        javax.swing.JOptionPane.showMessageDialog(null, "Error on dataset = "+location+"\n"+imageFactory.getErrorMessages());
        e2.printStackTrace();
        return false;
      }
    }

    return true;
  }

  public void setImage( BufferedImage im) {
    if (debug) System.out.println("ImageViewPanel setImage ");
    pixPane.setBufferedImage( im, "setImage");
    pixPane.repaint();
  }

  static public void main( String[] args) {
      String[] readers = javax.imageio.ImageIO.getReaderFormatNames();
      for (int i = 0; i < readers.length; i++) {
        System.out.println(" reader = "+ readers[i]);
      }
      System.out.println("-------------------------------------------");
      String[] readerMimes = javax.imageio.ImageIO.getReaderMIMETypes();
      for (int i = 0; i < readerMimes.length; i++) {
        System.out.println(" readerMimes = "+ readerMimes[i]);
      }
      System.out.println("-------------------------------------------");
      String[] writers = javax.imageio.ImageIO.getWriterFormatNames();
      for (int i = 0; i < writers.length; i++) {
        System.out.println(" writers = "+ writers[i]);
      }
      System.out.println("-------------------------------------------");
      String[] writerMimes = javax.imageio.ImageIO.getWriterMIMETypes();
      for (int i = 0; i < writerMimes.length; i++) {
        System.out.println(" writerMimes = "+ writerMimes[i]);
      }
      System.out.println("-------------------------------------------");
  }

}
/* Change History:
   $Log: ImageViewPanel.java,v $
   Revision 1.4  2004/11/10 17:00:29  caron
   no message

   Revision 1.3  2004/11/07 02:55:12  caron
   no message

   Revision 1.2  2004/10/29 00:14:11  caron
   no message

   Revision 1.1  2004/10/23 21:55:41  caron
   new image drawing

   Revision 1.6  2004/10/08 00:32:07  caron
   add simple image viewer in the NCdump panel (2)

   Revision 1.5  2004/10/07 22:15:12  caron
   add simple image viewer in the NCdump panel

   Revision 1.4  2004/09/30 00:33:39  caron
   *** empty log message ***

   Revision 1.3  2004/09/25 00:09:44  caron
   add images, thredds tab

   Revision 1.2  2004/09/24 03:26:38  caron
   merge nj22

   Revision 1.1  2002/12/13 00:53:09  caron
   pass 2

   Revision 1.1  2002/04/29 22:52:27  caron
   ADDE Cataloger verion 1

   Revision 1.1.1.1  2002/02/26 17:24:47  caron
   import sources

*/

