package ucar.nc2.station;

import java.io.IOException;
import java.util.Date;
import java.util.List;

public interface StationObsDataset {

  /** Start date for the entire dataset.
   *  This tells what is a reasonable date range to request.
   */
  public Date getStartDate();

  /** End date for the entire dataset.
   * This tells what is a reasonable date range to request.
   */
  public Date getEndDate();

  /** The boundingBox for the entire dataset.
   * This tells what is a reasonable boundingBox to request.
   */
  public ucar.unidata.geoloc.LatLonRect getBoundingBox();

  /** The list of Stations its possible to ask about. */
  public List getStations() throws IOException;

  /** The list of Stations within a bounding box its possible to ask about. */
  public List getStations(ucar.unidata.geoloc.LatLonRect boundingBox) throws IOException;

  /** Find a Station by name */
  public Station getStation( String name) throws IOException;

  /**
   * How many StationObs are available for this Station?
   * @param s station
   * @return count or -1 if unknown.
   */
  public int getStationObsCount( Station s);

  /** Get all StationObs for this Station. */
  public List getStationObs( Station s) throws IOException;
  /** Get all StationObs for this Station within the specified date range. */
  public List getStationObs( Station s, Date start, Date end) throws IOException;
  /** Get all StationObs for a list of Stations. */
  public List getStationObs(List stations) throws IOException;
  /** Get all StationObs for a list of Stations within the specified date range. */
   public List getStationObs(List stations, Date start, Date end) throws IOException;

  /** Get all StationObs within the specified bounding box. */ 
  public List getStationObs( ucar.unidata.geoloc.LatLonRect boundingBox) throws IOException;
  /** Get all StationObs within the specified bounding box and date range. */
  public List getStationObs( ucar.unidata.geoloc.LatLonRect boundingBox, Date start, Date end) throws IOException;

   /** Close all resources associated with this dataset. */
  public void close() throws java.io.IOException;

  public interface Station {
    public String getName(); // must be unique
    public String getDescription(); // optional, but highly desirable
    public double getLatitude(); // required, units degrees_north
    public double getLongitude(); // required, units degrees_east
    public double getElevation(); // optional, units meters;  missing = NaN.
  }

  public interface StationObs {
    public Station getStation();
    public java.util.Date getTime();
    public ucar.nc2.StructureData getData() throws IOException;
  }

}
