// $Id: OldUnidataStationObsDataset.java,v 1.1 2004/12/10 19:44:49 caron Exp $
/*
 * Copyright 1997-2004 Unidata Program Center/University Corporation for
 * Atmospheric Research, P.O. Box 3000, Boulder, CO 80307,
 * support@unidata.ucar.edu.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package ucar.nc2.station;

import ucar.nc2.*;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;

import java.io.*;

/**
 * This handles datasets in "Unidata Point Format"
 *
 * @author John Caron
 * @version $Id: OldUnidataStationObsDataset.java,v 1.1 2004/12/10 19:44:49 caron Exp $
 */

public class OldUnidataStationObsDataset extends RecordDataset {

  static public boolean isValidFile(NetcdfFile ds) {
    String title = ds.findAttValueIgnoreCase(null, "title", null);
    if (title == null) return false;
    if ("METAR definition".equals( title)) return true;
    if ("SYNOPTIC definition".equals( title)) return true;
    if ("BUOY definition".equals( title)) return true;

    return false;
  }

  public OldUnidataStationObsDataset(NetcdfDataset ds) throws IOException {
    String title = ds.findAttValueIgnoreCase(null, "title", null);
    if ("METAR definition".equals(title)) {
      Variable v = ds.findVariable("record.station");
      if (v != null)
        NcMLReader.wrapNcMLresource(ds, "resources/xml/metar2ncMetar.ncml", null);
      else  // older form
        NcMLReader.wrapNcMLresource(ds, "resources/xml/metar2ncMetar2.ncml", null);
    }
    else if ("SYNOPTIC definition".equals(title))
      NcMLReader.wrapNcMLresource(ds, "resources/xml/metar2ncSynoptic.ncml", null);
    else if ("BUOY definition".equals(title))
      NcMLReader.wrapNcMLresource(ds, "resources/xml/metar2ncBuoy.ncml", null);
    else
      throw new IOException("unknown StationObsDataset type "+ds.getLocation());

    init(ds);
  }
}