// $Id: GribTimeCoordSys.java,v 1.7 2004/12/07 02:43:22 caron Exp $
/*
 * Copyright 1997-2004 Unidata Program Center/University Corporation for
 * Atmospheric Research, P.O. Box 3000, Boulder, CO 80307,
 * support@unidata.ucar.edu.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ucar.nc2.iosp.grib;

import ucar.grib.Index;
import ucar.grib.TableLookup;

import ucar.ma2.Array;
import ucar.nc2.*;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.units.DateUnit;

import java.util.*;

/**
 * @author john
 */
public class GribTimeCoordSys {

  HashMap timeMap = new HashMap();
  ArrayList times;
  int ntimes = -1;

  GribTimeCoordSys() {};

  void addTimes( List records) {
    for (int i = 0; i < records.size(); i++) {
      Index.GribRecord record = (Index.GribRecord) records.get(i);
      Integer time = new Integer(record.forecastTime);
      timeMap.put( time, time);
    }
  }

  void addDimensionsToNetcdfFile( NetcdfFile ncfile, Group g, TableLookup lookup) {
    times = new ArrayList(timeMap.values());
    Collections.sort( times);

    ntimes = times.size();
    ncfile.addDimension(g, new Dimension("time", ntimes, true));
  }

  void addToNetcdfFile( NetcdfFile ncfile, Group g, TableLookup lookup) {
    Variable v = new Variable( ncfile, g, null, "time");
    v.setDataType( DataType.INT);
    v.addAttribute( new Attribute("long_name", "forecast time"));

    int[] data = new int[ntimes];
    for (int i = 0; i < times.size(); i++) {
      Integer t = (Integer) times.get(i);
      data[i] = t.intValue();
    }
    Array dataArray = Array.factory( DataType.INT.getClassType(), new int [] {ntimes}, data);

    v.setDimensions( "time");
    v.setCachedData(dataArray, false);

    Date d = lookup.getFirstBaseTime();

    String timeUnit =  lookup.getFirstTimeRangeUnitName()+" since "+ DateUnit.getStandardDateString( d);
    v.addAttribute( new Attribute("units",timeUnit));
    v.addAttribute( new Attribute("GRIB2_referenceTime", lookup.getFirstSignificanceOfRTName()));
    v.addAttribute( new Attribute("_CoordinateAxisType", AxisType.Time.toString()));

    ncfile.addVariable( g, v);
  }

  int getIndex(Index.GribRecord record) {
    Integer time = new Integer(record.forecastTime);
    return times.indexOf( time);
  }

  int getNTimes() {
    if (ntimes < 0)
      ntimes = timeMap.values().size();
    return ntimes;
  }
}

/* Change History:
   $Log: GribTimeCoordSys.java,v $
   Revision 1.7  2004/12/07 02:43:22  caron
   *** empty log message ***

   Revision 1.6  2004/12/07 01:29:31  caron
   redo convention parsing, use _Coordinate encoding.

   Revision 1.5  2004/12/01 05:53:42  caron
   ncml pass 2, new convention parsing

   Revision 1.4  2004/10/13 19:45:12  caron
   add strict NCDump

   Revision 1.3  2004/10/12 02:57:06  caron
   refactor for grib1/grib2: move common functionality up to ucar.grib
   split GribServiceProvider

   Revision 1.2  2004/10/02 20:54:41  caron
   *** empty log message ***

   Revision 1.1  2004/09/30 20:49:06  caron
   *** empty log message ***

*/