// $Id: DODSVariable.java,v 1.12 2004/11/07 03:00:50 caron Exp $
/*
 * Copyright 1997-2004 Unidata Program Center/University Corporation for
 * Atmospheric Research, P.O. Box 3000, Boulder, CO 80307,
 * support@unidata.ucar.edu.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, strlenwrite to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ucar.nc2.dods;

import ucar.ma2.*;
import ucar.nc2.*;
import ucar.unidata.util.StringUtil;
import dods.dap.*;

import java.util.*;

/**
 * A read-only DODS-netCDF Variable. Same as a ucar.nc2.Variable except that
 * it might have type boolean or long. Note that DODS DUInt32 widened to long and
 * DODS DUInt16 widened to int.
 *
 * @see ucar.nc2.Variable
 * @author caron
 * @version $Revision: 1.12 $ $Date: 2004/11/07 03:00:50 $
 */

public class DODSVariable extends ucar.nc2.Variable {
  protected String CE;        // projection is allowed
  protected DODSNetcdfFile dodsfile; // so we dont have to cast everywhere
  protected String dodsShortName;

  // used by subclasses and the other constructors
  DODSVariable( DODSNetcdfFile dodsfile, Group parentGroup, Structure parentStructure, String shortName) {
    super(dodsfile, parentGroup, parentStructure, shortName);
    this.dodsfile = dodsfile;
    this.dodsShortName = shortName;
  }

    /* copy constructor, display name change
  DODSVariable( DODSVariable from) {
    super( from.getName(), from);
  } */

    // use when a dods variable is a scalar
  DODSVariable( DODSNetcdfFile dodsfile, Group parentGroup, Structure parentStructure, String shortName, dods.dap.BaseType dodsScalar) {
    super(dodsfile, parentGroup, parentStructure, shortName);
    this.dodsfile = dodsfile;
    this.dodsShortName = shortName;

    shape = new int[0];
    setDataType( DODSNetcdfFile.convertToNCType( dodsScalar));
    this.ranges = Range.factory( shape);
  }

   // use when a dods variable is an Array, rank > 0
  DODSVariable( DODSNetcdfFile dodsfile, Group parentGroup, Structure parentStructure, String shortName, DArray dodsArray,
                dods.dap.BaseType elemType ) {

    super(dodsfile, parentGroup, parentStructure, shortName);
    this.dodsfile = dodsfile;
    this.dodsShortName = shortName;

    setDataType( DODSNetcdfFile.convertToNCType( elemType));
    ArrayList dims = dodsfile.constructDimensions( parentGroup, dodsArray);
    setDimensions(dims);
  }

  // need package access
  protected void calcIsCoordinateVariable() { super.calcIsCoordinateVariable(); }
 
  protected void setCE( String CE ){ this.CE = CE; }
  protected boolean hasCE(){ return CE != null; }
  protected String nameWithCE() { return hasCE() ? getShortName() + CE : getShortName(); }

  protected String getDODSshortName() { return dodsShortName; }

}

/* Change History:
   $Log: DODSVariable.java,v $
   Revision 1.12  2004/11/07 03:00:50  caron
   *** empty log message ***

   Revision 1.11  2004/11/07 02:55:11  caron
   no message

   Revision 1.10  2004/10/29 00:14:10  caron
   no message

   Revision 1.9  2004/10/19 19:46:18  caron
   change if dimensions are shared

   Revision 1.8  2004/09/28 21:25:39  caron
   add constructor, remove replaceDimension(int idx, Dimension dim)

   Revision 1.7  2004/08/19 21:38:12  caron
   no message

   Revision 1.6  2004/08/18 19:56:44  caron
   2.2 alpha (2)

   Revision 1.5  2004/08/17 19:20:06  caron
   2.2 alpha (2)

   Revision 1.4  2004/08/16 20:53:51  caron
   2.2 alpha (2)

   Revision 1.3  2004/07/12 23:40:18  caron
   2.2 alpha 1.0 checkin

   Revision 1.2  2004/07/06 19:28:12  caron
   pre-alpha checkin

   Revision 1.1.1.1  2003/12/04 21:05:28  caron
   checkin 2.2

   Revision 1.15  2003/09/05 00:03:39  caron
   minor

   Revision 1.14  2003/06/03 20:06:14  caron
   fix javadocs

   Revision 1.13  2003/05/23 18:49:30  caron
   no trailing ; in NCDump

   Revision 1.12  2003/05/06 23:12:25  caron
   always preload Strings in a single DODS call

   Revision 1.11  2003/04/18 23:02:42  caron
   allow CE in dataset name

   Revision 1.10  2003/04/08 15:06:32  caron
   nc2 version 2.1


   Revision 1.9  2002/08/01 20:05:31  jeffmc
   Override the implementation of the readArrays method in the NetcdfFile
   base class to do a bulk read.

   Code cleanup in DODSVariable.

   Added caching of non-scalar/non-character data in DODSVariable
   if the size of the Array is < some amount (100).

   Revision 1.8  2001/09/14 21:34:30  caron
   minor doc improvements, clean up debug flags

   Revision 1.7  2001/08/10 21:17:33  caron
   various changes part of Catalog/Agg Server

 */
