// $Id: VariableDS.java,v 1.11 2004/12/07 02:43:21 caron Exp $
/*
 * Copyright 1997-2004 Unidata Program Center/University Corporation for
 * Atmospheric Research, P.O. Box 3000, Boulder, CO 80307,
 * support@unidata.ucar.edu.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package ucar.nc2.dataset;

import ucar.ma2.*;
import ucar.nc2.*;

import java.io.IOException;
import java.util.List;

/**
 * An "enhanced" Variable.
 * @author John Caron
 * @version $Revision: 1.11 $ $Date: 2004/12/07 02:43:21 $
 */

public class VariableDS extends ucar.nc2.Variable implements VariableEnhanced {
  private EnhancementsImpl proxy;
  private EnhanceScaleMissingImpl smProxy;
  //protected Variable referencedVariable; // for NcML
  private ucar.nc2.ncml.Aggregation agg = null; // for NcML

  /** Constructor when theres no underlying variable. You better set the values too! */
  public VariableDS(NetcdfDataset ds, Group group, Structure parentStructure, String shortName,
      DataType dataType, String dims, String units, String desc) {

    super(ds, group, parentStructure, shortName);
    setDataType(dataType);
    setDimensions( dims);
    this.proxy = new EnhancementsImpl(units, desc);
    this.smProxy = new EnhanceScaleMissingImpl( null); // ??

    enhance();
  }

  /**
   * Wrap the given Variable, making it into an enhanced one.
   * @param ncVar the original Variable to wrap.
   */
  public VariableDS( ucar.nc2.Variable ncVar) {
    super(ncVar);
    if (ncVar instanceof VariableDS) {
      this.agg =  ((VariableDS) ncVar).agg;
    }

    this.proxy = new EnhancementsImpl( this);
    this.smProxy = new EnhanceScaleMissingImpl( ncVar);
    if (smProxy.hasScaleOffset() && (smProxy.getConvertedDataType() != ncVar.getDataType())) {
        setDataType( smProxy.getConvertedDataType());
    }
    enhance();
  }

  // override to kee section a VariableDS
  public Variable section(List section) throws InvalidRangeException  {
    Variable vs = new VariableDS( this);
    makeSection( vs, section);
    return vs;
  }

  // recalc any enhancement info NOT NEEDED ?
  protected void enhance() {
    //addAttribute( new Attribute("units", getUnitsString()));
    //if (getDescription() != null)
    //  addAttribute( new Attribute("long_name", getDescription()));

  }

  public void addCoordinateSystem(ucar.nc2.dataset.CoordinateSystem p0) {
    proxy.addCoordinateSystem( p0);
  }

  public java.util.List getCoordinateSystems() {
    return proxy.getCoordinateSystems();
  }

  public java.lang.String getDescription() {
    return proxy.getDescription();
  }

  public ucar.nc2.Variable getOriginalVariable() {
    return proxy.getOriginalVariable();
  }

  public java.lang.String getUnitsString() {
    return proxy.getUnitsString();
  }

  public double getValidMax() {
    return smProxy.getValidMax();
  }

  public double getValidMin() {
    return smProxy.getValidMin();
  }

  public boolean hasFillValue() {
    return smProxy.hasFillValue();
  }

  public boolean hasInvalidData() {
    return smProxy.hasInvalidData();
  }

  public boolean hasMissing() {
    return smProxy.hasMissing();
  }

  public boolean hasMissingValue() {
    return smProxy.hasMissingValue();
  }

  public boolean hasScaleOffset() {
    return smProxy.hasScaleOffset();
  }

  public boolean isFillValue(double p0) {
    return smProxy.isFillValue( p0);
  }

  public boolean isInvalidData(double p0) {
    return smProxy.isInvalidData( p0);
  }

  public boolean isMissing(double p0) {
    return smProxy.isMissing( p0);
  }

  public boolean isMissingValue(double p0) {
    return smProxy.isMissingValue( p0);
  }

  public void setFillValueIsMissing(boolean p0) {
    smProxy.setFillValueIsMissing( p0);
  }

  public void setInvalidDataIsMissing(boolean p0) {
    smProxy.setInvalidDataIsMissing( p0);
  }

  public void setMissingDataIsMissing(boolean p0) {
    smProxy.setMissingDataIsMissing( p0);
  }

  public void setUseNaNs(boolean useNaNs) {
    smProxy.setUseNaNs( useNaNs);
  }

  public void setAggregation( ucar.nc2.ncml.Aggregation agg) {this.agg = agg; }

  // regular Variables.
  protected Array _read() throws IOException {
    Array result = (agg != null) ? agg.read( this, null) : super._read();
    result = smProxy.convertScaleOffset( result);
    return result;
  }

  // section of regular Variable
  protected Array _read(java.util.List section) throws IOException, InvalidRangeException  {
    Array result = (agg != null) ? agg.read(this, null, section) : super._read(section);
    result = smProxy.convertScaleOffset( result);
    return result;
  }

  // structure-member Variables.
  protected Array _readMemberData(java.util.List section, boolean flatten) throws IOException, InvalidRangeException  {
    /* if (agg != null)
      return agg.readMemberData(section, flatten);
    else */
      return super._readMemberData(section, flatten);
  }

}

/* Change History:
   $Log: VariableDS.java,v $
   Revision 1.11  2004/12/07 02:43:21  caron
   *** empty log message ***

   Revision 1.10  2004/12/01 05:53:41  caron
   ncml pass 2, new convention parsing

   Revision 1.9  2004/11/21 01:16:47  caron
   ncml pass 1

   Revision 1.8  2004/11/07 03:00:49  caron
   *** empty log message ***

   Revision 1.7  2004/11/07 02:55:11  caron
   no message

   Revision 1.6  2004/10/29 00:14:10  caron
   no message

   Revision 1.5  2004/10/19 19:45:03  caron
   misc

   Revision 1.4  2004/09/22 18:43:02  caron
   move common to ucar.unidata; projections use Parameter, no tAttribute

   Revision 1.3  2004/08/26 17:55:08  caron
   no message

   Revision 1.2  2004/08/19 21:38:11  caron
   no message

   Revision 1.1  2004/08/16 20:53:48  caron
   2.2 alpha (2)

*/