// $Id: TransformType.java,v 1.2 2004/12/07 01:29:30 caron Exp $
/*
 * Copyright 2002-2004 Unidata Program Center/University Corporation for
 * Atmospheric Research, P.O. Box 3000, Boulder, CO 80307,
 * support@unidata.ucar.edu.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package ucar.nc2.dataset;

/**
 * Type-safe enumeration of netCDF Dataset TransformType.
 *
 * @author john caron
 * @version $Revision: 1.2 $ $Date: 2004/12/07 01:29:30 $
 */

public class TransformType {

  private static java.util.HashMap hash = new java.util.HashMap(10);

  public final static TransformType Projection = new TransformType("Projection");
  public final static TransformType Vertical = new TransformType("Vertical");
  public final static TransformType Radial = new TransformType("Radial");
  public final static TransformType Sigma = new TransformType("Sigma"); // deprecated ??

    private String _TransformType;
    private TransformType(String s) {
      this._TransformType = s;
      hash.put( s, this);
    }

  /**
   * Find the AxisType that matches this name.
   * @param name
   * @return AxisType or null if no match.
   */
  public static TransformType getType(String name) {
    if (name == null) return null;
    return (TransformType) hash.get( name);
  }

  /**
   * @return the string name.
   */
   public String toString() {
      return _TransformType;
  }

}


/**
 * $Log: TransformType.java,v $
 * Revision 1.2  2004/12/07 01:29:30  caron
 * redo convention parsing, use _Coordinate encoding.
 *
 * Revision 1.1  2004/08/16 20:53:48  caron
 * 2.2 alpha (2)
 *
 * Revision 1.3  2003/07/12 22:09:02  caron
 * add vertical transformations
 *
 * Revision 1.2  2003/06/03 20:06:08  caron
 * fix javadocs
 *
 * Revision 1.1  2003/04/08 15:06:25  caron
 * nc2 version 2.1
 *
 */
