package ucar.nc2.adde;

import ucar.nc2.StructureData;
import ucar.nc2.Variable;
import ucar.nc2.Structure;
import ucar.ma2.*;

import java.io.IOException;

/**
 * Created by IntelliJ IDEA.
 * User: john
 * Date: Aug 21, 2004
 * Time: 7:00:49 PM
 * To change this template use File | Settings | File Templates.
 */
public class StationStructData extends StructureData {
  private AddeStationDataset ncfile;
  private String stationName;
  private Variable obsVar;

  public StationStructData(AddeStationDataset ncfile, Structure s, Variable stationVar, String stationName, Variable obsVar) {
    super(s);
    this.ncfile = ncfile;
    this.stationName = stationName;
    this.obsVar = obsVar;

    ArrayObject.D0 stationNameArray = new ArrayObject.D0(String.class);
    stationNameArray.set(stationName);
    addMember( stationVar, stationNameArray);

    members.add( new ObsMember());
  }

  public class ObsMember extends StructureData.Member {
    private Array data;

    public Variable getV() {
      return obsVar;
    }

    public Array getData() {
      if (data == null)
        try {
          data = ncfile.makeStationObsArray(stationName);
        } catch (IOException e) {
          e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
      return data;
    }
  }
}
