package ucar.nc2.adde;

import ucar.nc2.StructureData;
import ucar.nc2.Variable;
import ucar.nc2.Structure;
import ucar.ma2.Array;
import java.util.ArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: john
 * Date: Aug 21, 2004
 * Time: 7:00:49 PM
 * To change this template use File | Settings | File Templates.
 */
public class AddeStructureData extends StructureData {
  private AddeStationDataset ncfile;
  private String stationName;
  private int nparams, row;

  public AddeStructureData(AddeStationDataset ncfile, Structure s, String stationName, int nparams, int row) {
    super(s);
    this.ncfile = ncfile;
    this.stationName = stationName;
    this.nparams = nparams;
    this.row = row;
  }

  public java.util.List getMemberNames() {
    return ncfile.getMemberNames();
  }

  ///////////////////////////
  public boolean getScalarBoolean(String memberName) {
    return false; // no booleans
  }

  /** Get byte value, from rank 0 member array.
   * @param memberName name of member Variable.
   * @throws IllegalArgumentException if name is not legal member name.
   */
  public byte getScalarByte(String memberName) {
    return ncfile.getByte(stationName, memberName, row);
  }

  /** Get double value, from rank 0 member array.
   * @param memberName name of member Variable.
   * @throws IllegalArgumentException if name is not legal member name.
   */
  public double getScalarDouble(String memberName) {
    return ncfile.getDouble(stationName, memberName, row);
  }

  /** Get float value, from rank 0 member array.
   * @param memberName name of member Variable.
   * @throws IllegalArgumentException if name is not legal member name.
   */
  public float getScalarFloat(String memberName) {
     return ncfile.getFloat(stationName, memberName, row);
  }

  /** Get int value, from rank 0 member array.
   * @param memberName name of a member Variable.
   * @throws IllegalArgumentException if name is not legal member name.
   */
  public int getScalarInt(String memberName) {
    return ncfile.getInt(stationName, memberName, row);
  }

  /** Get long value, from rank 0 member array.
   * @param memberName name of member Variable.
   * @throws IllegalArgumentException if name is not legal member name.
   */
  public long getScalarLong(String memberName) {
    return 0; // no longs
  }

  /** Get short value, from rank 0 member array.
   * @param memberName name of member Variable.
   * @throws IllegalArgumentException if name is not legal member name.
   */
  public short getScalarShort(String memberName) {
    return ncfile.getShort(stationName, memberName, row);
  }

  /** Get String value, from rank 0 String or rank 1 char member array.
   * @param memberName name of member Variable.
   * @throws IllegalArgumentException if name is not legal member name.
   */
  public String getScalarString(String memberName) {
    return ncfile.getString(stationName, memberName, row);
  }

  /**
   * Find the Array member with the specified name, or null if not found.
   */
  public Array findMemberArray(String memberName) {
    Member m = findMember(memberName);
    if (m == null) return null;
    return m.getData();
  }

  /////////////////////////////////////////////////

  /** Find the member by its short name.
   * @return StructureData.Member
   */
  public Member findMember(String memberName) {
    return new AddeMember( ncfile.findParam(memberName));
  }

  /**
   * Find a member, possibly nested in multiple structures. If any arrays, take first element.
   * @param fullName eg "name1.name2.name" (note no groups).
   * @return Member or null if not found.
   */
  public Member findNestedMember( String fullName) {
    return null;
  }

  /**
   * Get the list of members as StructureData.Member objects.
   * @return List of StructureData.Member
   */
  public java.util.List getMembers() {
    if (null == members) {
      members = new ArrayList( nparams);
      for (int i=0; i<nparams; i++) members.add( new AddeMember(i));
    }
    return members;
  }
  ArrayList members;

  public class AddeMember extends StructureData.Member {
     int param;

    AddeMember(int param) {
      this.param = param;
    }

    public Variable getV() {
      return ncfile.getVariable(param);
    }

    public Array getData() {
      return ncfile.getDataArray(stationName, param, row);
    }
  }
}
