// $Id: ImageUI.java,v 1.6 2004/10/07 22:15:13 caron Exp $
/*
 * Copyright 1997-2004 Unidata Program Center/University Corporation for
 * Atmospheric Research, P.O. Box 3000, Boulder, CO 80307,
 * support@unidata.ucar.edu.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package thredds.viewer;

import thredds.viewer.image.ImageViewPanel;

import thredds.ui.*;

import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.*;
import ucar.nc2.image.ImageDatasetFactory;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.awt.event.*;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.File;
import java.net.URL;
import java.net.MalformedURLException;
import javax.swing.*;

import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGCodec;

/**
 * This is the Thredds Data Viewer User Interface for Images.
 *
 * @author John Caron
 * @version $Id: ImageUI.java,v 1.6 2004/10/07 22:15:13 caron Exp $
 */
public class ImageUI extends JPanel {
  private UI topUI;
  private TopLevel topLevel;
  private PreferencesExt store;

  // main components
  private ImageViewPanel imageView;
  private Field.TextCombo imageUrlIF;

  // actions
  private AbstractAction misc;

  // state
  private thredds.catalog.InvDataset currentDataset = null;

  // debugging
  private boolean debugBeans = false, debugChooser = false, debugPrint = false, debugHelp = false;

  public ImageUI(PreferencesExt store, boolean addUrlWidget) {
    this.store = store;

    setLayout( new BorderLayout());
    imageView = new ImageViewPanel();
    add(new JScrollPane(imageView), BorderLayout.CENTER);

    if (addUrlWidget) {
      PrefPanel ivPP = new PrefPanel("ImageView", (PreferencesExt) store.node("ImageViewPrefs"));
      imageUrlIF = ivPP.addTextComboField("url", "Image Data URL", null, 10, true);
      ivPP.finish(true, BorderLayout.EAST);
      ivPP.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          // imageView.setImageFromUrl(imageUrlIF.getText());
        }
      });
      if (addUrlWidget) add(ivPP, BorderLayout.NORTH);
    }

  }

    /** save all data in the PersistentStore */
  public void save() {
  }

  private boolean selected = false;
  boolean isSelected() { return selected; }
  void setSelected( boolean b) {
    selected = b;
  }

  public void draw( boolean immed) {
    imageView.repaint();
  }

  //////////////

  void addActionsToMenus(JMenu infoMenu, JMenu configMenu, JMenu toolMenu) {
  }

  private ImageDatasetFactory imageFactory = new ImageDatasetFactory();
  public boolean setImageFromUrl( String location) {

    try {
      BufferedImage image = imageFactory.open( location);
      imageView.setImage( image);

    } catch (Exception e2) {
      javax.swing.JOptionPane.showMessageDialog(null, "Error on dataset = "+location+"\n"+imageFactory.getErrorMessages());
      // e2.printStackTrace();
      return false;
    }

    return true;
  }


}

/* Change History:
   $Log: ImageUI.java,v $
   Revision 1.6  2004/10/07 22:15:13  caron
   add simple image viewer in the NCdump panel

   Revision 1.5  2004/09/25 00:09:43  caron
   add images, thredds tab

   Revision 1.4  2004/09/24 03:26:37  caron
   merge nj22

   Revision 1.3  2004/05/11 23:30:37  caron
   release 2.0a

   Revision 1.2  2003/03/17 21:12:34  john
   new viewer

   Revision 1.1  2002/12/13 00:51:11  caron
   pass 2

   Revision 1.2  2002/04/29 22:39:21  caron
   add StationUI, clean up

   Revision 1.1.1.1  2002/02/26 17:24:49  caron
   import sources

*/


