// $Id: UrlAuthenticatorDialog.java,v 1.4 2004/09/30 00:33:39 caron Exp $
/*
 * Copyright 1997-2004 Unidata Program Center/University Corporation for
 * Atmospheric Research, P.O. Box 3000, Boulder, CO 80307,
 * support@unidata.ucar.edu.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package thredds.ui;

import java.awt.event.*;
import javax.swing.JButton;
import java.net.*;
import ucar.util.prefs.ui.*;

/**
 * @author John Caron
 * @version $Id: UrlAuthenticatorDialog.java,v 1.4 2004/09/30 00:33:39 caron Exp $
 */
public class UrlAuthenticatorDialog extends Authenticator {
  private IndependentDialog dialog;
  private PasswordAuthentication pwa = null;
  private Field.Text userF;
  private Field.Password passwF;
  private boolean debug = false;

  /** constructor
     @param parent      JFrame (application) or JApplet (applet)
   */
  public UrlAuthenticatorDialog(javax.swing.JFrame parent) {
    PrefPanel pp = new PrefPanel("UrlAuthenticatorDialog", null);
    userF = pp.addTextField("user", "User", "              ");
    passwF = pp.addPasswordField("password", "Password", "           ");
    pp.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        pwa = new PasswordAuthentication(userF.getText(), passwF.getPassword());
        dialog.setVisible( false);
      }
    });
      // button to dismiss
    JButton cancel = new JButton("Cancel");
    pp.addButton(cancel);
    cancel.addActionListener( new ActionListener() {
      public void actionPerformed(ActionEvent evt) {
        pwa = null;
        dialog.setVisible( false);
      }
    });
    pp.finish();

    dialog = new IndependentDialog(parent, true, "HTTP Authentication", pp);
    dialog.setLocationRelativeTo(parent);
    dialog.setLocation(100, 100);
  }

  protected PasswordAuthentication getPasswordAuthentication() {

    if (debug) {
      System.out.println("site= " + getRequestingSite());
      System.out.println("port= " + getRequestingPort());
      System.out.println("protocol= " + getRequestingProtocol());
      System.out.println("prompt= " + getRequestingPrompt());
      System.out.println("scheme= " + getRequestingScheme());
    }

    dialog.show();

     if (debug && pwa != null) {
      System.out.println("user= "+pwa.getUserName());
      System.out.println("password= "+pwa.getPassword());
    }
    return pwa;
  }
}

/* Change History:
   $Log: UrlAuthenticatorDialog.java,v $
   Revision 1.4  2004/09/30 00:33:39  caron
   *** empty log message ***

   Revision 1.3  2004/09/24 03:26:35  caron
   merge nj22

   Revision 1.2  2004/05/11 23:30:36  caron
   release 2.0a

   Revision 1.1  2003/01/18 19:53:44  john
   url authenticator, better logging

   Revision 1.1.1.1  2002/11/23 17:49:48  caron
   thredds reorg

   Revision 1.1.1.1  2002/02/15 00:01:49  caron
   import sources

*/

