// $Id: DateField.java,v 1.4 2004/11/07 03:00:47 caron Exp $
/*
 * Copyright 1997-2004 Unidata Program Center/University Corporation for
 * Atmospheric Research, P.O. Box 3000, Boulder, CO 80307,
 * support@unidata.ucar.edu.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package thredds.datatype.prefs;

import thredds.catalog.*;
import thredds.datatype.*;

import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.Field;
import ucar.util.prefs.ui.PersistenceManager;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.text.*;
import java.util.*;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.text.html.*;

/**
 *  Date input field for thredds.catalog.DateType.
 *
 * @see ucar.util.prefs.ui.Field
 * @author John Caron
 * @version $Id: DateField.java,v 1.4 2004/11/07 03:00:47 caron Exp $
 */

public class DateField extends ucar.util.prefs.ui.Field {

    protected JTextComponent tf;

    /** Constructor.
     *  @param name of the field; must be unique within the store
     *  @param label to display to the user
     *  @param defValue default value to start with.
     *  @param storeData store/fetch data from here, may be null.
     */
    public DateField(String name, String label, DateType defValue, PersistenceManager storeData) {
      super(name, label, storeData);
      acceptedValue = getStoreValue( defValue);
      tf = new JTextField() {
        public JToolTip createToolTip() { return new thredds.ui.MultilineTooltip(); }
      };

      if (acceptedValue != null)
        tf.setText(acceptedValue.toString());
      tf.setToolTipText("Formats:\n 'present'\n CCYY-MM-DD\n CCYY-MM-DDThh:mm:ss\n udunits date string");
    }

    // return the editing JComponent
    public JComponent getEditComponent() { return tf; }

   /** See if edit value is valid, put error message in buff. */
    protected boolean validate( StringBuffer buff) {
      try {
        DateType tryit = new DateType( tf.getText(), null, null);
        return true;
      } catch (java.text.ParseException e) {
        buff.append( name+": "+e.getMessage());
        return false;
      }
    }

  // get current value from editComponent
  public Object getEditValue() {
    try {
      DateType tryit = new DateType( tf.getText(), null, null);
      return tryit;
    } catch (java.text.ParseException e) {
      return null;
    }
 }

   // get current value from editComponent
   public DateType getDate() {
     return (DateType) getEditValue();
  }

    // set current value of editComponent
    public void setEditValue(Object value) {
      tf.setText(value.toString());
    }

    // set a new value into the Store
    // return true if different from old value
    protected void setStoreValue( Object value) {
      if (storeData != null)
        storeData.putObject(name, value);
    }

    /* get value from store, put value into editComponent */
    public Object getStoreValue( Object defValue) {
      Object value = null;
      if (storeData != null) {
        value = storeData.getObject(name);
      }
      return (value == null) ? defValue : value;
    }

}

/* Change History:
   $Log: DateField.java,v $
   Revision 1.4  2004/11/07 03:00:47  caron
   *** empty log message ***

   Revision 1.3  2004/10/06 19:03:39  caron
   clean up javadoc
   change useV3 -> useRecordsAsStructure
   remove id, title, from NetcdfFile constructors
   add "in memory" NetcdfFile

   Revision 1.2  2004/09/24 03:26:33  caron
   merge nj22

   Revision 1.1  2004/05/11 23:30:34  caron
   release 2.0a

*/

