// $Id: GrADSDataServerDatasetSource.java,v 1.2 2004/11/30 22:49:12 edavis Exp $

/*
 * Copyright 2002 Unidata Program Center/University Corporation for
 * Atmospheric Research, P.O. Box 3000, Boulder, CO 80307,
 * support@unidata.ucar.edu.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package thredds.cataloggen.config;

import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDataset;
import org.apache.log4j.Logger;

import java.util.List;

public class GrADSDataServerDatasetSource extends DatasetSource
{
  private static Logger logger = Logger.getLogger( GrADSDataServerDatasetSource.class.getName());

  public GrADSDataServerDatasetSource()
  {
    this.type = DatasetSourceType.getType( "GrADSDataServer");
  }

  // @todo Implement the GrADSDataServer type of DatasetSource.
  public void expandThisType( InvDatasetImpl parentDs, String givenLocation)
  {
    logger.warn( "expandThisType(): The DatasetSource \"" + this.getName() +
            "\" (" + givenLocation + ") could not be expanded. The GrADSDataServer type of" +
            " DatasetSource is not yet fully implemented.");
    InvDatasetImpl tmpDs = null;
    tmpDs = new InvDatasetImpl( null, "The DatasetSource \"" + this.getName() +
            "\" (" + givenLocation + ") could not be expanded. The GrADSDataServer type of" +
            " DatasetSource is not yet fully implemented.");
    parentDs.addDataset( tmpDs);
  }

  protected InvDataset getTopLevelDataset()
  {
    return null;  //To change body of implemented methods use File | Settings | File Templates.
  }

  protected boolean isCollection( InvDataset dataset )
  {
    return false;  //To change body of implemented methods use File | Settings | File Templates.
  }

  protected List expandThisLevel( InvDataset collectionDataset )
  {
    return null;  //To change body of implemented methods use File | Settings | File Templates.
  }
}

/*
 * $Log: GrADSDataServerDatasetSource.java,v $
 * Revision 1.2  2004/11/30 22:49:12  edavis
 * Start changing DatasetSource into a more usable API.
 *
 * Revision 1.1  2003/08/29 21:41:47  edavis
 * The following changes where made:
 *
 *  1) Added more extensive logging (changed from thredds.util.Log and
 * thredds.util.Debug to using Log4j).
 *
 * 2) Improved existing error handling and added additional error
 * handling where problems could fall through the cracks. Added some
 * catching and throwing of exceptions but also, for problems that aren't
 * fatal, added the inclusion in the resulting catalog of datasets with
 * the error message as its name.
 *
 * 3) Change how the CatGenTimerTask constructor is given the path to the
 * config files and the path to the resulting files so that resulting
 * catalogs are placed in the servlet directory space. Also, add ability
 * for servlet to serve the resulting catalogs.
 *
 * 4) Switch from using java.lang.String to using java.io.File for
 * handling file location information so that path seperators will be
 * correctly handled. Also, switch to java.net.URI rather than
 * java.io.File or java.lang.String where necessary to handle proper
 * URI/URL character encoding.
 *
 * 5) Add handling of requests when no path ("") is given, when the root
 * path ("/") is given, and when the admin path ("/admin") is given.
 *
 * 6) Fix the PUTting of catalogGenConfig files.
 *
 * 7) Start adding GDS DatasetSource capabilities.
 *
 */