package thredds.cataloggen.config;

import thredds.catalog.*;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * <p>Title: Catalog Generator</p>
 * <p>Description: Tool for generating THREDDS catalogs.</p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: UCAR/Unidata</p>
 * @author Ethan Davis
 * @version $Id: BadDatasetSource.java,v 1.5 2004/11/30 22:49:12 edavis Exp $
 */

public class BadDatasetSource extends DatasetSource
{
  private static Logger logger = Logger.getLogger( BadDatasetSource.class.getName());

  public BadDatasetSource()
  {
      this.type = null;
  }

  public void expandThisType( InvDatasetImpl parentDs, String givenLocation)
  {
    logger.warn( "expandThisType(): The DatasetSource \"" + this.getName() +
            "\" (" + givenLocation + ") could not be expanded because it has an unknown type.");
    InvDatasetImpl curDs = null;
    curDs = new InvDatasetImpl( null, "The DatasetSource \"" + this.getName() +
            "\" (" + givenLocation + ") could not be expanded because it has an unknown type.");
    parentDs.addDataset( curDs);
  }

  protected InvDataset getTopLevelDataset()
  {
    return null;  //To change body of implemented methods use File | Settings | File Templates.
  }

  protected boolean isCollection( InvDataset dataset )
  {
    return false;  //To change body of implemented methods use File | Settings | File Templates.
  }

  protected List expandThisLevel( InvDataset collectionDataset )
  {
    return null;  //To change body of implemented methods use File | Settings | File Templates.
  }
}