// $Id: CatalogRefGroupItem.java,v 1.1 2004/12/14 22:47:22 edavis Exp $
package thredds.cataloggen;

import thredds.catalog.InvCatalog;

/**
 * A container for an InvCatalog to keep track of its title and relative file name.
 *
 * Used by a CatalogRefGroup to track catalogs related by catalogRefs.
 */
public class CatalogRefGroupItem
{
  private String title;
  private String fileName;
  private InvCatalog catalog;

  public String getTitle()
  {
    return title;
  }

  public void setTitle( String title )
  {
    this.title = title;
  }

  public String getFileName()
  {
    return fileName;
  }

  public void setFileName( String fileName )
  {
    this.fileName = fileName;
  }

  public InvCatalog getCatalog()
  {
    return catalog;
  }

  public void setCatalog( InvCatalog catalog )
  {
    this.catalog = catalog;
  }
}

/*
 * $Log: CatalogRefGroupItem.java,v $
 * Revision 1.1  2004/12/14 22:47:22  edavis
 * Add simple interface to thredds.cataloggen and continue adding catalogRef capabilities.
 *
 * Revision 1.1  2004/11/30 23:58:56  edavis
 * Initial attempt at a way to keep track of a group of catalogs contected by CatalogRefs.
 *
 */