// $Id: CatalogRefGroup.java,v 1.1 2004/11/30 23:58:56 edavis Exp $
package thredds.cataloggen;

import org.apache.log4j.Logger;

import java.util.*;

import thredds.catalog.InvCatalog;

/**
 * Represents an InvCatalog and any InvCatalogs related by relative (not absolute)
 * catalogRefs.
 *
 * Implements a java.util.Map where the keys must be Strings
 * and the values must be InvCatalogs. No null keys or values are allowed.
 */
public class CatalogRefGroup implements Map
{
  private static Logger logger = Logger.getLogger( CatalogRefGroup.class.getName() );

  private HashMap map = new HashMap();

  private String topCatalogName = null;

  public CatalogRefGroup()
  {}

  public void setTopCatalogName( String topCatName)
  {
    if ( topCatName == null ) throw new NullPointerException( "Given name is null");
    this.topCatalogName = topCatName;
  }
  public String getTopCatalogName() { return( this.topCatalogName); }

  public int size()
  {
    return( this.map.size());
  }

  public void clear()
  {
    this.map.clear();
  }

  public boolean isEmpty()
  {
    return( this.map.isEmpty());
  }

  public boolean containsKey( Object key )
  {
    if ( key == null) throw new NullPointerException( "Null map key");
    if ( ! (key instanceof String)) throw new ClassCastException( "Map key not a String");

    return( this.map.containsKey( key));
  }

  public boolean containsValue( Object value )
  {
    if ( value == null) throw new NullPointerException( "Null map value");
    if ( ! (value instanceof InvCatalog)) throw new ClassCastException( "Map value not a InvCatalog");

    return( this.map.containsValue( value));
  }

  public Collection values()
  {
    return( this.map.values());
  }

  public Set entrySet()
  {
    return( this.map.entrySet());
  }

  public Set keySet()
  {
    return( this.map.keySet());
  }

  public Object get( Object key )
  {
    if ( key == null) throw new NullPointerException( "Null map key");
    if ( ! (key instanceof String)) throw new ClassCastException( "Map key not a String");

    return( this.map.get( key));
  }

  public Object remove( Object key )
  {
    if ( key == null) throw new NullPointerException( "Null map key");
    if ( ! (key instanceof String)) throw new ClassCastException( "Map key not a String");

    return( this.map.remove( key));
  }

  public Object put( Object key, Object value)
  {
    if ( key == null || value == null) throw new NullPointerException( "Map key or value null");
    if ( key instanceof String )
      throw new ClassCastException( "Map key not a String");
    if ( value instanceof InvCatalog )
      throw new ClassCastException( "Map value not an InvCatalog");
    if ( this.map.containsKey( key)) throw new IllegalArgumentException( "Map key <" + key + "> already mapped");

    Object shouldBeNull = this.map.put( key, value);
    // assert shouldBeNull == null;
    return( shouldBeNull);
  }

  public void putAll( Map t )
  {
    if ( t == null) throw new NullPointerException( "Null map");
    if ( ! (t instanceof CatalogRefGroup)) throw new IllegalArgumentException( "Given map not a CatalogRefGroup");
    for (Iterator i = t.keySet().iterator(); i.hasNext(); )
    {
      String curKey = (String) i.next();
      this.map.put( curKey, t.get( curKey));
    }
  }
}

/*
 * $Log: CatalogRefGroup.java,v $
 * Revision 1.1  2004/11/30 23:58:56  edavis
 * Initial attempt at a way to keep track of a group of catalogs contected by CatalogRefs.
 *
 */