// $Id: MetadataConverterIF.java,v 1.4 2004/09/24 03:26:27 caron Exp $
/*
 * Copyright 1997-2004 Unidata Program Center/University Corporation for
 * Atmospheric Research, P.O. Box 3000, Boulder, CO 80307,
 * support@unidata.ucar.edu.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package thredds.catalog;

/**
 * Converts XML DOM to Objects holding metadata content.
 *
 * @see InvCatalogConvertIF
 * @see InvCatalogFactory
 * @author John Caron
 * @version $Id: MetadataConverterIF.java,v 1.4 2004/09/24 03:26:27 caron Exp $
 */

public interface MetadataConverterIF {

   /**
    * Create an InvMetadata content object from an org.w3c.dom.Element.
    *
    * @param dataset : the containing dataset
    * @param mdataElement : the metadata XML element in a org.w3c.dom.Element.
    * @return an object representing the metadata content. The type depends on the metadata handler.
    */
  public Object readMetadataContent( InvDataset dataset, org.w3c.dom.Element mdataElement);

  /**
   * Create an InvMetadata content object from an XML document at a named URL.
   *
   * @param dataset : the containing dataset
   * @param uri : the URI that the XML doc is at.
   * @return an object representing the metadata content. The type depends on the metadata handler.
   *
   * @throws IOException
   */
  public Object readMetadataContentFromURL( InvDataset dataset, java.net.URI uri) throws java.io.IOException;


   /**
    * Serialize the InvMetadata content object to a org.w3c.dom.Element
    *
    * @param mdataElement : the org.w3c.dom.Element to add to
    * @param contentObject : the content object
    * @return an org.w3c.dom.Element representing the content, to be added as child elements of
    *  the InvMetadata element.
    */
  public void addMetadataContent( org.w3c.dom.Element mdataElement, Object contentObject);

  /**
   * Validate internal data structures.
   * @param contentObject : the content object
   * @param out : print errors here
   * @return true if no fatal validation errors.
   */
  public boolean validateMetadataContent(Object contentObject, StringBuffer out);


}

/* Change History:
   $Log: MetadataConverterIF.java,v $
   Revision 1.4  2004/09/24 03:26:27  caron
   merge nj22

   Revision 1.3  2004/05/21 05:57:31  caron
   release 2.0b

   Revision 1.2  2004/05/11 23:30:28  caron
   release 2.0a

   Revision 1.1  2004/02/20 00:49:51  caron
   1.3 changes

   Revision 1.2  2003/01/27 20:23:25  john
   notes

   Revision 1.1.1.1  2002/11/23 17:49:45  caron
   thredds reorg

   Revision 1.2  2002/09/18 16:24:11  caron
   version 0.6 release

   Revision 1.1  2002/06/28 21:28:21  caron
   create vresion 6 object model

 */