// $Id: CollectionType.java,v 1.1 2004/05/11 23:30:26 caron Exp $
/*
 * Copyright 2002 Unidata Program Center/University Corporation for
 * Atmospheric Research, P.O. Box 3000, Boulder, CO 80307,
 * support@unidata.ucar.edu.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package thredds.catalog;

/**
 * Type-safe enumeration of THREDDS coherent collection types.
 *
 * @author john caron
 * @version $Revision: 1.1 $ $Date: 2004/05/11 23:30:26 $
 */

public final class CollectionType {
    private static java.util.LinkedHashMap hash = new java.util.LinkedHashMap(10);

    public final static CollectionType NONE = new CollectionType("");

    public final static CollectionType TIMESERIES = new CollectionType("TimeSeries");
    public final static CollectionType STATIONS = new CollectionType("Stations");

    public static java.util.Collection getAllTypes() { return hash.values(); }

    private String name;
    public CollectionType(String s) {
      this.name = s;
      hash.put( s, this);
    }

    /**
     * Find the CollectionType that matches this name.
     * @param name : name to match
     * @return CollectionType or null if no match.
     */
    public static CollectionType getType(String name) {
      if (name == null) return null;
      return (CollectionType) hash.get( name);
    }

    /**
     * @return the string name.
     */
     public String toString() {
        return name;
    }

     /** Override Object.hashCode() to be consistent with this equals. */
     public int hashCode() { return name.hashCode(); }
     /** CollectionType with same name are equal. */
     public boolean equals(Object o) {
       if (this == o) return true;
       if (!(o instanceof CollectionType)) return false;
       return o.hashCode() == this.hashCode();
    }
}


/**
 * $Log: CollectionType.java,v $
 * Revision 1.1  2004/05/11 23:30:26  caron
 * release 2.0a
 *
 * Revision 1.5  2004/02/20 00:49:49  caron
 * 1.3 changes
 *
 * Revision 1.4  2003/05/29 21:22:42  john
 * getAllTypes()
 *
 * Revision 1.3  2003/03/17 21:29:14  john
 * fix bugs
 *
 * Revision 1.2  2003/03/07 21:12:34  edavis
 * Added GIF instance.
 *
 * Revision 1.1.1.1  2002/11/23 17:49:45  caron
 * thredds reorg
 *
 * Revision 1.4  2002/06/28 21:28:09  caron
 * create vresion 6 object model
 *
 * Revision 1.3  2002/03/22 22:55:45  caron
 * add Station type
 *
 * Revision 1.2  2002/03/09 01:45:46  caron
 * better javadoc
 *
 * Revision 1.1.1.1  2002/02/26 17:24:38  caron
 * import sources
 *
 */
