/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.ExtBufferedInputStream;
import HTTPClient.GlobalConstants;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.RespInputStream;
import HTTPClient.Response;
import HTTPClient.StreamDemultiplexor;
import HTTPClient.Util;
import java.io.IOException;

final class ResponseHandler
implements GlobalConstants {
    RespInputStream stream;
    Response resp;
    Request request;
    boolean eof = false;
    IOException exception = null;
    private byte[] endbndry = null;
    private int[] end_cmp = null;

    ResponseHandler(Response response, Request request, StreamDemultiplexor streamDemultiplexor) {
        this.resp = response;
        this.request = request;
        this.stream = new RespInputStream(streamDemultiplexor, this);
        if (GlobalConstants.DebugDemux) {
            System.err.println("Demux: Opening stream " + this.stream.hashCode() + " (" + " (" + streamDemultiplexor.hashCode() + ") (" + Thread.currentThread() + ")");
        }
    }

    byte[] getEndBoundary(ExtBufferedInputStream extBufferedInputStream) throws IOException, ParseException {
        if (this.endbndry == null) {
            this.setupBoundary(extBufferedInputStream);
        }
        return this.endbndry;
    }

    int[] getEndCompiled(ExtBufferedInputStream extBufferedInputStream) throws IOException, ParseException {
        if (this.end_cmp == null) {
            this.setupBoundary(extBufferedInputStream);
        }
        return this.end_cmp;
    }

    void setupBoundary(ExtBufferedInputStream extBufferedInputStream) throws IOException, ParseException {
        String string = "--" + Util.getParameter("boundary", this.resp.getHeader("Content-Type")) + "--\r\n";
        this.endbndry = new byte[string.length()];
        string.getBytes(0, this.endbndry.length, this.endbndry, 0);
        this.end_cmp = Util.compile_search(this.endbndry);
        extBufferedInputStream.initMark();
    }
}

