/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp.util;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;

public class RETest {
    private RETest() {
    }

    public static void main(String[] stringArray) throws REException {
        System.out.println("gnu.regexp version " + RE.version());
        int n = 1;
        if (stringArray.length == 3) {
            n = Integer.parseInt(stringArray[2]);
        }
        if (stringArray.length < 2) {
            System.out.println("usage: java gnu.regexp.util.RETest regExp inputString [numRepeats]");
            System.exit(1);
        }
        RE rE = null;
        long l = System.currentTimeMillis();
        int n2 = 0;
        while (n2 < n) {
            rE = new RE(stringArray[0]);
            ++n2;
        }
        long l2 = System.currentTimeMillis();
        if (n > 1) {
            System.out.println("Compiling " + n + " times took " + (l2 - l) + " ms");
            System.out.println("Average compile time: " + (l2 - l) / (long)n + " ms");
        }
        System.out.println("        Input Text: " + stringArray[1]);
        System.out.println("Regular Expression: " + stringArray[0]);
        System.out.println("     Compiled Form: " + rE);
        System.out.println(" isMatch() returns: " + rE.isMatch(stringArray[1]));
        REMatch[] rEMatchArray = rE.getAllMatches(stringArray[1]);
        System.out.println("   getAllMatches(): " + rEMatchArray.length + " matches");
        int n3 = 0;
        while (n3 < rEMatchArray.length) {
            System.out.println("Match " + n3 + " (" + rEMatchArray[n3].getStartIndex() + "," + rEMatchArray[n3].getEndIndex() + "): " + rEMatchArray[n3]);
            ++n3;
        }
        REMatch rEMatch = null;
        l = System.currentTimeMillis();
        int n4 = 0;
        while (n4 < n) {
            rEMatch = rE.getMatch(stringArray[1]);
            ++n4;
        }
        l2 = System.currentTimeMillis();
        if (n > 1) {
            System.out.println("Finding first match " + n + " times took " + (l2 - l) + " ms");
            System.out.println("Average match time: " + (l2 - l) / (long)n + " ms");
        }
        if (rEMatch == null) {
            System.out.println("Expression did not find a match.");
        } else {
            System.out.println("Match found from position " + rEMatch.getStartIndex() + " to position " + rEMatch.getEndIndex());
            System.out.println("Match was: '" + rEMatch + "'");
            int n5 = 1;
            while (n5 <= rE.getNumSubs()) {
                if (rEMatch.getSubStartIndex(n5) > -1) {
                    System.out.println("Subexpression #" + n5 + ": from position " + rEMatch.getSubStartIndex(n5) + " to position " + rEMatch.getSubEndIndex(n5));
                    System.out.println(rEMatch.substituteInto("The subexpression matched this text: '$" + n5 + "'"));
                }
                ++n5;
            }
        }
        System.out.println("substitute(): " + rE.substitute(stringArray[1], "<!--$0-->"));
        System.out.println("substituteAll(): " + rE.substituteAll(stringArray[1], "<!--$0-->"));
    }
}

