/*
 * Decompiled with CFR 0.152.
 */
package dods.util.geturl.gui;

import dods.dap.StatusUI;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;

public class StatusWindow
extends Frame
implements StatusUI {
    private Label urlLabel;
    private int bytesRead = 0;
    private long startTime;
    private long lastUpdateTime;
    private boolean cancelPushed = false;
    private Label bytesReadLabel;
    private Label transferRateLabel;
    private Button cancelButton;
    NumberFormat nf = NumberFormat.getInstance();

    public StatusWindow(String string) {
        super("Status Window");
        this.setSize(450, 150);
        Label label = new Label("Retrieving:");
        this.urlLabel = new Label(string);
        Label label2 = new Label("Bytes Read:");
        this.bytesReadLabel = new Label("                   ");
        Label label3 = new Label("Transfer Rate:");
        this.transferRateLabel = new Label("                   ");
        this.cancelButton = new Button("Cancel Download");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.urlLabel, gridBagConstraints);
        this.add(this.urlLabel);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.add(label2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.bytesReadLabel, gridBagConstraints);
        this.add(this.bytesReadLabel);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.add(label3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.transferRateLabel, gridBagConstraints);
        this.add(this.transferRateLabel);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusWindow.this.programCancel();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StatusWindow.this.programCancel();
                StatusWindow.this.dispose();
            }
        });
        this.startTime = this.lastUpdateTime = System.currentTimeMillis();
        this.show();
    }

    public void incrementByteCount(int n) {
        this.bytesRead += n;
        long l = System.currentTimeMillis();
        if (l - this.lastUpdateTime > 200L) {
            float f;
            if (this.bytesRead > 0x100000) {
                f = (float)this.bytesRead / 1048576.0f;
                this.bytesReadLabel.setText(this.nf.format(f) + " MB");
            } else if (this.bytesRead > 1024) {
                f = (float)this.bytesRead / 1024.0f;
                this.bytesReadLabel.setText(this.nf.format(f) + " K");
            } else {
                this.bytesReadLabel.setText(this.nf.format(this.bytesRead));
            }
            this.bytesReadLabel.repaint();
            f = (float)this.bytesRead / (float)(l - this.startTime) * 1000.0f;
            if (f > 1048576.0f) {
                float f2 = f / 1048576.0f;
                this.transferRateLabel.setText(this.nf.format(f2) + " MB/sec");
            } else if (f > 1024.0f) {
                float f3 = f / 1024.0f;
                this.transferRateLabel.setText(this.nf.format(f3) + " K/sec");
            } else {
                this.transferRateLabel.setText(this.nf.format(f) + "bytes/sec");
            }
            this.transferRateLabel.repaint();
            this.lastUpdateTime = l;
        }
    }

    public synchronized boolean userCancelled() {
        if (this.cancelPushed) {
            this.dispose();
        }
        return this.cancelPushed;
    }

    public void finished() {
        this.dispose();
    }

    public synchronized void programCancel() {
        this.cancelPushed = true;
    }
}

