/*
 * Decompiled with CFR 0.152.
 */
package dods.util.geturl.gui;

import dods.dap.DAS;
import dods.dap.DConnect;
import dods.dap.DDS;
import dods.dap.DataDDS;
import dods.util.geturl.gui.StatusWindow;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class GeturlFrame
extends Frame {
    protected boolean isApplet;
    protected TextField urlField;
    protected TextArea outputArea;
    protected Button getDASButton;
    protected Button getDDSButton;
    protected Button getDataButton;

    public GeturlFrame(boolean bl) {
        super("DODS Geturl Applet");
        this.setSize(640, 480);
        this.isApplet = bl;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        Label label = new Label("URL:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 4;
        this.urlField = new TextField(70);
        gridBagLayout.setConstraints(this.urlField, gridBagConstraints);
        this.add(this.urlField);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        this.getDASButton = new Button("Get DAS");
        this.getDASButton.addActionListener(new GetDASListener());
        gridBagLayout.setConstraints(this.getDASButton, gridBagConstraints);
        this.add(this.getDASButton);
        this.getDDSButton = new Button("Get DDS");
        this.getDDSButton.addActionListener(new GetDDSListener());
        gridBagLayout.setConstraints(this.getDDSButton, gridBagConstraints);
        this.add(this.getDDSButton);
        this.getDataButton = new Button("Get Data");
        this.getDataButton.addActionListener(new GetDataListener());
        gridBagLayout.setConstraints(this.getDataButton, gridBagConstraints);
        this.add(this.getDataButton);
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.outputArea = new TextArea(100, 200);
        this.outputArea.setEditable(false);
        gridBagLayout.setConstraints(this.outputArea, gridBagConstraints);
        this.add(this.outputArea);
        this.addWindowListener(new WindowClosedListener(this));
        this.show();
    }

    private void setButtonsEnabled(boolean bl) {
        this.getDASButton.setEnabled(bl);
        this.getDDSButton.setEnabled(bl);
        this.getDataButton.setEnabled(bl);
    }

    private class WindowClosedListener
    extends WindowAdapter {
        GeturlFrame myFrame;

        WindowClosedListener(GeturlFrame geturlFrame2) {
            this.myFrame = geturlFrame2;
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.myFrame.dispose();
            if (!this.myFrame.isApplet) {
                System.exit(0);
            }
        }
    }

    private class GetDataListener
    implements ActionListener,
    Runnable {
        private GetDataListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                GeturlFrame.this.setButtonsEnabled(false);
                Thread thread = new Thread(this);
                thread.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                GeturlFrame.this.outputArea.setText(illegalThreadStateException.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
        }

        public void run() {
            try {
                DConnect dConnect = new DConnect(GeturlFrame.this.urlField.getText());
                DataDDS dataDDS = dConnect.getData(new StatusWindow(GeturlFrame.this.urlField.getText()));
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                dataDDS.printVal(new PrintWriter(charArrayWriter));
                GeturlFrame.this.outputArea.setText(charArrayWriter.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
            catch (Exception exception) {
                GeturlFrame.this.outputArea.setText(exception.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
        }
    }

    private class GetDDSListener
    implements ActionListener,
    Runnable {
        private GetDDSListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                GeturlFrame.this.setButtonsEnabled(false);
                Thread thread = new Thread(this);
                thread.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                GeturlFrame.this.outputArea.setText(illegalThreadStateException.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
        }

        public void run() {
            try {
                DConnect dConnect = new DConnect(GeturlFrame.this.urlField.getText());
                DDS dDS = dConnect.getDDS();
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                dDS.print(new PrintWriter(charArrayWriter));
                GeturlFrame.this.outputArea.setText(charArrayWriter.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
            catch (Exception exception) {
                GeturlFrame.this.outputArea.setText(exception.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
        }
    }

    private class GetDASListener
    implements ActionListener,
    Runnable {
        private GetDASListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                GeturlFrame.this.setButtonsEnabled(false);
                Thread thread = new Thread(this);
                thread.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                GeturlFrame.this.outputArea.setText(illegalThreadStateException.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
        }

        public void run() {
            try {
                DConnect dConnect = new DConnect(GeturlFrame.this.urlField.getText());
                DAS dAS = dConnect.getDAS();
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                dAS.print(new PrintWriter(charArrayWriter));
                GeturlFrame.this.outputArea.setText(charArrayWriter.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
            catch (Exception exception) {
                GeturlFrame.this.outputArea.setText(exception.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
        }
    }
}

