/*
 * Decompiled with CFR 0.152.
 */
package dods.servlet;

import dods.dap.Attribute;
import dods.dap.AttributeTable;
import dods.dap.BaseType;
import dods.dap.BaseTypePrimitiveVector;
import dods.dap.DAS;
import dods.dap.DArray;
import dods.dap.DConstructor;
import dods.dap.DODSException;
import dods.dap.DString;
import dods.dap.DVector;
import dods.dap.PrimitiveVector;
import dods.dap.Server.ServerDDS;
import dods.dap.parser.ParseException;
import dods.servlet.GuardedDataset;
import dods.servlet.requestState;
import dods.util.dasTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;

public class dodsINFO {
    private static final boolean _Debug = true;
    private String infoDir = null;

    public void sendINFO(PrintStream printStream, GuardedDataset guardedDataset, requestState requestState2) throws DODSException, ParseException {
        System.out.println("dods.servlet.dodsINFO.sendINFO() reached.");
        String string = null;
        ServerDDS serverDDS = null;
        DAS dAS = null;
        serverDDS = guardedDataset.getDDS();
        dAS = guardedDataset.getDAS();
        this.infoDir = requestState2.getInitParameter("INFOcache");
        if (this.infoDir == null) {
            this.infoDir = "/home/dods/info/";
        }
        if ((string = this.loadOverrideDoc(this.infoDir, requestState2.getDataSet())) != null) {
            System.out.println("override document: " + string);
            printStream.print(string);
        } else {
            String string2 = this.get_user_supplied_docs(requestState2.getServerName(), requestState2.getDataSet());
            String string3 = this.buildGlobalAttributes(dAS, serverDDS);
            String string4 = this.buildVariableSummaries(dAS, serverDDS);
            printStream.println("<html><head><title>Dataset Information</title>");
            printStream.println("<style type=\"text/css\">");
            printStream.println("<!-- ul {list-style-type: none;} -->");
            printStream.println("</style>");
            printStream.println("</head>");
            printStream.println("<body>");
            if (string3.length() > 0) {
                printStream.println(string3);
                printStream.println("<hr>");
            }
            printStream.println(string4);
            printStream.println("<hr>");
            printStream.println(string2);
            printStream.println("</body></html>");
            printStream.flush();
        }
    }

    public String loadOverrideDoc(String string, String string2) throws DODSException {
        String string3 = "";
        String string4 = string2 + ".ovr";
        try {
            File file = new File(string + string4);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            boolean bl = false;
            while (!bl) {
                String string5 = bufferedReader.readLine();
                if (string5 == null) {
                    bl = true;
                    continue;
                }
                string3 = string3 + string5 + "\n";
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            string3 = string3 + "<h2>No Could Not Open Override Document.</h2><hr>";
            return null;
        }
        catch (IOException iOException) {
            throw new DODSException(0, iOException.getMessage());
        }
        return string3;
    }

    private String get_user_supplied_docs(String string, String string2) throws DODSException {
        Object object;
        Object object2;
        String string3 = "";
        try {
            object2 = new File(this.infoDir + string2 + ".html");
            object = new BufferedReader(new InputStreamReader(new FileInputStream((File)object2)));
            boolean bl = false;
            while (!bl) {
                String string4 = ((BufferedReader)object).readLine();
                if (string4 == null) {
                    bl = true;
                    continue;
                }
                string3 = string3 + string4 + "\n";
            }
            ((BufferedReader)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            string3 = string3 + "<h2>No Dataset Specific Information Available.</h2><hr>";
        }
        catch (IOException iOException) {
            throw new DODSException(0, iOException.getMessage());
        }
        string3 = string3 + "<hr>\n";
        try {
            object2 = this.infoDir + string + ".html";
            System.out.println("Server Info File: " + (String)object2);
            object = new File((String)object2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream((File)object)));
            boolean bl = false;
            while (!bl) {
                String string5 = bufferedReader.readLine();
                if (string5 == null) {
                    bl = true;
                    continue;
                }
                string3 = string3 + string5 + "\n";
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            string3 = string3 + "<h2>No Server Specific Information Available.</h2><hr>";
        }
        catch (IOException iOException) {
            throw new DODSException(0, iOException.getMessage());
        }
        return string3;
    }

    private String buildGlobalAttributes(DAS dAS, ServerDDS serverDDS) {
        boolean bl = false;
        String string = "<h3>Dataset Information</h3>\n<table>\n";
        Enumeration enumeration = dAS.getNames();
        while (enumeration.hasMoreElements()) {
            AttributeTable attributeTable;
            String string2 = (String)enumeration.nextElement();
            if (dasTools.nameInKillFile(string2) || !dasTools.nameIsGlobal(string2) && dasTools.nameInDDS(string2, serverDDS) || (attributeTable = dAS.getAttributeTable(string2)) == null) continue;
            Enumeration enumeration2 = attributeTable.getNames();
            while (enumeration2.hasMoreElements()) {
                String string3 = (String)enumeration2.nextElement();
                Attribute attribute = attributeTable.getAttribute(string3);
                bl = true;
                string = string + "\n<tr><td align=right valign=top><b>";
                string = string + string3 + "</b>:</td>\n";
                string = string + "<td align=left>";
                Enumeration enumeration3 = attribute.getValues();
                while (enumeration3.hasMoreElements()) {
                    String string4 = (String)enumeration3.nextElement();
                    string = string + string4 + "<br>";
                }
                string = string + "</td></tr>\n";
            }
        }
        string = string + "</table>\n<p>\n";
        if (!bl) {
            string = "";
        }
        return string;
    }

    private String buildVariableSummaries(DAS dAS, ServerDDS serverDDS) {
        String string = "<h3>Variables in this Dataset</h3>\n<table>\n";
        Enumeration enumeration = serverDDS.getVariables();
        while (enumeration.hasMoreElements()) {
            BaseType baseType = (BaseType)enumeration.nextElement();
            string = string + "<tr>";
            string = string + this.summarizeVariable(baseType, dAS);
            string = string + "</tr>";
        }
        string = string + "</table>\n<p>\n";
        return string;
    }

    private String summarizeAttributes(AttributeTable attributeTable, String string) {
        if (attributeTable != null) {
            Enumeration enumeration = attributeTable.getNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Attribute attribute = attributeTable.getAttribute(string2);
                if (attribute.isContainer()) {
                    string = string + "<li> <b> " + string2 + ": </b> </li>\n";
                    string = string + "<ul>\n";
                    string = string + this.summarizeAttributes(attribute.getContainer(), "");
                    string = string + "</ul>\n";
                    continue;
                }
                string = string + "<li> <b> " + string2 + ": </b> ";
                Enumeration enumeration2 = attribute.getValues();
                while (enumeration2.hasMoreElements()) {
                    String string3 = (String)enumeration2.nextElement();
                    string = string + string3;
                    if (!enumeration2.hasMoreElements()) continue;
                    string = string + ", ";
                }
                string = string + " </li>\n";
            }
        }
        return string;
    }

    private String summarizeVariable(BaseType baseType, DAS dAS) {
        String string = "<td align=right valign=top><b>" + baseType.getName();
        string = string + "</b>:</td>\n";
        string = string + "<td align=left valign=top>" + dasTools.fancyTypeName(baseType);
        AttributeTable attributeTable = dAS.getAttributeTable(baseType.getName());
        String string2 = "";
        string = string + "\n<ul>\n";
        string = string + this.summarizeAttributes(attributeTable, string2);
        string = string + "\n</ul>\n";
        if (baseType instanceof DConstructor) {
            string = string + "<table>\n";
            DConstructor dConstructor = (DConstructor)baseType;
            Enumeration enumeration = dConstructor.getVariables();
            while (enumeration.hasMoreElements()) {
                BaseType baseType2 = (BaseType)enumeration.nextElement();
                string = string + "<tr>\n";
                string = string + this.summarizeVariable(baseType2, dAS);
                string = string + "</tr>\n";
            }
            string = string + "</table>\n";
        } else if (baseType instanceof DVector) {
            BaseType baseType3;
            DVector dVector = (DVector)baseType;
            PrimitiveVector primitiveVector = dVector.getPrimitiveVector();
            if (primitiveVector instanceof BaseTypePrimitiveVector && !((baseType3 = primitiveVector.getTemplate()) instanceof DArray) && !(baseType3 instanceof DString)) {
                string = string + "<table>\n";
                string = string + "<tr>\n";
                string = string + this.summarizeVariable(baseType3, dAS);
                string = string + "</tr>\n";
                string = string + "</table>\n";
            }
        } else {
            string = string + "</td>\n";
        }
        return string;
    }
}

