/*
 * Decompiled with CFR 0.152.
 */
package dods.servlet;

import dods.dap.DAS;
import dods.dap.DODSException;
import dods.dap.Server.CEEvaluator;
import dods.dap.Server.ServerDDS;
import dods.dap.parser.ParseException;
import dods.servlet.GuardedDataset;
import dods.servlet.dodsASCII;
import dods.servlet.dodsDIR;
import dods.servlet.dodsHTML;
import dods.servlet.dodsINFO;
import dods.servlet.requestState;
import dods.util.Debug;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public abstract class DODSServlet
extends HttpServlet {
    private boolean track = false;
    private Object syncLock = new Object();
    private int HitCounter = 0;
    private ArrayList prArr = null;

    public abstract String getServerVersion();

    protected abstract GuardedDataset getDataset(requestState var1) throws DODSException, IOException, ParseException;

    public void init() throws ServletException {
        super.init();
        String string = this.getInitParameter("DebugOn");
        if (string != null) {
            System.out.println("** DebugOn **");
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                Debug.set(stringTokenizer.nextToken(), true);
            }
        }
    }

    public void parseExceptionHandler(ParseException parseException, HttpServletResponse httpServletResponse) {
        System.out.println(parseException);
        parseException.printStackTrace();
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());
            httpServletResponse.setHeader("Content-Description", "dods_error");
            httpServletResponse.setHeader("Content-Encoding", "");
            String string = parseException.getMessage().replace('\"', '\'');
            DODSException dODSException = new DODSException(5, string);
            dODSException.print(bufferedOutputStream);
        }
        catch (IOException iOException) {
            System.out.println("Cannot respond to client! IO Error: " + iOException.getMessage());
        }
    }

    public void dodsExceptionHandler(DODSException dODSException, HttpServletResponse httpServletResponse) {
        System.out.println(dODSException);
        dODSException.printStackTrace();
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());
            httpServletResponse.setHeader("Content-Description", "dods_error");
            httpServletResponse.setHeader("Content-Encoding", "");
            dODSException.print(bufferedOutputStream);
            dODSException.print(System.out);
        }
        catch (IOException iOException) {
            System.out.println("Cannot respond to client! IO Error: " + iOException.getMessage());
        }
    }

    public void anyExceptionHandler(Throwable throwable, HttpServletResponse httpServletResponse, requestState requestState2) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
            httpServletResponse.setHeader("Content-Description", "dods_error");
            httpServletResponse.setHeader("Content-Encoding", "");
            dataOutputStream.writeUTF("DODServlet ERROR: " + throwable.getMessage());
            System.out.println("DODServlet ERROR (anyExceptionHandler): " + throwable);
            System.out.println(requestState2);
            if (this.track) {
                RequestDebug requestDebug = (RequestDebug)requestState2.getUserObject();
                System.out.println("  request number: " + requestDebug.reqno + " thread: " + requestDebug.threadDesc);
            }
            throwable.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("Cannot respond to client! IO Error: " + iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DAS getDAS(requestState requestState2) throws DODSException, ParseException {
        DataInputStream dataInputStream = null;
        DAS dAS = new DAS();
        boolean bl = false;
        try {
            dataInputStream = this.openCachedDAS(requestState2);
            dAS.parse(dataInputStream);
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        finally {
            try {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new DODSException(0, iOException.getMessage());
            }
        }
        if (bl) {
            if (Debug.isSet("showResponse")) {
                System.out.println("Successfully opened and parsed DAS cache: " + requestState2.getDataSet());
            } else if (Debug.isSet("showResponse")) {
                System.out.println("No DAS present for dataset: " + requestState2.getDataSet());
            }
        }
        return dAS;
    }

    public void sendDODSError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException, ServletException {
        httpServletResponse.setContentType("text/plain");
        httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
        httpServletResponse.setHeader("Content-Description", "dods_error");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        DODSException dODSException = new DODSException(0, string);
        dODSException.print((OutputStream)servletOutputStream);
        httpServletResponse.setStatus(200);
        System.out.println(string2);
    }

    public DataInputStream openCachedDDS(requestState requestState2) throws DODSException {
        String string = requestState2.getInitParameter("DDScache");
        if (string == null) {
            string = "/home/dods/dds/";
        }
        try {
            File file = new File(string + requestState2.getDataSet());
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            return dataInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DODSException(5, fileNotFoundException.getMessage());
        }
    }

    public DataInputStream openCachedDAS(requestState requestState2) throws FileNotFoundException {
        String string = requestState2.getInitParameter("DAScache");
        if (string == null) {
            string = "/home/dods/das/";
        }
        File file = new File(string + requestState2.getDataSet());
        FileInputStream fileInputStream = new FileInputStream(file);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        return dataInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDAS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, requestState requestState2) throws IOException, ServletException {
        block11: {
            if (Debug.isSet("showResponse")) {
                System.out.println("Sending DAS for dataset: " + requestState2.getDataSet());
            }
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
            httpServletResponse.setHeader("Content-Description", "dods_das");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());
            GuardedDataset guardedDataset = null;
            try {
                try {
                    guardedDataset = this.getDataset(requestState2);
                    if (Debug.isSet("showResponse")) {
                        System.out.println("Got the GuardedDataset...");
                    }
                    DAS dAS = guardedDataset.getDAS();
                    dAS.print(bufferedOutputStream);
                    httpServletResponse.setStatus(200);
                }
                catch (DODSException dODSException) {
                    this.dodsExceptionHandler(dODSException, httpServletResponse);
                    Object var9_9 = null;
                    if (guardedDataset != null) {
                        guardedDataset.release();
                    }
                    break block11;
                }
                catch (ParseException parseException) {
                    this.parseExceptionHandler(parseException, httpServletResponse);
                    Object var9_10 = null;
                    if (guardedDataset != null) {
                        guardedDataset.release();
                    }
                }
                Object var9_8 = null;
                if (guardedDataset != null) {
                    guardedDataset.release();
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (guardedDataset != null) {
                    guardedDataset.release();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDDS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, requestState requestState2) throws IOException, ServletException {
        block14: {
            if (Debug.isSet("showResponse")) {
                System.out.println("Sending DDS for dataset: " + requestState2.getDataSet());
            }
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
            httpServletResponse.setHeader("Content-Description", "dods_dds");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());
            GuardedDataset guardedDataset = null;
            try {
                try {
                    guardedDataset = this.getDataset(requestState2);
                    ServerDDS serverDDS = guardedDataset.getDDS();
                    if (requestState2.getConstraintExpression().equals("")) {
                        serverDDS.print(bufferedOutputStream);
                        ((OutputStream)bufferedOutputStream).flush();
                    } else {
                        CEEvaluator cEEvaluator = new CEEvaluator(serverDDS);
                        cEEvaluator.parseConstraint(requestState2.getConstraintExpression());
                        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(bufferedOutputStream));
                        serverDDS.printConstrained(printWriter);
                        printWriter.flush();
                    }
                    httpServletResponse.setStatus(200);
                }
                catch (DODSException dODSException) {
                    this.dodsExceptionHandler(dODSException, httpServletResponse);
                    Object var10_13 = null;
                    if (guardedDataset != null) {
                        guardedDataset.release();
                    }
                    break block14;
                }
                catch (IOException iOException) {
                    this.anyExceptionHandler(iOException, httpServletResponse, requestState2);
                    Object var10_14 = null;
                    if (guardedDataset != null) {
                        guardedDataset.release();
                    }
                    break block14;
                }
                catch (ParseException parseException) {
                    this.parseExceptionHandler(parseException, httpServletResponse);
                    Object var10_15 = null;
                    if (guardedDataset != null) {
                        guardedDataset.release();
                    }
                }
                Object var10_12 = null;
                if (guardedDataset != null) {
                    guardedDataset.release();
                }
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                if (guardedDataset != null) {
                    guardedDataset.release();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDODS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, requestState requestState2) throws IOException, ServletException {
        block13: {
            FilterOutputStream filterOutputStream;
            if (Debug.isSet("showResponse")) {
                System.out.println("Sending DODS Data For: " + requestState2.getDataSet());
            }
            httpServletResponse.setContentType("application/octet-stream");
            httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
            httpServletResponse.setHeader("Content-Description", "dods_data");
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            if (requestState2.getAcceptsCompressed()) {
                httpServletResponse.setHeader("Content-Encoding", "deflate");
                filterOutputStream = new DeflaterOutputStream((OutputStream)servletOutputStream);
            } else {
                filterOutputStream = new BufferedOutputStream((OutputStream)servletOutputStream);
            }
            GuardedDataset guardedDataset = null;
            try {
                try {
                    guardedDataset = this.getDataset(requestState2);
                    ServerDDS serverDDS = guardedDataset.getDDS();
                    CEEvaluator cEEvaluator = new CEEvaluator(serverDDS);
                    cEEvaluator.parseConstraint(requestState2.getConstraintExpression());
                    PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(filterOutputStream));
                    serverDDS.printConstrained(printWriter);
                    printWriter.flush();
                    ((OutputStream)filterOutputStream).write("\nData:\n".getBytes());
                    ((OutputStream)filterOutputStream).flush();
                    DataOutputStream dataOutputStream = new DataOutputStream(filterOutputStream);
                    cEEvaluator.send(serverDDS.getName(), dataOutputStream, guardedDataset);
                    dataOutputStream.flush();
                    if (requestState2.getAcceptsCompressed()) {
                        ((DeflaterOutputStream)filterOutputStream).finish();
                    }
                    httpServletResponse.setStatus(200);
                }
                catch (DODSException dODSException) {
                    this.dodsExceptionHandler(dODSException, httpServletResponse);
                    Object var13_14 = null;
                    if (guardedDataset != null) {
                        guardedDataset.release();
                    }
                    break block13;
                }
                catch (ParseException parseException) {
                    this.parseExceptionHandler(parseException, httpServletResponse);
                    Object var13_15 = null;
                    if (guardedDataset != null) {
                        guardedDataset.release();
                    }
                }
                Object var13_13 = null;
                if (guardedDataset != null) {
                    guardedDataset.release();
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (guardedDataset != null) {
                    guardedDataset.release();
                }
                throw throwable;
            }
        }
    }

    public void doGetDIR(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, requestState requestState2) throws IOException, ServletException {
        httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("Content-Description", "dods_directory");
        try {
            dodsDIR dodsDIR2 = new dodsDIR();
            dodsDIR2.sendDIR(httpServletRequest, httpServletResponse, requestState2);
            httpServletResponse.setStatus(200);
        }
        catch (DODSException dODSException) {
            this.dodsExceptionHandler(dODSException, httpServletResponse);
        }
        catch (ParseException parseException) {
            this.parseExceptionHandler(parseException, httpServletResponse);
        }
    }

    public void doGetVER(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending Version Tag.");
        }
        httpServletResponse.setContentType("text/plain");
        httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
        httpServletResponse.setHeader("Content-Description", "dods_version");
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream()));
        printWriter.println("Server Version: " + this.getServerVersion());
        printWriter.flush();
        httpServletResponse.setStatus(200);
    }

    public void doGetHELP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending Help Page.");
        }
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
        httpServletResponse.setHeader("Content-Description", "dods_help");
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream()));
        this.printHelpPage(printWriter);
        printWriter.flush();
        httpServletResponse.setStatus(200);
    }

    public void badURL(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending Bad URL Page.");
        }
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
        httpServletResponse.setHeader("Content-Description", "BadURL");
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream()));
        this.printBadURLPage(printWriter);
        this.printHelpPage(printWriter);
        printWriter.flush();
        httpServletResponse.setStatus(200);
    }

    public void doGetASC(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, requestState requestState2) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending ASC Data For: " + requestState2.getDataSet());
        }
        httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
        httpServletResponse.setContentType("text/plain");
        httpServletResponse.setHeader("Content-Description", "dods_ascii");
        try {
            dodsASCII dodsASCII2 = new dodsASCII();
            dodsASCII2.sendASCII(httpServletRequest, httpServletResponse, requestState2.getDataSet());
            httpServletResponse.setStatus(200);
        }
        catch (DODSException dODSException) {
            this.dodsExceptionHandler(dODSException, httpServletResponse);
        }
        catch (ParseException parseException) {
            this.parseExceptionHandler(parseException, httpServletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetINFO(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, requestState requestState2) throws IOException, ServletException {
        block9: {
            PrintStream printStream = new PrintStream((OutputStream)httpServletResponse.getOutputStream());
            httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setHeader("Content-Description", "dods_description");
            GuardedDataset guardedDataset = null;
            try {
                try {
                    guardedDataset = this.getDataset(requestState2);
                    dodsINFO dodsINFO2 = new dodsINFO();
                    dodsINFO2.sendINFO(printStream, guardedDataset, requestState2);
                    httpServletResponse.setStatus(200);
                }
                catch (DODSException dODSException) {
                    this.dodsExceptionHandler(dODSException, httpServletResponse);
                    Object var9_9 = null;
                    if (guardedDataset != null) {
                        guardedDataset.release();
                    }
                    break block9;
                }
                catch (ParseException parseException) {
                    this.parseExceptionHandler(parseException, httpServletResponse);
                    Object var9_10 = null;
                    if (guardedDataset != null) {
                        guardedDataset.release();
                    }
                }
                Object var9_8 = null;
                if (guardedDataset != null) {
                    guardedDataset.release();
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (guardedDataset != null) {
                    guardedDataset.release();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetHTML(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, requestState requestState2) throws IOException, ServletException {
        block11: {
            httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setHeader("Content-Description", "dods_form");
            GuardedDataset guardedDataset = null;
            try {
                try {
                    guardedDataset = this.getDataset(requestState2);
                    ServerDDS serverDDS = guardedDataset.getDDS();
                    DAS dAS = guardedDataset.getDAS();
                    dodsHTML dodsHTML2 = new dodsHTML();
                    dodsHTML2.sendDataRequestForm(httpServletRequest, httpServletResponse, requestState2.getDataSet(), serverDDS, dAS);
                    httpServletResponse.setStatus(200);
                }
                catch (DODSException dODSException) {
                    this.dodsExceptionHandler(dODSException, httpServletResponse);
                    Object var9_12 = null;
                    if (guardedDataset != null) {
                        guardedDataset.release();
                    }
                    break block11;
                }
                catch (IOException iOException) {
                    this.anyExceptionHandler(iOException, httpServletResponse, requestState2);
                    Object var9_13 = null;
                    if (guardedDataset != null) {
                        guardedDataset.release();
                    }
                    break block11;
                }
                catch (ParseException parseException) {
                    this.parseExceptionHandler(parseException, httpServletResponse);
                    Object var9_14 = null;
                    if (guardedDataset != null) {
                        guardedDataset.release();
                    }
                }
                Object var9_11 = null;
                if (guardedDataset != null) {
                    guardedDataset.release();
                }
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                if (guardedDataset != null) {
                    guardedDataset.release();
                }
                throw throwable;
            }
        }
    }

    public void doGetCatalog(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
        httpServletResponse.setContentType("text/xml");
        httpServletResponse.setHeader("Content-Description", "dods_catalog");
        PrintWriter printWriter = new PrintWriter((OutputStream)httpServletResponse.getOutputStream());
        this.printCatalog(printWriter);
        printWriter.flush();
        httpServletResponse.setStatus(200);
    }

    protected void printCatalog(PrintWriter printWriter) throws IOException {
        printWriter.println("Catalog not available for this server");
        printWriter.println("Server version = " + this.getServerVersion());
    }

    public void doGetStatus(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("Content-Description", "dods_status");
        PrintWriter printWriter = new PrintWriter((OutputStream)httpServletResponse.getOutputStream());
        printWriter.println("<title>Server Status</title>");
        printWriter.println("<body><ul>");
        this.printStatus(printWriter);
        printWriter.println("</ul></body>");
        printWriter.flush();
        httpServletResponse.setStatus(200);
    }

    protected void printStatus(PrintWriter printWriter) throws IOException {
        printWriter.println("<h2>Server version = " + this.getServerVersion() + "</h2>");
        printWriter.println("<h2>Number of Requests Received = " + this.HitCounter + "</h2>");
        if (this.track) {
            int n = this.prArr.size();
            int n2 = 0;
            String string = "";
            int n3 = 0;
            while (n3 < n) {
                requestState requestState2 = (requestState)this.prArr.get(n3);
                RequestDebug requestDebug = (RequestDebug)requestState2.getUserObject();
                if (requestState2 != null && !requestDebug.done) {
                    string = string + "<pre>-----------------------\n";
                    string = string + "Request[" + requestDebug.reqno + "](" + requestDebug.threadDesc + ") is pending.\n";
                    string = string + requestState2.toString();
                    string = string + "</pre>";
                    ++n2;
                }
                ++n3;
            }
            printWriter.println("<h2>" + n2 + " Pending Request(s)</h2>");
            printWriter.println(string);
        }
    }

    public void probeRequest(HttpServletRequest httpServletRequest) {
        String string;
        String string2;
        System.out.println("####################### PROBE ##################################");
        System.out.println("The HttpServletRequest object is actually a: " + httpServletRequest.getClass().getName());
        System.out.println("");
        System.out.println("HttpServletRequest Interface:");
        System.out.println("    getAuthType:           " + httpServletRequest.getAuthType());
        System.out.println("    getMethod:             " + httpServletRequest.getMethod());
        System.out.println("    getPathInfo:           " + httpServletRequest.getPathInfo());
        System.out.println("    getPathTranslated:     " + httpServletRequest.getPathTranslated());
        System.out.println("    getQueryString:        " + httpServletRequest.getQueryString());
        System.out.println("    getRemoteUser:         " + httpServletRequest.getRemoteUser());
        System.out.println("    getRequestedSessionId: " + httpServletRequest.getRequestedSessionId());
        System.out.println("    getRequestURI:         " + httpServletRequest.getRequestURI());
        System.out.println("    getServletPath:        " + httpServletRequest.getServletPath());
        System.out.println("    isRequestedSessionIdFromCookie: " + httpServletRequest.isRequestedSessionIdFromCookie());
        System.out.println("    isRequestedSessionIdValid:      " + httpServletRequest.isRequestedSessionIdValid());
        System.out.println("    isRequestedSessionIdFromURL:    " + httpServletRequest.isRequestedSessionIdFromURL());
        System.out.println("");
        int n = 0;
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        System.out.println("    Header Names:");
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            System.out.print("        Header[" + ++n + "]: " + string2);
            System.out.println(": " + httpServletRequest.getHeader(string2));
        }
        System.out.println("");
        System.out.println("ServletRequest Interface:");
        System.out.println("    getCharacterEncoding:  " + httpServletRequest.getCharacterEncoding());
        System.out.println("    getContentType:        " + httpServletRequest.getContentType());
        System.out.println("    getContentLength:      " + httpServletRequest.getContentLength());
        System.out.println("    getProtocol:           " + httpServletRequest.getProtocol());
        System.out.println("    getScheme:             " + httpServletRequest.getScheme());
        System.out.println("    getServerName:         " + httpServletRequest.getServerName());
        System.out.println("    getServerPort:         " + httpServletRequest.getServerPort());
        System.out.println("    getRemoteAddr:         " + httpServletRequest.getRemoteAddr());
        System.out.println("    getRemoteHost:         " + httpServletRequest.getRemoteHost());
        System.out.println(".............................");
        System.out.println("");
        n = 0;
        enumeration = httpServletRequest.getAttributeNames();
        System.out.println("    Attribute Names:");
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            System.out.print("        Attribute[" + ++n + "]: " + string2);
            System.out.println(" Type: " + httpServletRequest.getAttribute(string2));
        }
        System.out.println(".............................");
        System.out.println("");
        n = 0;
        enumeration = httpServletRequest.getParameterNames();
        System.out.println("    Parameter Names:");
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            System.out.print("        Parameter[" + ++n + "]: " + string2);
            System.out.println(" Value: " + httpServletRequest.getParameter(string2));
        }
        System.out.println("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
        System.out.println(" . . . . . . . . . Servlet Infomation API  . . . . . . . . . . . . . .");
        System.out.println("");
        System.out.println("Servlet Context:");
        System.out.println("");
        string2 = this.getServletContext();
        n = 0;
        enumeration = string2.getAttributeNames();
        System.out.println("    Attribute Names:");
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            System.out.print("        Attribute[" + ++n + "]: " + string);
            System.out.println(" Type: " + string2.getAttribute(string));
        }
        System.out.println("    ServletContext.getMajorVersion(): " + string2.getMajorVersion());
        System.out.println("    ServletContext.getMinorVersion(): " + string2.getMinorVersion());
        System.out.println(".............................");
        System.out.println("Servlet Config:");
        System.out.println("");
        string = this.getServletConfig();
        n = 0;
        enumeration = string.getInitParameterNames();
        System.out.println("    InitParameters:");
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            System.out.print("        InitParameter[" + n + "]: " + string3);
            System.out.println(" Value: " + string.getInitParameter(string3));
            ++n;
        }
        System.out.println(".............................");
        System.out.println("HttpUtils:");
        System.out.println("");
        System.out.println("getRequestURL: " + HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest));
        System.out.println("");
        System.out.println("######################## END PROBE ###############################");
        System.out.println("");
    }

    /*
     * Unable to fully structure code
     */
    private String prepCE(String var1_1) {
        block3: {
            block2: {
                if (var1_1 != null) break block2;
                var1_1 = "";
                break block3;
            }
            if (var1_1.equals("")) break block3;
            var2_2 = var1_1.indexOf("%");
            if (var2_2 == -1) {
                return var1_1;
            }
            if (var2_2 <= var1_1.length() - 3) ** GOTO lbl15
            return null;
lbl-1000:
            // 1 sources

            {
                var3_3 = var1_1.substring(var2_2 + 1, var2_2 + 3);
                var4_4 = (char)Byte.parseByte(var3_3, 16);
                if ((var2_2 = (var1_1 = var1_1.substring(0, var2_2) + String.valueOf(var4_4) + var1_1.substring(var2_2 + 3, var1_1.length())).indexOf("%")) <= var1_1.length() - 3) continue;
                return null;
lbl15:
                // 2 sources

                ** while (var2_2 >= 0)
            }
        }
        return var1_1;
    }

    protected boolean isTheClientCompressed(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        String string = httpServletRequest.getHeader("Accept-Encoding");
        bl = string != null ? string.equalsIgnoreCase("deflate") : false;
        return bl;
    }

    protected requestState processDodsURL(HttpServletRequest httpServletRequest) {
        String string = this.prepCE(httpServletRequest.getQueryString());
        if (string == null) {
            return null;
        }
        String string2 = httpServletRequest.getPathInfo();
        String string3 = null;
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
            String string4 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            int n = string4.lastIndexOf(46);
            if (n >= 0) {
                string3 = string4.substring(n + 1);
                string2 = string2.substring(1, string2.lastIndexOf(46));
            } else {
                string3 = "";
                string2 = string2.substring(1, string2.length());
            }
        }
        return new requestState(string2, string3, string, this.isTheClientCompressed(httpServletRequest), this.getServletConfig(), this.getServerName());
    }

    public String getServerName() {
        String string = ((Object)((Object)this)).getClass().getName();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        requestState requestState2 = null;
        RequestDebug requestDebug = null;
        try {
            if (Debug.isSet("probeRequest")) {
                this.probeRequest(httpServletRequest);
            }
            requestState2 = this.processDodsURL(httpServletRequest);
            Object object = this.syncLock;
            synchronized (object) {
                long l = this.HitCounter++;
                if (this.track) {
                    requestDebug = new RequestDebug(l, Thread.currentThread().toString());
                    requestState2.setUserObject(requestDebug);
                    if (this.prArr == null) {
                        this.prArr = new ArrayList(10000);
                    }
                    this.prArr.add((int)l, requestState2);
                }
                if (Debug.isSet("showRequest")) {
                    System.out.println("-------------------------------------------");
                    System.out.println("Server: " + this.getServerName() + "   Request #" + l);
                    System.out.println(requestState2.toString());
                }
            }
            if (requestState2 != null) {
                String string = requestState2.getDataSet();
                String string2 = requestState2.getRequestSuffix();
                if (string == null) {
                    this.doGetDIR(httpServletRequest, httpServletResponse, requestState2);
                } else if (string.equals("/")) {
                    this.doGetDIR(httpServletRequest, httpServletResponse, requestState2);
                } else if (string.equals("")) {
                    this.doGetDIR(httpServletRequest, httpServletResponse, requestState2);
                } else if (string.equalsIgnoreCase("/version") || string.equalsIgnoreCase("/version/")) {
                    this.doGetVER(httpServletRequest, httpServletResponse);
                } else if (string.equalsIgnoreCase("/help") || string.equalsIgnoreCase("/help/")) {
                    this.doGetHELP(httpServletRequest, httpServletResponse);
                } else if (string.equalsIgnoreCase("/" + string2)) {
                    this.doGetHELP(httpServletRequest, httpServletResponse);
                } else if (string2.equalsIgnoreCase("dds")) {
                    this.doGetDDS(httpServletRequest, httpServletResponse, requestState2);
                } else if (string2.equalsIgnoreCase("das")) {
                    this.doGetDAS(httpServletRequest, httpServletResponse, requestState2);
                } else if (string2.equalsIgnoreCase("dods")) {
                    this.doGetDODS(httpServletRequest, httpServletResponse, requestState2);
                } else if (string2.equalsIgnoreCase("asc") || string2.equalsIgnoreCase("ascii")) {
                    this.doGetASC(httpServletRequest, httpServletResponse, requestState2);
                } else if (string2.equalsIgnoreCase("info")) {
                    this.doGetINFO(httpServletRequest, httpServletResponse, requestState2);
                } else if (string2.equalsIgnoreCase("html") || string2.equalsIgnoreCase("htm")) {
                    this.doGetHTML(httpServletRequest, httpServletResponse, requestState2);
                } else if (string2.equalsIgnoreCase("ver") || string2.equalsIgnoreCase("version")) {
                    this.doGetVER(httpServletRequest, httpServletResponse);
                } else if (string2.equalsIgnoreCase("help")) {
                    this.doGetHELP(httpServletRequest, httpServletResponse);
                } else if (string2.equalsIgnoreCase("xml") && string.equalsIgnoreCase("catalog")) {
                    this.doGetCatalog(httpServletRequest, httpServletResponse);
                } else if (string.equalsIgnoreCase("status")) {
                    this.doGetStatus(httpServletRequest, httpServletResponse);
                } else if (string2.equals("")) {
                    this.badURL(httpServletRequest, httpServletResponse);
                } else {
                    this.badURL(httpServletRequest, httpServletResponse);
                }
            } else {
                this.badURL(httpServletRequest, httpServletResponse);
            }
            if (requestDebug != null) {
                requestDebug.done = true;
            }
        }
        catch (Throwable throwable) {
            this.anyExceptionHandler(throwable, httpServletResponse, requestState2);
        }
    }

    private void printHelpPage(PrintWriter printWriter) {
        printWriter.println("<h3>DODS Server Help</h3>");
        printWriter.println("To access most of the features of this DODS server, append");
        printWriter.println("one of the following a five suffixes to a URL: .das, .dds, .dods., .info,");
        printWriter.println(".ver or .help. Using these suffixes, you can ask this server for:<dl>");
        printWriter.println("<dt> das  <dd> attribute object");
        printWriter.println("<dt> dds  <dd> data type object");
        printWriter.println("<dt> dods <dd> data object");
        printWriter.println("<dt> info <dd> info object (attributes, types and other information)");
        printWriter.println("<dt> html <dd> html form for this dataset");
        printWriter.println("<dt> ver  <dd> return the version number of the server");
        printWriter.println("<dt> help <dd> help information (this text)</dl>");
        printWriter.println("</dl>");
        printWriter.println("For example, to request the DAS object from the FNOC1 dataset at URI/GSO (a");
        printWriter.println("test dataset) you would appand `.das' to the URL:");
        printWriter.println("http://dods.gso.uri.edu/cgi-bin/nph-nc/data/fnoc1.nc.das.");
        printWriter.println("<p><b>Note</b>: Many DODS clients supply these extensions for you so you don't");
        printWriter.println("need to append them (for example when using interfaces supplied by us or");
        printWriter.println("software re-linked with a DODS client-library). Generally, you only need to");
        printWriter.println("add these if you are typing a URL directly into a WWW browser.");
        printWriter.println("<p><b>Note</b>: If you would like version information for this server but");
        printWriter.println("don't know a specific data file or data set name, use `/version' for the");
        printWriter.println("filename. For example: http://dods.gso.uri.edu/cgi-bin/nph-nc/version will");
        printWriter.println("return the version number for the netCDF server used in the first example. ");
        printWriter.println("<p><b>Suggestion</b>: If you're typing this URL into a WWW browser and");
        printWriter.println("would like information about the dataset, use the `.info' extension.");
        printWriter.println("<p>If you'd like to see a data values, use the `.html' extension and submit a");
        printWriter.println("query using the customized form.");
    }

    private void printBadURLPage(PrintWriter printWriter) {
        printWriter.println("<h3>Error in URL</h3>");
        printWriter.println("The URL extension did not match any that are known by this");
        printWriter.println("server. Below is a list of the five extensions that are be recognized by");
        printWriter.println("all DODS servers. If you think that the server is broken (that the URL you");
        printWriter.println("submitted should have worked), then please contact the");
        printWriter.println("DODS user support coordinator at: support@unidata.ucar.edu<p>");
    }

    private class RequestDebug {
        long reqno;
        String threadDesc;
        boolean done = false;

        RequestDebug(long l, String string) {
            this.reqno = l;
            this.threadDesc = string;
        }
    }
}

