/*
 * Decompiled with CFR 0.152.
 */
package dods.servers.test;

import dods.dap.BaseType;
import dods.dap.BaseTypePrimitiveVector;
import dods.dap.BooleanPrimitiveVector;
import dods.dap.BytePrimitiveVector;
import dods.dap.DArrayDimension;
import dods.dap.DODSException;
import dods.dap.DSequence;
import dods.dap.Float32PrimitiveVector;
import dods.dap.Float64PrimitiveVector;
import dods.dap.Int16PrimitiveVector;
import dods.dap.Int32PrimitiveVector;
import dods.dap.NoSuchVariableException;
import dods.dap.PrimitiveVector;
import dods.dap.Server.InvalidParameterException;
import dods.dap.Server.SDArray;
import dods.dap.Server.ServerDDS;
import dods.dap.Server.ServerMethods;
import dods.dap.UInt16PrimitiveVector;
import dods.dap.UInt32PrimitiveVector;
import dods.servers.test.test_SDArray;
import dods.servers.test.test_SDGrid;
import dods.servers.test.test_SDList;
import java.io.EOFException;
import java.io.IOException;

public class testEngine {
    private static boolean _Debug = false;
    private ServerDDS unconstrainedDDS;
    private boolean tBool;
    private byte tByte;
    private float tFloat32;
    private double tFloat64;
    private short tUint16;
    private short tInt16;
    private int tUint32;
    private int tInt32_1;
    private int tInt32_2;
    private String tURL;
    private int tStringCount;

    public testEngine() {
        this(null);
    }

    public testEngine(ServerDDS s) {
        this.unconstrainedDDS = s;
        this.tBool = false;
        this.tByte = 0;
        this.tFloat32 = 0.0f;
        this.tFloat64 = 0.0;
        this.tUint16 = 0;
        this.tInt16 = 0;
        this.tUint32 = 0;
        this.tInt32_1 = 0;
        this.tInt32_2 = 1;
        this.tURL = "http://www.dods.org";
        this.tStringCount = 0;
    }

    public boolean nextBool() {
        this.tBool = !this.tBool;
        return this.tBool;
    }

    public byte nextByte() {
        byte by = this.tByte;
        this.tByte = (byte)(by + 1);
        return by;
    }

    public float nextFloat32() {
        float b = (float)(100.0 * Math.sin(this.tFloat32));
        this.tFloat32 = (float)((double)this.tFloat32 + 0.01);
        return b;
    }

    public double nextFloat64() {
        double b = 1000.0 * Math.cos(this.tFloat64);
        this.tFloat64 += 0.01;
        return b;
    }

    public short nextUint16() {
        short b = (short)(-16 * this.tUint16);
        this.tUint16 = (short)(this.tUint16 + 1);
        return b;
    }

    public short nextInt16() {
        short b = (short)(16 * this.tInt16);
        this.tInt16 = (short)(this.tInt16 + 1);
        return b;
    }

    public int nextUint32() {
        int b = this.tUint32++ * this.tUint32;
        return b;
    }

    public int nextInt32() {
        int b = this.tInt32_1 + this.tInt32_2;
        this.tInt32_1 = this.tInt32_2;
        this.tInt32_2 = b;
        return b;
    }

    public String nextURL() {
        return this.tURL;
    }

    public String nextString() {
        String b = "This is a data test string (pass " + this.tStringCount + ").";
        ++this.tStringCount;
        return b;
    }

    public void newLoadTestArray(String datasetName, test_SDArray ta) throws IOException, EOFException {
        if (_Debug) {
            System.out.println("---------------------------------------------------");
        }
        if (_Debug) {
            System.out.println("testEngine.newLoadTestArray(" + datasetName + "): ");
        }
        try {
            if (_Debug) {
                System.out.println("Loading: " + ta.getName() + " an SDArray of " + ta.numDimensions() + " dimension(s).");
            }
            PrimitiveVector pv = ta.getPrimitiveVector();
            if (_Debug) {
                Class<?> cl = pv.getClass();
                System.out.println("PrimitiveVector is a: " + cl.getName());
            }
            pv.setLength(this.getLength(ta, 0, true));
            if (_Debug) {
                System.out.println("Length: " + pv.getLength());
            }
            this.newLoadArray(datasetName, ta);
        }
        catch (DODSException e) {
            // empty catch block
        }
        if (_Debug) {
            System.out.println("---------------------------------------------------");
        }
    }

    private int getLength(test_SDArray ta, int dim, boolean constrained) throws InvalidParameterException {
        int sizeofOtherDims = 1;
        if (dim + 1 < ta.numDimensions()) {
            sizeofOtherDims = this.getLength(ta, dim + 1, constrained);
        }
        DArrayDimension dad = ta.getDimension(dim);
        int sizeofThisDim = 1;
        if (constrained) {
            if (_Debug) {
                System.out.print("Scanning Dimension " + dim + "  start: " + dad.getStart() + "  stop: " + dad.getStop() + "  stride: " + dad.getStride());
            }
            sizeofThisDim = 1 + (dad.getStop() - dad.getStart()) / dad.getStride();
        } else {
            sizeofThisDim = dad.getSize();
        }
        int eCount = sizeofThisDim * sizeofOtherDims;
        if (_Debug) {
            System.out.println("  length: " + sizeofThisDim);
        }
        return eCount;
    }

    private int nuAI(int constrainedIndex, test_SDArray ta) throws InvalidParameterException {
        DArrayDimension dad;
        int[] cIndices = new int[ta.numDimensions()];
        int[] uIndices = new int[ta.numDimensions()];
        int[] cDimSteps = new int[ta.numDimensions()];
        int[] uDimSteps = new int[ta.numDimensions()];
        if (_Debug) {
            System.out.println("ConstrainedIndex: " + constrainedIndex);
        }
        int dim = ta.numDimensions() - 1;
        cDimSteps[dim] = 1;
        uDimSteps[dim] = 1;
        dim = ta.numDimensions() - 2;
        while (dim >= 0) {
            dad = ta.getDimension(dim + 1);
            cDimSteps[dim] = cDimSteps[dim + 1] * dad.getSize();
            uDimSteps[dim] = uDimSteps[dim + 1] * ta.getCachedShape(dim + 1);
            --dim;
        }
        if (_Debug) {
            System.out.println("DimSteps: ");
            dim = 0;
            while (dim < ta.numDimensions()) {
                System.out.println("    cDimSteps[" + dim + "]: " + cDimSteps[dim]);
                ++dim;
            }
            System.out.println("");
            dim = 0;
            while (dim < ta.numDimensions()) {
                System.out.println("    uDimSteps[" + dim + "]: " + uDimSteps[dim]);
                ++dim;
            }
        }
        if (_Debug) {
            System.out.println("cIndices: ");
        }
        int k = 0;
        dim = 0;
        while (dim < ta.numDimensions() - 1) {
            dad = ta.getDimension(dim);
            cIndices[dim] = (constrainedIndex - k) / cDimSteps[dim];
            if (_Debug) {
                System.out.println("cIndices[" + dim + "]: " + cIndices[dim] + "  k: " + k);
            }
            k += cIndices[dim] * cDimSteps[dim];
            ++dim;
        }
        cIndices[dim] = constrainedIndex - k;
        if (_Debug) {
            System.out.println("cIndices[" + dim + "]: " + cIndices[dim] + "  k: " + k);
        }
        if (_Debug) {
            System.out.print("uIndices: (");
        }
        dim = 0;
        while (dim < ta.numDimensions()) {
            dad = ta.getDimension(dim);
            uIndices[dim] = dad.getStart() + cIndices[dim] * dad.getStride();
            if (_Debug) {
                System.out.print(uIndices[dim] + ", ");
            }
            ++dim;
        }
        if (_Debug) {
            System.out.println(")");
        }
        int uI = 0;
        dim = 0;
        while (dim < ta.numDimensions()) {
            uI += uIndices[dim] * uDimSteps[dim];
            ++dim;
        }
        return uI;
    }

    private void newLoadArray(String dataset, test_SDArray ta) throws InvalidParameterException, NoSuchVariableException, EOFException, IOException {
        PrimitiveVector pv = ta.getPrimitiveVector();
        if (_Debug) {
            System.out.println("Loading Array... ");
        }
        int j = 0;
        while (j < pv.getLength()) {
            if (_Debug) {
                System.out.print("..\n");
            }
            int i = this.nuAI(j, ta);
            if (_Debug) {
                System.out.println("ConstrainedIndex: " + j + "   UnconstrainedIndex: " + i);
            }
            if (pv instanceof BaseTypePrimitiveVector) {
                BaseType bt = ((BaseTypePrimitiveVector)pv).getTemplate();
                BaseType newBT = (BaseType)bt.clone();
                newBT.setName(newBT.getName() + "[" + j + "]");
                ((BaseTypePrimitiveVector)pv).setValue(j, newBT);
                ServerMethods sm = (ServerMethods)((Object)((BaseTypePrimitiveVector)pv).getValue(j));
                boolean MoreToRead = !(bt instanceof DSequence);
                while (MoreToRead) {
                    MoreToRead = sm.read(dataset, this);
                }
            }
            if (pv instanceof BooleanPrimitiveVector) {
                if (i % 2 != 0) {
                    ((BooleanPrimitiveVector)pv).setValue(j, true);
                } else {
                    ((BooleanPrimitiveVector)pv).setValue(j, false);
                }
            }
            if (pv instanceof BytePrimitiveVector) {
                ((BytePrimitiveVector)pv).setValue(j, (byte)i);
            }
            if (pv instanceof Float32PrimitiveVector) {
                ((Float32PrimitiveVector)pv).setValue(j, (float)Math.sin((double)i / 100.0));
            }
            if (pv instanceof Float64PrimitiveVector) {
                ((Float64PrimitiveVector)pv).setValue(j, Math.cos((double)i / 100.0));
            }
            if (pv instanceof Int16PrimitiveVector) {
                ((Int16PrimitiveVector)pv).setValue(j, (short)(i * 256));
            }
            if (pv instanceof UInt16PrimitiveVector) {
                ((UInt16PrimitiveVector)pv).setValue(j, (short)(i * 1024));
            }
            if (pv instanceof Int32PrimitiveVector) {
                ((Int32PrimitiveVector)pv).setValue(j, i * 2048);
            }
            if (pv instanceof UInt32PrimitiveVector) {
                ((UInt32PrimitiveVector)pv).setValue(j, i * 4096);
            }
            ++j;
        }
        if (_Debug) {
            System.out.println("");
        }
    }

    public void loadTestList(String datasetName, test_SDList tl) throws NoSuchVariableException, IOException, EOFException {
        if (_Debug) {
            System.out.println("STARTING.....................test_SDList.read(" + datasetName + "): ");
        }
        if (_Debug) {
            System.out.println("Loading: " + tl.getName() + " (an SDList)");
        }
        PrimitiveVector pv = tl.getPrimitiveVector();
        if (_Debug) {
            Class<?> cl = pv.getClass();
            System.out.println("PrimitiveVector is a: " + cl.getName());
        }
        int ListLength = 3;
        pv.setLength(ListLength);
        if (_Debug) {
            System.out.println("List length arbitrarily set to: " + pv.getLength());
        }
        if (_Debug) {
            System.out.println("Loading:");
        }
        int j = 0;
        while (j < ListLength) {
            if (_Debug) {
                System.out.print(".");
            }
            if (pv instanceof BaseTypePrimitiveVector) {
                BaseType bt = pv.getTemplate();
                BaseType newBT = (BaseType)bt.clone();
                newBT.setName("testSDList_" + newBT.getName() + "[" + j + "]");
                ((BaseTypePrimitiveVector)pv).setValue(j, newBT);
                newBT = ((BaseTypePrimitiveVector)pv).getValue(j);
                boolean MoreToRead = !(bt instanceof DSequence);
                int pass = 0;
                while (MoreToRead) {
                    if (_Debug) {
                        System.out.println("\nPass(" + pass + "), reading data into " + newBT.getTypeName() + ":");
                    }
                    if (_Debug) {
                        newBT.printDecl(System.out);
                    }
                    MoreToRead = ((ServerMethods)((Object)newBT)).read(datasetName, this);
                    if (_Debug) {
                        System.out.println("Read returned: " + MoreToRead);
                    }
                    ++pass;
                }
            }
            if (pv instanceof BooleanPrimitiveVector) {
                if (j % 2 != 0) {
                    ((BooleanPrimitiveVector)pv).setValue(j, true);
                } else {
                    ((BooleanPrimitiveVector)pv).setValue(j, false);
                }
            }
            if (pv instanceof BytePrimitiveVector) {
                ((BytePrimitiveVector)pv).setValue(j, (byte)j);
            }
            if (pv instanceof Float32PrimitiveVector) {
                ((Float32PrimitiveVector)pv).setValue(j, (float)Math.sin((double)j / 100.0));
            }
            if (pv instanceof Float64PrimitiveVector) {
                ((Float64PrimitiveVector)pv).setValue(j, Math.cos((double)j / 100.0));
            }
            if (pv instanceof Int16PrimitiveVector) {
                ((Int16PrimitiveVector)pv).setValue(j, (short)(j * 255));
            }
            if (pv instanceof UInt16PrimitiveVector) {
                ((UInt16PrimitiveVector)pv).setValue(j, (short)(j * 1024));
            }
            if (pv instanceof Int32PrimitiveVector) {
                ((Int32PrimitiveVector)pv).setValue(j, j * 2048);
            }
            if (pv instanceof UInt32PrimitiveVector) {
                ((UInt32PrimitiveVector)pv).setValue(j, j * 4096);
            }
            ++j;
        }
        if (_Debug) {
            System.out.println("");
        }
        if (_Debug) {
            System.out.println("FINISHED....................test_SDList.read(" + datasetName + "): ");
        }
    }

    public void loadTestGrid(String datasetName, test_SDGrid tg) throws NoSuchVariableException, IOException, EOFException {
        SDArray da = (SDArray)tg.getVar(0);
        if (da.isProject()) {
            da.read(datasetName, this);
        }
        int i = 0;
        while (i < da.numDimensions()) {
            try {
                DArrayDimension dad = da.getDimension(i);
            }
            catch (InvalidParameterException e) {
                throw new NoSuchVariableException(e.getMessage());
            }
            SDArray sam = (SDArray)tg.getVar(i + 1);
            if (sam.isProject()) {
                sam.read(datasetName, this);
            }
            ++i;
        }
    }
}

