/*
 * Decompiled with CFR 0.152.
 */
package dods.servers.test;

import dods.dap.BaseType;
import dods.dap.DConstructor;
import dods.dap.DODSException;
import dods.dap.Server.CEEvaluator;
import dods.dap.Server.ClauseFactory;
import dods.dap.Server.FunctionLibrary;
import dods.dap.Server.ServerDDS;
import dods.dap.parser.ParseException;
import dods.servers.test.testDataset;
import dods.servers.test.testEngine;
import dods.servers.test.test_SDArray;
import dods.servlet.DODSServlet;
import dods.servlet.GuardedDataset;
import dods.servlet.requestState;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class dts
extends DODSServlet {
    private static FunctionLibrary functionLibrary = new FunctionLibrary("dods.servers.test.SSF");
    private String ServerVersion = "DODS/3.2";

    public String getServerVersion() {
        return this.ServerVersion;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        httpServletResponse.setHeader("Last-Modified", new Date().toString());
        super.doGet(httpServletRequest, httpServletResponse);
    }

    public void doGetDODS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, requestState requestState2) throws IOException, ServletException {
        FilterOutputStream filterOutputStream;
        System.out.println("Sending DODS Data For: " + requestState2.getDataSet());
        httpServletResponse.setContentType("application/octet-stream");
        httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
        httpServletResponse.setHeader("Content-Description", "dods_data");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (requestState2.getAcceptsCompressed()) {
            httpServletResponse.setHeader("Content-Encoding", "deflate");
            filterOutputStream = new DeflaterOutputStream((OutputStream)servletOutputStream);
        } else {
            filterOutputStream = new BufferedOutputStream((OutputStream)servletOutputStream);
        }
        try {
            GuardedDataset guardedDataset = this.getDataset(requestState2);
            ServerDDS serverDDS = guardedDataset.getDDS();
            this.cacheArrayShapes(serverDDS);
            CEEvaluator cEEvaluator = new CEEvaluator(serverDDS, new ClauseFactory(functionLibrary));
            cEEvaluator.parseConstraint(requestState2.getConstraintExpression());
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(filterOutputStream));
            serverDDS.printConstrained(printWriter);
            printWriter.flush();
            ((OutputStream)filterOutputStream).write("\nData:\n".getBytes());
            ((OutputStream)filterOutputStream).flush();
            DataOutputStream dataOutputStream = new DataOutputStream(filterOutputStream);
            testEngine testEngine2 = new testEngine();
            cEEvaluator.send(serverDDS.getName(), dataOutputStream, testEngine2);
            dataOutputStream.flush();
            if (requestState2.getAcceptsCompressed()) {
                ((DeflaterOutputStream)filterOutputStream).finish();
            }
        }
        catch (DODSException dODSException) {
            this.dodsExceptionHandler(dODSException, httpServletResponse);
        }
        catch (ParseException parseException) {
            this.parseExceptionHandler(parseException, httpServletResponse);
        }
        httpServletResponse.setStatus(200);
    }

    private void cacheArrayShapes(ServerDDS serverDDS) {
        Enumeration enumeration = serverDDS.getVariables();
        while (enumeration.hasMoreElements()) {
            BaseType baseType = (BaseType)enumeration.nextElement();
            this.cAS(baseType);
        }
    }

    private void cAS(BaseType baseType) {
        if (baseType instanceof DConstructor) {
            Enumeration enumeration = ((DConstructor)baseType).getVariables();
            while (enumeration.hasMoreElements()) {
                BaseType baseType2 = (BaseType)enumeration.nextElement();
                this.cAS(baseType2);
            }
        } else if (baseType instanceof test_SDArray) {
            ((test_SDArray)baseType).cacheShape();
        }
    }

    protected GuardedDataset getDataset(requestState requestState2) throws DODSException, IOException, ParseException {
        return new testDataset(requestState2);
    }
}

