/*
 * Decompiled with CFR 0.152.
 */
package dods.servers.test;

import dods.dap.BaseType;
import dods.dap.DODSException;
import dods.dap.Server.CEEvaluator;
import dods.dap.Server.ServerDDS;
import dods.dap.Server.ServerMethods;
import dods.servers.test.test_ServerFactory;
import gnu.getopt.Getopt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;

public class SDTest {
    public static boolean Debug = false;
    public static String DDSFile;
    public static String ConstraintExpression;

    public static void print_SDDS(ServerDDS serverDDS, boolean bl) {
        System.out.println("vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv");
        System.out.println("ServerDDS:");
        Enumeration enumeration = serverDDS.getVariables();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            ServerMethods serverMethods = (ServerMethods)e;
            BaseType baseType = (BaseType)e;
            System.out.println(baseType.getTypeName() + " " + baseType.getName() + ":");
            System.out.println("Constrained DDS:");
            baseType.printDecl(System.out, "    ", true, bl);
            System.out.println("Declaration and Value:");
            if (serverMethods.isRead()) {
                baseType.printVal(System.out, "    ", true);
            } else {
                baseType.printDecl(System.out, "    ");
            }
            System.out.print(" isProj: " + serverMethods.isProject());
            System.out.print("    isRead: " + serverMethods.isRead());
            System.out.println("    isSynth: " + serverMethods.isSynthesized());
            if (!enumeration.hasMoreElements()) continue;
            System.out.println("- - - - - - - - - - - - - - - - - -");
        }
        System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    public static void parse_options(String[] stringArray) {
        int n;
        Getopt getopt = new Getopt("SDTest", stringArray, "f:c:");
        block5: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 102: {
                    String string = getopt.getOptarg();
                    if (Debug) {
                        System.out.print("DDS File: " + (string != null ? string : "null") + "\n");
                    }
                    DDSFile = string;
                    break;
                }
                case 99: {
                    String string = getopt.getOptarg();
                    if (Debug) {
                        System.out.print("Constraint Expression: \"" + (string != null ? string : "null") + "\"\n");
                    }
                    ConstraintExpression = string;
                    break;
                }
                case 63: {
                    break;
                }
                default: {
                    if (!Debug) continue block5;
                    System.out.print("getopt() returned " + n + "\n");
                }
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        SDTest sDTest = new SDTest();
        try {
            System.out.println("-------------------------------------------");
            System.out.println("Debugging Display: " + (Debug ? "ON" : "OFF"));
            SDTest.parse_options(stringArray);
            System.out.println("...........................................");
            File file = new File(DDSFile);
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            test_ServerFactory test_ServerFactory2 = new test_ServerFactory();
            ServerDDS serverDDS = new ServerDDS("bogus", test_ServerFactory2);
            if (Debug) {
                System.out.println("Parsing DDS...");
            }
            serverDDS.parse(dataInputStream);
            if (Debug) {
                System.out.println("Printing DDS...");
            }
            serverDDS.print(System.out);
            SDTest.print_SDDS(serverDDS, false);
            if (Debug) {
                System.out.println("Constructing CEEvaluator...");
            }
            CEEvaluator cEEvaluator = new CEEvaluator(serverDDS);
            File file2 = new File("a.out");
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            if (Debug) {
                System.out.println("Parsing Constraint Expression: " + ConstraintExpression);
            }
            cEEvaluator.parseConstraint(ConstraintExpression);
            if (Debug) {
                System.out.println("Attempting to send data...");
            }
            cEEvaluator.send(serverDDS.getName(), dataOutputStream, null);
            SDTest.print_SDDS(serverDDS, true);
            serverDDS.printConstrained(System.out);
            System.out.println("-------------------------------------------");
        }
        catch (DODSException dODSException) {
            System.out.println("\n\nERROR of Type: " + dODSException.getClass().getName() + "\n");
            System.out.println("Message:\n" + dODSException.getMessage() + "\n");
            System.out.println("Stack Trace: ");
            dODSException.printStackTrace(System.out);
            System.out.println("\n\n");
        }
        System.exit(0);
    }
}

