/*
 * Decompiled with CFR 0.152.
 */
package dods.servers.sql;

import dods.dap.BaseType;
import dods.dap.DAS;
import dods.dap.DConstructor;
import dods.dap.DDSException;
import dods.dap.DODSException;
import dods.dap.DVector;
import dods.dap.PrimitiveVector;
import dods.dap.Server.ServerDDS;
import dods.dap.Server.ServerMethods;
import dods.dap.parser.ParseException;
import dods.servers.sql.sqlCEEval;
import dods.servers.sql.sqlDDS;
import dods.servers.sql.sqlResponse;
import dods.servers.sql.sqlServerFactory;
import dods.util.DODSiniFile;
import gnu.getopt.Getopt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;

public class sqlTest {
    public static String DDSFile;
    public static String ConstraintExpression;
    private static boolean Debug;
    private static PrintStream dOut;
    private static int Level;

    public static void print_SDDS(ServerDDS serverDDS, boolean bl) {
        System.out.println("vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv");
        System.out.println("sqlDDS:");
        Enumeration enumeration = serverDDS.getVariables();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            ServerMethods serverMethods = (ServerMethods)e;
            BaseType baseType = (BaseType)e;
            System.out.println(baseType.getTypeName() + " " + baseType.getName() + ":");
            System.out.println("Constrained DDS:");
            baseType.printDecl(System.out, "    ", true, bl);
            System.out.println("Declaration and Value:");
            if (serverMethods.isRead()) {
                try {
                    baseType.printVal(System.out, "    ", true);
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println(" Instance not Allocated.");
                }
            } else {
                System.out.println(" Item not yet initialized.");
            }
            System.out.print(" isProj: " + serverMethods.isProject());
            System.out.print("    isRead: " + serverMethods.isRead());
            System.out.println("    isSynth: " + serverMethods.isSynthesized());
            if (!enumeration.hasMoreElements()) continue;
            System.out.println("- - - - - - - - - - - - - - - - - -");
        }
        System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    public static void parse_options(String[] stringArray) {
        int n;
        Getopt getopt = new Getopt("SDTest", stringArray, "f:c:");
        block5: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 102: {
                    String string = getopt.getOptarg();
                    if (Debug) {
                        dOut.print("DDS File: " + (string != null ? string : "null") + "\n");
                    }
                    DDSFile = string;
                    break;
                }
                case 99: {
                    String string = getopt.getOptarg();
                    if (Debug) {
                        dOut.print("Constraint Expression: \"" + (string != null ? string : "null") + "\"\n");
                    }
                    ConstraintExpression = string;
                    break;
                }
                case 63: {
                    break;
                }
                default: {
                    if (!Debug) continue block5;
                    dOut.print("getopt() returned " + n + "\n");
                }
            }
        }
    }

    public static sqlDDS getDDS() throws FileNotFoundException, DDSException, ParseException {
        File file = new File(DDSFile);
        FileInputStream fileInputStream = new FileInputStream(file);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        sqlServerFactory sqlServerFactory2 = new sqlServerFactory();
        sqlDDS sqlDDS2 = new sqlDDS("bogus", sqlServerFactory2);
        if (Debug) {
            dOut.println("Parsing DDS...");
        }
        sqlDDS2.parse(dataInputStream);
        return sqlDDS2;
    }

    public static void main(String[] stringArray) throws Exception {
        sqlTest sqlTest2 = new sqlTest();
        dOut = System.out;
        Debug = true;
        try {
            Statement statement;
            ResultSet resultSet;
            File file = new File("a.out");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            System.out.println("-------------------------------------------");
            System.out.println("Debugging Display: " + (Debug ? "ON" : "OFF"));
            sqlTest.parse_options(stringArray);
            System.out.println("...........................................");
            sqlDDS sqlDDS2 = sqlTest.getDDS();
            DAS dAS = new DAS();
            sqlDDS2.print(System.out);
            if (Debug) {
                dOut.println("Constructing CEEvaluator...");
            }
            sqlCEEval sqlCEEval2 = new sqlCEEval(sqlDDS2);
            if (Debug) {
                dOut.println("Parsing Constraint Expression: " + ConstraintExpression);
            }
            sqlCEEval2.parseConstraint(ConstraintExpression);
            sqlDDS2.printConstrained(dOut);
            String string = sqlCEEval2.getSQLQuery(dAS, true);
            if (Debug) {
                dOut.println("Query String: \"" + string + "\"");
            }
            if ((resultSet = (statement = sqlTest.connect2DB()).executeQuery(string)).next() && resultSet.isFirst()) {
                sqlTest.processResult(resultSet);
                System.out.println("ResultSet.isFirst(): " + resultSet.isFirst());
                System.out.println("ResultSet.first(): " + resultSet.first());
                System.out.println("ResultSet.absolute(1): " + resultSet.absolute(1));
                sqlResponse sqlResponse2 = new sqlResponse(resultSet);
                if (Debug) {
                    dOut.println("Attempting to send data...");
                }
                sqlCEEval2.send(sqlDDS2.getName(), dataOutputStream, sqlResponse2);
                sqlTest.print_SDDS(sqlDDS2, true);
                sqlDDS2.printConstrained(dOut);
            } else {
                System.out.println("\n\n\nYour Query Produced No Matches in The Database.\n\n");
            }
            statement.close();
            System.out.println("-------------------------------------------");
            dataOutputStream.close();
        }
        catch (DODSException dODSException) {
            System.out.println("\n\nERROR of Type: " + dODSException.getClass().getName() + "\n");
            System.out.println("Message:\n" + dODSException.getMessage() + "\n");
            System.out.println("Stack Trace: ");
            dODSException.printStackTrace(System.out);
            System.out.println("\n\n");
        }
        System.exit(0);
    }

    public static void testNameBuilder(sqlDDS sqlDDS2) {
        Enumeration enumeration = sqlDDS2.getVariables();
        while (enumeration.hasMoreElements()) {
            BaseType baseType = (BaseType)enumeration.nextElement();
            System.out.println("\nHighest Level. Starting On: " + baseType.getName());
            sqlTest.nameDigger(baseType, sqlDDS2);
        }
    }

    private static void nameDigger(BaseType baseType, sqlDDS sqlDDS2) {
        System.out.print("Item: \"" + baseType.getName() + "\"\t\tFullName: \"" + baseType.getLongName() + "\"");
        System.out.print("\t\tLevel: " + ++Level);
        Object var2_2 = null;
        if (baseType instanceof DConstructor) {
            System.out.print("(It's a DConstructor...)\n");
            Enumeration enumeration = ((DConstructor)baseType).getVariables();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                BaseType baseType2 = (BaseType)enumeration.nextElement();
                sqlTest.nameDigger(baseType2, sqlDDS2);
            }
        } else if (baseType instanceof DVector) {
            System.out.print("(It's a DVector...)\n");
            PrimitiveVector primitiveVector = ((DVector)baseType).getPrimitiveVector();
            sqlTest.nameDigger(primitiveVector.getTemplate(), sqlDDS2);
        }
        System.out.println("");
        --Level;
    }

    public static Statement connect2DB() throws SQLException, FileNotFoundException, IOException {
        Object object;
        Connection connection = null;
        Statement statement = null;
        Object object2 = "openlink.jdbc2.Driver";
        Object object3 = "jdbc:openlink://cupcake.oce.orst.edu/DSN=oplEOSDB";
        Object object4 = "";
        Object object5 = "";
        DODSiniFile dODSiniFile = new DODSiniFile();
        if (dODSiniFile.setSection("JDBC")) {
            object = null;
            object = dODSiniFile.getProperty("driver");
            if (object != null) {
                object2 = object;
            }
            if ((object = dODSiniFile.getProperty("connectionurl")) != null) {
                object3 = object;
            }
            if ((object = dODSiniFile.getProperty("username")) != null) {
                object4 = object;
            }
            if ((object = dODSiniFile.getProperty("password")) != null) {
                object5 = object;
            }
        }
        if (Debug) {
            dOut.println("Using JDBC Driver:    " + (String)object2);
        }
        if (Debug) {
            dOut.println("Using Connection URL: " + (String)object3);
        }
        object = System.getProperties();
        ((Properties)object).put("jdbc.drivers", object2);
        System.setProperties((Properties)object);
        connection = DriverManager.getConnection((String)object3, (String)object4, (String)object5);
        statement = connection.createStatement(1004, 1007);
        return statement;
    }

    public static void processResult(ResultSet resultSet) throws SQLException, IOException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        sqlTest.printColumnNames(resultSetMetaData);
        int n2 = 0;
        resultSet.beforeFirst();
        dOut.println("ResultSet.isFirst(): " + resultSet.isFirst());
        boolean bl = false;
        while (resultSet.next() && !bl) {
            dOut.print(".");
            ++n2;
            bl = resultSet.isLast();
        }
        dOut.println("\nScanned " + n2 + " rows...");
        resultSet.beforeFirst();
        dOut.println("ResultSet.isFirst(): " + resultSet.isFirst());
        if (n2 > 1) {
            return;
        }
        bl = false;
        while (resultSet.next() && !bl) {
            dOut.print(".");
            bl = resultSet.isLast();
        }
        dOut.println("\nScanned " + n2 + " rows...");
        dOut.println("limit: " + n2);
    }

    public static void printColumnNames(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        String string = "";
        int n2 = 1;
        while (n2 <= n) {
            String string2 = resultSetMetaData.getCatalogName(n2);
            String string3 = resultSetMetaData.getColumnLabel(n2);
            String string4 = resultSetMetaData.getSchemaName(n2);
            String string5 = resultSetMetaData.getTableName(n2);
            String string6 = resultSetMetaData.getColumnName(n2);
            String string7 = resultSetMetaData.getColumnTypeName(n2);
            System.out.println("NAMES:");
            System.out.println("getCatalogName():     " + string2);
            System.out.println("getColumnLabel():     " + string3);
            System.out.println("getSchemaName():      " + string4);
            System.out.println("getTableName():       " + string5);
            System.out.println("getColumnName():      " + string6);
            System.out.println("getColumnTypeName():  " + string7);
            String string8 = string6;
            String string9 = resultSetMetaData.getColumnTypeName(n2);
            string8 = string8 == null ? "NULL  " : string8 + "(" + string9 + ")  ";
            string = string + string8;
            ++n2;
        }
        dOut.println(string);
        int n3 = 0;
        while (n3 < string.length()) {
            dOut.print("-");
            ++n3;
        }
        dOut.println("");
    }

    static {
        Level = 0;
    }
}

