/*
 * Decompiled with CFR 0.152.
 */
package dods.servers.sql;

import dods.dap.NoSuchVariableException;
import dods.dap.Server.CEEvaluator;
import dods.dap.Server.SDFloat64;
import dods.dap.Server.SDODSException;
import dods.servers.sql.sqlResponse;
import dods.util.Debug;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class sqlF64
extends SDFloat64 {
    public sqlF64() {
    }

    public sqlF64(String string) {
        super(string);
    }

    public boolean read(String string, Object object) throws NoSuchVariableException, IOException, EOFException {
        double d;
        sqlResponse sqlResponse2 = (sqlResponse)object;
        ResultSet resultSet = sqlResponse2.getResultSet();
        int n = sqlResponse2.getCurrentColumn();
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (Debug.isSet("sqlRead")) {
                System.out.println("--  --  --  --  --  --  --  --  --  --  --  --  --  --");
                System.out.println(this.getClass().getName() + ":");
                System.out.println("Reading " + this.getName() + " from column (" + n + ")");
                System.out.println("Column Name: " + resultSetMetaData.getColumnName(n));
                System.out.println("Column Type: " + resultSetMetaData.getColumnType(n));
                System.out.println("Column Type Name(rsmd): " + resultSetMetaData.getColumnTypeName(n));
            }
            switch (resultSetMetaData.getColumnType(n)) {
                case 6: 
                case 7: {
                    d = resultSet.getFloat(n);
                    break;
                }
                case 8: {
                    d = resultSet.getDouble(n);
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal = resultSet.getBigDecimal(n);
                    d = bigDecimal != null ? bigDecimal.doubleValue() : Double.NaN;
                    if (!Debug.isSet("sqlRead")) break;
                    System.out.println("WARNING: This conversion (from NUMERIC to Float64) may cause a loss of precision!");
                    break;
                }
                default: {
                    throw new NoSuchVariableException("Type Mismatch! Cannot represent the JDBC Type: " + resultSetMetaData.getColumnType(n) + " (" + resultSetMetaData.getColumnTypeName(n) + ") as the DODS type: DFloat64");
                }
            }
            if (resultSet.wasNull()) {
                if (Debug.isSet("sqlRead")) {
                    System.out.println("ResultSet Column " + n + " contains a NULL value!");
                }
                d = Double.NaN;
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
        if (Debug.isSet("sqlRead")) {
            System.out.println("Float64 received from SQl Query: \"" + d + "\"");
        }
        this.setValue(d);
        this.setRead(true);
        sqlResponse2.nextColumn();
        return false;
    }

    public void serialize(String string, DataOutputStream dataOutputStream, CEEvaluator cEEvaluator, Object object) throws NoSuchVariableException, SDODSException, IOException {
        if (!this.isRead()) {
            this.read(string, object);
        }
        this.externalize(dataOutputStream);
    }
}

