/*
 * Decompiled with CFR 0.152.
 */
package dods.servers.sql;

import dods.dap.DAS;
import dods.dap.DODSException;
import dods.dap.Server.FunctionLibrary;
import dods.dap.parser.ParseException;
import dods.servers.sql.GuardedSQLDataset;
import dods.servers.sql.SqlClauseFac;
import dods.servers.sql.sqlCEEval;
import dods.servers.sql.sqlDDS;
import dods.servers.sql.sqlResponse;
import dods.servlet.DODSServlet;
import dods.servlet.GuardedDataset;
import dods.servlet.requestState;
import dods.util.Debug;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class dodsSQLServlet
extends DODSServlet {
    private static final boolean _Debug = false;

    protected abstract GuardedSQLDataset getSQLDataset(requestState var1) throws DODSException, IOException, ParseException;

    protected GuardedDataset getDataset(requestState requestState2) throws DODSException, IOException, ParseException {
        return this.getSQLDataset(requestState2);
    }

    public abstract String getServerVersion();

    public void init() throws ServletException {
        super.init();
        String string = "openlink.jdbc2.Driver";
        String string2 = this.getInitParameter("JDBCdriver");
        if (string2 != null) {
            string = string2;
        }
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServletException("\n Cannot Load JDBC Driver Class: " + classNotFoundException.getMessage() + "\n Is the driver name spelled correctly?" + "\n Is the .class file or the jar file" + "\n containing the driver on the CLASSPATH ??\n\n");
        }
        System.out.println("Using JDBC Driver:    " + string);
    }

    public void doGetDODS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, requestState requestState2) throws IOException, ServletException {
        FilterOutputStream filterOutputStream;
        if (Debug.isSet("showResponse")) {
            System.out.println("DRDS   Sending DODS Data For: " + requestState2.getDataSet() + "    CE: '" + requestState2.getConstraintExpression() + "'");
        }
        httpServletResponse.setContentType("application/octet-stream");
        httpServletResponse.setHeader("XDODS-Server", this.getServerVersion());
        httpServletResponse.setHeader("Content-Description", "dods_data");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (requestState2.getAcceptsCompressed()) {
            httpServletResponse.setHeader("Content-Encoding", "deflate");
            filterOutputStream = new DeflaterOutputStream((OutputStream)servletOutputStream);
        } else {
            filterOutputStream = new BufferedOutputStream((OutputStream)servletOutputStream);
        }
        GuardedSQLDataset guardedSQLDataset = null;
        try {
            Statement statement;
            ResultSet resultSet;
            guardedSQLDataset = this.getSQLDataset(requestState2);
            sqlDDS sqlDDS2 = guardedSQLDataset.getSQLDDS();
            DAS dAS = guardedSQLDataset.getDAS();
            FunctionLibrary functionLibrary = new FunctionLibrary();
            functionLibrary.setPrefix("dods.servers.sql.SSF");
            SqlClauseFac sqlClauseFac = new SqlClauseFac(functionLibrary);
            sqlCEEval sqlCEEval2 = new sqlCEEval(sqlDDS2, sqlClauseFac);
            sqlCEEval2.parseConstraint(requestState2.getConstraintExpression());
            boolean bl = false;
            String string = this.getInitParameter("UseDatasetName");
            if (string != null && (string.equals("") || string.equalsIgnoreCase("true"))) {
                bl = true;
            }
            System.out.println("UseDataSetName is: " + bl);
            String string2 = sqlCEEval2.getSQLQuery(dAS, bl);
            if (Debug.isSet("showRequest")) {
                System.out.println("Query String: \"" + string2 + "\"");
            }
            if ((resultSet = (statement = this.connect2DB(requestState2)).executeQuery(string2)).next()) {
                int n = 10;
                string = requestState2.getInitParameter("JDBCMaxResponseLength");
                if (string != null) {
                    n = Integer.decode(string);
                }
                sqlResponse sqlResponse2 = new sqlResponse(resultSet, n);
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(filterOutputStream));
                sqlDDS2.printConstrained(printWriter);
                if (Debug.isSet("showResponse")) {
                    System.out.println("SQL query response recieved.\nSending Data...");
                }
                printWriter.flush();
                ((OutputStream)filterOutputStream).write("\nData:\n".getBytes());
                ((OutputStream)filterOutputStream).flush();
                DataOutputStream dataOutputStream = new DataOutputStream(filterOutputStream);
                sqlCEEval2.send(sqlDDS2.getName(), dataOutputStream, sqlResponse2);
                dataOutputStream.flush();
                if (requestState2.getAcceptsCompressed()) {
                    ((DeflaterOutputStream)filterOutputStream).finish();
                }
                if (Debug.isSet("showResponse")) {
                    System.out.println("Done!");
                }
            } else {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)servletOutputStream);
                httpServletResponse.setHeader("Content-Description", "dods_error");
                httpServletResponse.setHeader("Content-Encoding", "");
                DODSException dODSException = new DODSException("Your Query Produced No Matching Results.");
                dODSException.print(bufferedOutputStream);
                dODSException.print(System.out);
            }
            statement.close();
        }
        catch (DODSException dODSException) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)servletOutputStream);
            httpServletResponse.setHeader("Content-Description", "dods_error");
            httpServletResponse.setHeader("Content-Encoding", "");
            dODSException.print(bufferedOutputStream);
            dODSException.print(System.out);
        }
        catch (SQLException sQLException) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)servletOutputStream);
            httpServletResponse.setHeader("Content-Description", "dods_error");
            httpServletResponse.setHeader("Content-Encoding", "");
            DODSException dODSException = new DODSException(sQLException.toString());
            dODSException.print(bufferedOutputStream);
            dODSException.print(System.out);
        }
        catch (ParseException parseException) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)servletOutputStream);
            httpServletResponse.setHeader("Content-Description", "dods_error");
            httpServletResponse.setHeader("Content-Encoding", "");
            String string = parseException.getMessage().replace('\"', '\'');
            DODSException dODSException = new DODSException(5, string);
            dODSException.print(bufferedOutputStream);
            dODSException.print(System.out);
        }
        httpServletResponse.setStatus(200);
    }

    public Statement connect2DB(requestState requestState2) throws SQLException, IOException {
        Connection connection = null;
        Statement statement = null;
        String string = "";
        String string2 = "jdbc:openlink://cupcake.oce.orst.edu/DSN=oplEOSDB";
        String string3 = "";
        String string4 = "";
        String string5 = null;
        string5 = this.getInitParameter("JDBCdriver");
        if (string5 != null) {
            string = string5;
        }
        if ((string5 = this.getInitParameter("JDBCconnectionURL")) != null) {
            string2 = string5;
        }
        if ((string5 = this.getInitParameter("JDBCusername")) != null) {
            string3 = string5;
        }
        if ((string5 = this.getInitParameter("JDBCpassword")) != null) {
            string4 = string5;
        }
        if (Debug.isSet("JDBC")) {
            System.out.println("Using JDBC Driver:    " + string);
        }
        if (Debug.isSet("JDBC")) {
            System.out.println("Using Connection URL: " + string2);
        }
        connection = DriverManager.getConnection(string2, string3, string4);
        statement = connection.createStatement();
        return statement;
    }

    public void processResult(ResultSet resultSet, PrintStream printStream) throws SQLException, IOException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.printColumnNames(resultSetMetaData, printStream);
        int n2 = 0;
        while (n2++ < 10) {
            int n3 = 1;
            while (n3 <= n) {
                String string = resultSet.getString(n3);
                if (string == null) {
                    printStream.println("null ");
                    System.out.print("null ");
                }
                printStream.print(string + "   ");
                System.out.print(string + "   ");
                ++n3;
            }
            printStream.println("");
            System.out.println("");
            resultSet.next();
        }
        printStream.println("limit: " + n2);
    }

    public void printColumnNames(ResultSetMetaData resultSetMetaData, PrintStream printStream) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        String string = "";
        int n2 = 1;
        while (n2 <= n) {
            String string2 = resultSetMetaData.getColumnName(n2);
            String string3 = resultSetMetaData.getColumnTypeName(n2);
            string2 = string2 == null ? "NULL  " : string2 + "(" + string3 + ")  ";
            string = string + string2;
            ++n2;
        }
        printStream.println(string);
        int n3 = 0;
        while (n3 < string.length()) {
            printStream.print("-");
            ++n3;
        }
        printStream.println("");
    }
}

