/*
 * Decompiled with CFR 0.152.
 */
package dods.dap.test;

import dods.dap.DODSException;
import dods.dap.Server.CEEvaluator;
import dods.dap.Server.ClauseFactory;
import dods.dap.Server.ServerDDS;
import dods.dap.parser.ExprParser;
import dods.dap.parser.ExprParserTokenManager;
import dods.dap.parser.ParseException;
import dods.dap.parser.SimpleCharStream;
import dods.dap.parser.Token;
import dods.servers.test.test_ServerFactory;
import dods.util.Getopts;
import dods.util.InvalidSwitch;

public class expr_test {
    private static final String prompt = "expr-test: ";
    private static final String version = "version 0.1";

    private static void usage() {
        System.err.println("usage: expr-test [s] [p]");
        System.err.println(" s: Test the scanner.");
        System.err.println(" p: Test the parser; reads from stdin and prints the");
        System.err.println("    internal structure to stdout.");
    }

    public static void main(String[] args) {
        boolean parser_test = false;
        boolean scanner_test = false;
        try {
            Getopts opts = new Getopts("sp", args);
            if (opts.getSwitch((Character)new Character((char)'p')).set) {
                parser_test = true;
            }
            if (opts.getSwitch((Character)new Character((char)'s')).set) {
                scanner_test = true;
            }
        }
        catch (InvalidSwitch e) {
            expr_test.usage();
            System.exit(1);
        }
        if (!parser_test && !scanner_test) {
            expr_test.usage();
            System.exit(1);
        }
        if (scanner_test) {
            expr_test.test_scanner();
        }
        if (parser_test) {
            expr_test.test_parser();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static void test_scanner() {
        block27: {
            Token tok;
            ExprParserTokenManager token_source;
            block26: {
                SimpleCharStream jj_input_stream = new SimpleCharStream(System.in, 1, 1);
                token_source = new ExprParserTokenManager(jj_input_stream);
                System.out.print(prompt);
                System.out.flush();
                if (!true) break block26;
                tok = token_source.getNextToken();
                if (tok.kind == 0) break block27;
            }
            do {
                void var0_2;
                switch (var0_2.kind) {
                    case 5: {
                        System.out.println("Equal");
                        break;
                    }
                    case 6: {
                        System.out.println("Not equal");
                        break;
                    }
                    case 7: {
                        System.out.println("Greater than");
                        break;
                    }
                    case 8: {
                        System.out.println("Greater than or equal");
                        break;
                    }
                    case 9: {
                        System.out.println("Less than");
                        break;
                    }
                    case 10: {
                        System.out.println("Less than or equal");
                        break;
                    }
                    case 11: {
                        System.out.println("Regular expression");
                        break;
                    }
                    case 12: {
                        System.out.println("Left Bracket");
                        break;
                    }
                    case 13: {
                        System.out.println("Right Bracket");
                        break;
                    }
                    case 14: {
                        System.out.println("Colon");
                        break;
                    }
                    case 15: {
                        System.out.println("Asterisk");
                        break;
                    }
                    case 16: {
                        System.out.println("Comma");
                        break;
                    }
                    case 17: {
                        System.out.println("Ampersand");
                        break;
                    }
                    case 18: {
                        System.out.println("Left Parenthesis");
                        break;
                    }
                    case 19: {
                        System.out.println("Right Parenthesis");
                        break;
                    }
                    case 20: {
                        System.out.println("Left Brace");
                        break;
                    }
                    case 21: {
                        System.out.println("Right Brace");
                        break;
                    }
                    case 23: {
                        System.out.println("ID: " + var0_2.image);
                        break;
                    }
                    case 24: {
                        System.out.println("INT: " + var0_2.image);
                        break;
                    }
                    case 25: {
                        System.out.println("FLOAT: " + var0_2.image);
                        break;
                    }
                    case 28: {
                        System.out.println("STR: " + var0_2.image);
                        break;
                    }
                    case 31: {
                        System.out.println("UNTERN_QUOTE: " + var0_2.image);
                        break;
                    }
                    default: {
                        System.out.println("Error: Unrecognized input");
                    }
                }
                System.out.print(prompt);
                System.out.flush();
                tok = token_source.getNextToken();
            } while (tok.kind != 0);
        }
    }

    private static void test_parser() {
        ExprParser expr = new ExprParser(System.in);
        try {
            test_ServerFactory factory = new test_ServerFactory();
            ServerDDS dds = new ServerDDS("ThisIsATestDDS", factory);
            CEEvaluator ceEval = new CEEvaluator(dds);
            expr.constraint_expression(ceEval, factory, new ClauseFactory());
            System.out.println("Status from parser: 1");
        }
        catch (ParseException pe) {
            System.out.println(pe.getMessage());
            System.out.println("Status from parser: 0");
        }
        catch (DODSException de) {
            System.out.println(de.getMessage());
            System.out.println("Status from parser: 0");
        }
    }
}

