/*
 * Decompiled with CFR 0.152.
 */
package dods.dap.test;

import dods.dap.Attribute;
import dods.dap.AttributeBadValueException;
import dods.dap.AttributeExistsException;
import dods.dap.AttributeTable;
import dods.dap.DAS;
import dods.dap.DASException;
import dods.dap.parser.DASParserTokenManager;
import dods.dap.parser.ParseException;
import dods.dap.parser.SimpleCharStream;
import dods.dap.parser.Token;
import dods.dap.parser.TokenMgrError;
import dods.util.Getopts;
import dods.util.InvalidSwitch;
import java.util.Enumeration;

public class das_test {
    private static final String prompt = "das-test: ";
    private static final String version = "version 0.1";

    private static void usage() {
        System.err.println("usage: das-test [-v] [-s] [-d] [-c] [-p] {< in-file > out-file}");
        System.err.println(" s: Test the DAS scanner.");
        System.err.println(" p: Scan and parse from <in-file>; print to <out-file>.");
        System.err.println(" c: Test building the DAS from code.");
        System.err.println(" v: Print the version of das-test and exit.");
        System.err.println(" d: Print parser debugging information.");
    }

    public static void main(String[] args) {
        boolean parser_test = false;
        boolean scanner_test = false;
        boolean code_test = false;
        try {
            Getopts opts = new Getopts("scpvd", args);
            if (opts.getSwitch((Character)new Character((char)'p')).set) {
                parser_test = true;
            }
            if (opts.getSwitch((Character)new Character((char)'s')).set) {
                scanner_test = true;
            }
            if (opts.getSwitch((Character)new Character((char)'c')).set) {
                code_test = true;
            }
            if (opts.getSwitch((Character)new Character((char)'v')).set) {
                System.err.println("das-test: version 0.1");
                System.exit(0);
            }
        }
        catch (InvalidSwitch e) {
            das_test.usage();
            System.exit(1);
        }
        DAS das = new DAS();
        if (!(parser_test || scanner_test || code_test)) {
            das_test.usage();
            System.exit(1);
        }
        if (parser_test) {
            das_test.parser_driver(das);
        }
        if (scanner_test) {
            das_test.test_scanner();
        }
        if (code_test) {
            das_test.plain_driver(das);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static void test_scanner() {
        block13: {
            Token tok;
            DASParserTokenManager token_source;
            block12: {
                SimpleCharStream jj_input_stream = new SimpleCharStream(System.in, 1, 1);
                token_source = new DASParserTokenManager(jj_input_stream);
                System.out.print(prompt);
                System.out.flush();
                if (!true) break block12;
                tok = token_source.getNextToken();
                if (tok.kind == 0) break block13;
            }
            do {
                void var0_2;
                switch (var0_2.kind) {
                    case 6: {
                        System.out.println("ATTR");
                        break;
                    }
                    case 7: {
                        System.out.println("ALIAS");
                        break;
                    }
                    case 8: {
                        System.out.println("BYTE");
                        break;
                    }
                    case 11: {
                        System.out.println("INT32");
                        break;
                    }
                    case 14: {
                        System.out.println("FLOAT64");
                        break;
                    }
                    case 15: {
                        System.out.println("STRING");
                        break;
                    }
                    case 16: {
                        System.out.println("URL");
                        break;
                    }
                    case 17: 
                    case 18: {
                        System.out.println("WORD=" + var0_2.image);
                        break;
                    }
                    default: {
                        System.out.println("Found: " + var0_2.image);
                    }
                }
                System.out.print(prompt);
                System.out.flush();
                tok = token_source.getNextToken();
            } while (tok.kind != 0);
        }
    }

    private static void parser_driver(DAS das) {
        try {
            das.parse(System.in);
            das.print(System.out);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.err.println("parse() returned: 0");
        }
        catch (DASException e) {
            System.err.println(e.getMessage());
            System.err.println("parse() returned: 0");
        }
        catch (TokenMgrError e) {
            System.err.println(e.getMessage());
            System.err.println();
            System.exit(2);
        }
    }

    private static void plain_driver(DAS das) {
        String name = "test";
        AttributeTable atp = new AttributeTable();
        das_test.load_attr_table(atp);
        AttributeTable dummy = das.getAttributeTable(name);
        das.addAttributeTable(name, atp);
        name = "test2";
        atp = new AttributeTable();
        das_test.load_attr_table(atp);
        das.addAttributeTable(name, atp);
        das.print(System.out);
    }

    private static void load_attr_table(AttributeTable at) {
        try {
            Enumeration es;
            Attribute a;
            String name;
            at.appendAttribute("month", 10, "Feb");
            at.appendAttribute("month", 10, "Feb");
            at.appendAttribute("month_a", 10, "Jan");
            at.appendAttribute("month_a", 10, "Feb");
            at.appendAttribute("month_a", 10, "Mar");
            at.appendAttribute("Date", 6, "12345");
            at.appendAttribute("day", 6, "01");
            at.appendAttribute("Time", 9, "3.1415");
            System.out.println("Using the Pix:");
            Enumeration e = at.getNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                a = at.getAttribute(name);
                System.out.print(name + " " + a.getTypeString() + " ");
                es = a.getValues();
                while (es.hasMoreElements()) {
                    System.out.print((String)es.nextElement() + " ");
                }
                System.out.println();
            }
            name = "month";
            a = at.getAttribute(name);
            System.out.println("Using String: " + a.getTypeString() + " " + a.getValueAt(0) + " " + a.getValueAt(1));
            System.out.println("Using char *: " + a.getTypeString() + " " + a.getValueAt(0) + " " + a.getValueAt(1));
            at.delAttribute("month");
            System.out.println("After deletion:");
            e = at.getNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                a = at.getAttribute(name);
                System.out.print(name + " " + a.getTypeString() + " ");
                es = a.getValues();
                while (es.hasMoreElements()) {
                    System.out.print((String)es.nextElement() + " ");
                }
                System.out.println();
            }
            at.print(System.out);
            System.out.println("After print:");
            e = at.getNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                a = at.getAttribute(name);
                System.out.print(name + " " + a.getTypeString() + " ");
                es = a.getValues();
                while (es.hasMoreElements()) {
                    System.out.print((String)es.nextElement() + " ");
                }
                System.out.println();
            }
        }
        catch (AttributeExistsException e) {
            System.err.println(e.getMessage());
        }
        catch (AttributeBadValueException e) {
            System.err.println(e.getMessage());
        }
    }
}

