/*
 * Decompiled with CFR 0.152.
 */
package dods.dap.test;

import dods.dap.AttributeTable;
import dods.dap.BadSemanticsException;
import dods.dap.BaseType;
import dods.dap.BaseTypePrimitiveVector;
import dods.dap.BytePrimitiveVector;
import dods.dap.DAS;
import dods.dap.DASException;
import dods.dap.DArray;
import dods.dap.DByte;
import dods.dap.DFloat64;
import dods.dap.DGrid;
import dods.dap.DInt32;
import dods.dap.DList;
import dods.dap.DSequence;
import dods.dap.DString;
import dods.dap.DStructure;
import dods.dap.DUInt32;
import dods.dap.DURL;
import dods.dap.DataDDS;
import dods.dap.Int32PrimitiveVector;
import dods.dap.NoSuchVariableException;
import dods.dap.ServerVersion;
import java.util.Vector;

public class dap_test {
    private static final String prompt = "dds-test: ";
    private static final String version = "version 0.1";

    public static void main(String[] args) {
        dap_test.test_das();
        dap_test.test_dds();
    }

    private static void test_das() {
        System.out.println("DAS test:");
        DAS table = new DAS();
        AttributeTable at = new AttributeTable();
        try {
            at.appendAttribute("Authors", 10, "jehamby");
            at.appendAttribute("Authors", 10, "jimg");
            at.addAlias("Creators", "Authors");
            AttributeTable cont = at.appendContainer("Container");
            cont.appendAttribute("Numbers", 6, "123");
            cont.appendAttribute("Floats", 9, "456.0");
            table.addAttributeTable("table1", at);
            at = new AttributeTable();
            at.appendAttribute("another", 3, "12");
            table.addAttributeTable("table2", at);
        }
        catch (DASException e) {
            System.out.println("Error constructing DAS: " + e);
        }
        table.print(System.out);
        String author2 = table.getAttributeTable("table1").getAttribute("Creators").getValueAt(1);
        System.out.println("author2 = " + author2);
        DAS table2 = (DAS)table.clone();
        System.out.println("\nCloned table:");
        table2.print(System.out);
        at = new AttributeTable();
        table.addAttributeTable("empty", at);
        if (table2.getAttributeTable("empty") != null) {
            System.out.println("DAS clone failed");
        } else {
            System.out.println("DAS clone passed");
        }
    }

    private static void test_dds() {
        System.out.println("DDS test:");
        DataDDS table = new DataDDS(new ServerVersion(2, 16));
        table.setName("test_table");
        DUInt32 myUInt = new DUInt32("myUInt");
        myUInt.setValue(42);
        table.addVariable(myUInt);
        DArray myArray = new DArray();
        myArray.addVariable(new DByte("myArray"));
        myArray.appendDim(10, "dummy");
        myArray.setLength(10);
        BytePrimitiveVector bpv = (BytePrimitiveVector)myArray.getPrimitiveVector();
        int i = 0;
        while (i < 10) {
            bpv.setValue(i, (byte)(i * 10));
            ++i;
        }
        table.addVariable(myArray);
        DList myList = new DList();
        myList.addVariable(new DURL("myList"));
        myList.setLength(10);
        BaseTypePrimitiveVector btpv = (BaseTypePrimitiveVector)myList.getPrimitiveVector();
        int i2 = 0;
        while (i2 < 10) {
            DURL testURL = new DURL();
            testURL.setValue("http://" + i2);
            btpv.setValue(i2, testURL);
            ++i2;
        }
        table.addVariable(myList);
        DStructure myStructure = new DStructure("myStructure");
        DFloat64 structFloat = new DFloat64("structFloat");
        structFloat.setValue(42.0);
        myStructure.addVariable(structFloat);
        DString structString = new DString("structString");
        structString.setValue("test value");
        myStructure.addVariable(structString);
        table.addVariable(myStructure);
        DGrid myGrid = new DGrid("myGrid");
        DArray gridArray = (DArray)myArray.clone();
        gridArray.setName("gridArray");
        myGrid.addVariable(gridArray, 1);
        DArray gridMap = new DArray();
        gridMap.addVariable(new DInt32("gridMap"));
        gridMap.appendDim(10, "dummy");
        gridMap.setLength(10);
        Int32PrimitiveVector ipv = (Int32PrimitiveVector)gridMap.getPrimitiveVector();
        int i3 = 0;
        while (i3 < 10) {
            ipv.setValue(i3, i3 * 10);
            ++i3;
        }
        myGrid.addVariable(gridMap, 2);
        table.addVariable(myGrid);
        DSequence mySequence = new DSequence("mySequence");
        mySequence.addVariable(new DInt32("seqInt32"));
        mySequence.addVariable(new DString("seqString"));
        Vector<BaseType> seqRow = new Vector<BaseType>();
        DInt32 seqVar1 = new DInt32("seqInt32");
        seqVar1.setValue(1);
        seqRow.addElement(seqVar1);
        DString seqVar2 = new DString("seqString");
        seqVar2.setValue("string");
        seqRow.addElement(seqVar2);
        mySequence.addRow(seqRow);
        seqRow = new Vector();
        seqVar1 = new DInt32("seqInt32");
        seqVar1.setValue(3);
        seqRow.addElement(seqVar1);
        seqVar2 = new DString("seqString");
        seqVar2.setValue("another string");
        seqRow.addElement(seqVar2);
        mySequence.addRow(seqRow);
        table.addVariable(mySequence);
        try {
            table.checkSemantics();
            System.out.println("DDS passed semantic check");
        }
        catch (BadSemanticsException e) {
            System.out.println("DDS failed semantic check:\n" + e);
        }
        try {
            table.checkSemantics(true);
            System.out.println("DDS passed full semantic check");
        }
        catch (BadSemanticsException e) {
            System.out.println("DDS failed full semantic check:\n" + e);
        }
        System.out.println("declarations:");
        table.print(System.out);
        System.out.println("\nData:");
        table.printVal(System.out);
        System.out.println();
        try {
            int testValue1 = ((DUInt32)table.getVariable("myUInt")).getValue();
            System.out.println("myUInt = " + testValue1);
            byte testValue2 = ((BytePrimitiveVector)((DArray)table.getVariable("myArray")).getPrimitiveVector()).getValue(5);
            System.out.println("myArray[5] = " + testValue2);
            String testValue3 = ((DString)((BaseTypePrimitiveVector)((DList)table.getVariable("myList")).getPrimitiveVector()).getValue(5)).getValue();
            System.out.println("myList[5] = " + testValue3);
            double testValue4 = ((DFloat64)((DStructure)table.getVariable("myStructure")).getVariable("structFloat")).getValue();
            System.out.println("myStructure.structFloat = " + testValue4);
            int testValue5 = ((Int32PrimitiveVector)((DArray)((DGrid)table.getVariable("myGrid")).getVariable("gridMap")).getPrimitiveVector()).getValue(5);
            System.out.println("myGrid.gridMap[5] = " + testValue5);
            String testValue7 = ((DString)((DSequence)table.getVariable("mySequence")).getVariable(0, "seqString")).getValue();
            System.out.println("mySequence[0].seqString = " + testValue7);
        }
        catch (NoSuchVariableException e) {
            System.out.println("Error getting variable:\n" + e);
        }
        System.out.println();
        DataDDS table2 = (DataDDS)table.clone();
        try {
            table2.checkSemantics();
            System.out.println("DDS passed semantic check");
        }
        catch (BadSemanticsException e) {
            System.out.println("DDS failed semantic check:\n" + e);
        }
        try {
            table2.checkSemantics(true);
            System.out.println("DDS passed full semantic check");
        }
        catch (BadSemanticsException e) {
            System.out.println("DDS failed full semantic check:\n" + e);
        }
        System.out.println("clone declarations:");
        table2.print(System.out);
        System.out.println("\nData:");
        table2.printVal(System.out);
        System.out.println();
        DInt32 myNewInt = new DInt32("myNewInt");
        myNewInt.setValue(420);
        table.addVariable(myNewInt);
        try {
            DInt32 testInt = (DInt32)table2.getVariable("myNewInt");
            System.out.println("Error: value from table in table2");
        }
        catch (NoSuchVariableException e) {
            System.out.println("Variable cloning looks good");
        }
    }
}

