/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class HeaderInputStream
extends FilterInputStream {
    private byte[] lineBuf;
    private int bytesRemaining = 0;
    private int currentOffset = 0;
    private byte[] endSequence = new byte[]{10, 68, 97, 116, 97, 58, 10};
    private boolean endFound = false;

    public HeaderInputStream(InputStream inputStream) {
        super(inputStream);
        this.lineBuf = new byte[4096];
    }

    public int available() {
        return this.bytesRemaining;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.bytesRemaining == 0 && !this.endFound) {
            this.getMoreBytes();
        }
        if (this.bytesRemaining == 0) {
            return -1;
        }
        --this.bytesRemaining;
        return this.lineBuf[this.currentOffset++];
    }

    private void getMoreBytes() throws IOException {
        this.currentOffset = 0;
        int n = 0;
        int n2 = 0;
        while (n < this.lineBuf.length) {
            int n3 = this.in.read();
            if (n3 == -1) break;
            this.lineBuf[n] = (byte)n3;
            if (this.lineBuf[n] == this.endSequence[n2]) {
                if (++n2 == this.endSequence.length) {
                    this.endFound = true;
                    break;
                }
            } else {
                n2 = this.lineBuf[n] == this.endSequence[0] ? 1 : 0;
            }
            ++n;
        }
        this.bytesRemaining = n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this.read();
        if (n3 == -1) {
            return -1;
        }
        byArray[n] = (byte)n3;
        int n4 = 1;
        try {
            while (n4 < n2) {
                n3 = this.read();
                if (n3 != -1) {
                    byArray[n + n4] = (byte)n3;
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        return n4;
    }

    public long skip(long l) {
        if ((long)this.bytesRemaining >= l) {
            this.bytesRemaining = (int)((long)this.bytesRemaining - l);
            return l;
        }
        int n = this.bytesRemaining;
        this.bytesRemaining = 0;
        return n;
    }
}

