/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.BaseTypeFactory;
import dods.dap.ClientIO;
import dods.dap.DDS;
import dods.dap.DODSException;
import dods.dap.DataReadException;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.zip.DeflaterOutputStream;

public class DataDDS
extends DDS {
    private ServerVersion ver;

    public DataDDS(ServerVersion serverVersion) {
        this.ver = serverVersion;
    }

    public DataDDS(ServerVersion serverVersion, BaseTypeFactory baseTypeFactory) {
        super(baseTypeFactory);
        this.ver = serverVersion;
    }

    public final ServerVersion getServerVersion() {
        return this.ver;
    }

    public void readData(InputStream inputStream, StatusUI statusUI) throws IOException, EOFException, DODSException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        Enumeration enumeration = this.getVariables();
        while (enumeration.hasMoreElements()) {
            if (statusUI != null && statusUI.userCancelled()) {
                throw new DataReadException("User cancelled");
            }
            ClientIO clientIO = (ClientIO)enumeration.nextElement();
            clientIO.deserialize(dataInputStream, this.ver, statusUI);
        }
        if (statusUI != null) {
            statusUI.finished();
        }
    }

    public void printVal(PrintWriter printWriter) {
        Enumeration enumeration = this.getVariables();
        while (enumeration.hasMoreElements()) {
            BaseType baseType = (BaseType)enumeration.nextElement();
            baseType.printVal(printWriter, "", true);
        }
        printWriter.println();
    }

    public final void printVal(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
        this.printVal(printWriter);
        printWriter.flush();
    }

    public final void externalize(OutputStream outputStream, boolean bl, boolean bl2) throws IOException {
        Closeable closeable;
        if (bl2) {
            closeable = new PrintWriter(new OutputStreamWriter(outputStream));
            ((PrintWriter)closeable).println("HTTP/1.0 200 OK");
            ((PrintWriter)closeable).println("Server: " + ServerVersion.getCurrentVersion());
            ((PrintWriter)closeable).println("Content-type: application/octet-stream");
            ((PrintWriter)closeable).println("Content-Description: dods_data");
            if (bl) {
                ((PrintWriter)closeable).println("Content-Encoding: deflate");
            }
            ((PrintWriter)closeable).println();
            ((PrintWriter)closeable).flush();
        }
        closeable = bl ? new DeflaterOutputStream(outputStream) : new BufferedOutputStream(outputStream);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)closeable));
        this.print(printWriter);
        printWriter.flush();
        ((OutputStream)closeable).write("\nData:\n".getBytes());
        ((OutputStream)closeable).flush();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)closeable);
        Enumeration enumeration = this.getVariables();
        while (enumeration.hasMoreElements()) {
            ClientIO clientIO = (ClientIO)enumeration.nextElement();
            clientIO.externalize(dataOutputStream);
        }
        dataOutputStream.close();
    }
}

