/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseTypeFactory;
import dods.dap.DAS;
import dods.dap.DASException;
import dods.dap.DDS;
import dods.dap.DDSException;
import dods.dap.DODSException;
import dods.dap.DataDDS;
import dods.dap.DefaultFactory;
import dods.dap.HeaderInputStream;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import dods.dap.parser.ParseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.InflaterInputStream;

public class DConnect {
    private boolean dumpStream = false;
    private boolean dumpDAS = false;
    private InputStream fileStream;
    private URLConnection connection;
    private String urlString;
    private String projString;
    private String selString;
    private boolean acceptDeflate;
    private ServerVersion ver;

    public DConnect(String string) throws FileNotFoundException {
        this(string, true);
    }

    public DConnect(String string, boolean bl) throws FileNotFoundException {
        Object object;
        int n = string.indexOf(63);
        if (n != -1) {
            this.urlString = string.substring(0, n);
            object = string.substring(n);
            int n2 = ((String)object).indexOf(38);
            if (n2 != -1) {
                this.projString = ((String)object).substring(0, n2);
                this.selString = ((String)object).substring(n2);
            } else {
                this.projString = object;
                this.selString = "";
            }
        } else {
            this.urlString = string;
            this.selString = "";
            this.projString = "";
        }
        this.acceptDeflate = bl;
        try {
            object = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.fileStream = new FileInputStream(string);
        }
    }

    public DConnect(InputStream inputStream) {
        this.fileStream = inputStream;
    }

    public final boolean isLocal() {
        return this.fileStream != null;
    }

    public final String CE() {
        return this.projString + this.selString;
    }

    public final String URL() {
        return this.urlString;
    }

    private InputStream openConnection(URL uRL) throws IOException, DODSException {
        this.connection = uRL.openConnection();
        if (this.acceptDeflate) {
            this.connection.setRequestProperty("Accept-Encoding", "deflate");
        }
        this.connection.connect();
        InputStream inputStream = null;
        int n = 1;
        long l = 100L;
        while (true) {
            try {
                inputStream = this.connection.getInputStream();
                break;
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("DConnect NullPointer; retry open (" + n + ") " + uRL);
                try {
                    Thread.currentThread();
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("DConnect FileNotFound; retry open (" + n + ") " + uRL);
                try {
                    Thread.currentThread();
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (n == 3) {
                throw new DODSException("Connection cannot be opened");
            }
            ++n;
            l *= 2L;
        }
        String string = this.connection.getHeaderField("content-description");
        this.handleContentDesc(inputStream, string);
        this.ver = new ServerVersion(this.connection.getHeaderField("xdods-server"));
        String string2 = this.connection.getContentEncoding();
        return this.handleContentEncoding(inputStream, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DAS getDAS() throws MalformedURLException, IOException, ParseException, DASException, DODSException {
        Object object;
        InputStream inputStream;
        if (this.fileStream != null) {
            inputStream = this.parseMime(this.fileStream);
        } else {
            object = new URL(this.urlString + ".das" + this.projString + this.selString);
            if (this.dumpDAS) {
                System.out.println("--DConnect.getDAS to " + object);
                this.copy(((URL)object).openStream(), System.out);
                System.out.println("\n--DConnect.getDAS END1");
                this.dumpBytes(((URL)object).openStream(), 100);
                System.out.println("\n-DConnect.getDAS END2");
            }
            inputStream = this.openConnection((URL)object);
        }
        object = new DAS();
        try {
            ((DAS)object).parse(inputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            inputStream.close();
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
            throw throwable;
        }
        inputStream.close();
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).disconnect();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DDS getDDS() throws MalformedURLException, IOException, ParseException, DDSException, DODSException {
        Object object;
        InputStream inputStream;
        if (this.fileStream != null) {
            inputStream = this.parseMime(this.fileStream);
        } else {
            object = new URL(this.urlString + ".dds" + this.projString + this.selString);
            inputStream = this.openConnection((URL)object);
        }
        object = new DDS();
        try {
            ((DDS)object).parse(inputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            inputStream.close();
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
            throw throwable;
        }
        inputStream.close();
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).disconnect();
        }
        return object;
    }

    public DataDDS getData(String string, StatusUI statusUI, BaseTypeFactory baseTypeFactory) throws MalformedURLException, IOException, ParseException, DDSException, DODSException {
        String string2;
        String string3;
        if (this.fileStream != null) {
            return this.getDataFromFileStream(this.fileStream, statusUI, baseTypeFactory);
        }
        int n = string.indexOf(38);
        if (n != -1) {
            string3 = string.substring(0, n);
            string2 = string.substring(n);
        } else {
            string3 = string;
            string2 = "";
        }
        URL uRL = new URL(this.urlString + ".dods" + this.projString + string3 + this.selString + string2);
        String string4 = "DConnect getData failed " + uRL;
        int n2 = 0;
        int n3 = 1;
        long l = 100L;
        while (true) {
            try {
                return this.getDataFromUrl(uRL, statusUI, baseTypeFactory);
            }
            catch (DODSException dODSException) {
                System.out.println("DConnect getData failed; retry (" + n3 + "," + l + ") " + uRL);
                string4 = dODSException.getErrorMessage();
                n2 = dODSException.getErrorCode();
                try {
                    Thread.currentThread();
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n3 == 5) {
                    throw new DODSException(n2, string4);
                }
                ++n3;
                l *= 2L;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataDDS getDataFromFileStream(InputStream inputStream, StatusUI statusUI, BaseTypeFactory baseTypeFactory) throws IOException, ParseException, DDSException, DODSException {
        InputStream inputStream2 = this.parseMime(inputStream);
        DataDDS dataDDS = new DataDDS(this.ver, baseTypeFactory);
        try {
            dataDDS.parse(new HeaderInputStream(inputStream2));
            dataDDS.readData(inputStream2, statusUI);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            inputStream2.close();
            throw throwable;
        }
        inputStream2.close();
        return dataDDS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataDDS getDataFromUrl(URL uRL, StatusUI statusUI, BaseTypeFactory baseTypeFactory) throws MalformedURLException, IOException, ParseException, DDSException, DODSException {
        InputStream inputStream = this.openConnection(uRL);
        DataDDS dataDDS = new DataDDS(this.ver, baseTypeFactory);
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.dumpStream) {
            System.out.println("DConnect to " + uRL);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.copy(inputStream, byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            inputStream = byteArrayInputStream;
        }
        try {
            try {
                if (this.dumpStream) {
                    byteArrayInputStream.mark(1000);
                    System.out.println("DConnect parse header: ");
                    this.dump(byteArrayInputStream);
                    byteArrayInputStream.reset();
                }
                dataDDS.parse(new HeaderInputStream(inputStream));
                if (this.dumpStream) {
                    byteArrayInputStream.mark(20);
                    System.out.println("DConnect done with header, next bytes are: ");
                    this.dumpBytes(byteArrayInputStream, 20);
                    byteArrayInputStream.reset();
                }
                dataDDS.readData(inputStream, statusUI);
            }
            catch (Exception exception) {
                System.out.println("DConnect dds.parse: " + uRL + "\n " + exception);
                exception.printStackTrace();
                throw new DODSException("Connection cannot be read " + uRL);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            inputStream.close();
            if (!(this.connection instanceof HttpURLConnection)) throw throwable;
            ((HttpURLConnection)this.connection).disconnect();
            throw throwable;
        }
        inputStream.close();
        if (!(this.connection instanceof HttpURLConnection)) return dataDDS;
        ((HttpURLConnection)this.connection).disconnect();
        return dataDDS;
    }

    private void copy(InputStream inputStream, OutputStream outputStream) {
        try {
            int n;
            byte[] byArray = new byte[256];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
        }
    }

    private void dump(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            String string;
            System.out.println("dump lines avail=" + inputStream.available());
            do {
                string = dataInputStream.readLine();
                System.out.println(string);
                if (null != string) continue;
                return;
            } while (!string.equals("Data:"));
            System.out.println("dump bytes avail=" + inputStream.available());
            this.dumpBytes(inputStream, 20);
        }
        catch (EOFException eOFException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpBytes(InputStream inputStream, int n) {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n2 = 0;
            while (n2 < n) {
                if (dataInputStream.available() <= 0) {
                    return;
                }
                System.out.println(n2 + " " + dataInputStream.readByte());
                ++n2;
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public DataDDS getData(String string, StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DODSException {
        return this.getData(string, statusUI, new DefaultFactory());
    }

    public final DataDDS getData(StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DODSException {
        return this.getData("", statusUI, new DefaultFactory());
    }

    public final ServerVersion getServerVersion() {
        return this.ver;
    }

    private InputStream parseMime(InputStream inputStream) throws IOException, DODSException {
        String string;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string2 = null;
        String string3 = null;
        while (!(string = dataInputStream.readLine()).equals("")) {
            int n = string.indexOf(32);
            if (n == -1) continue;
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + 1);
            if (string4.equals("Server:")) {
                this.ver = new ServerVersion(string5);
                continue;
            }
            if (string4.equals("Content-Description:")) {
                string2 = string5;
                continue;
            }
            if (!string4.equals("Content-Encoding:")) continue;
            string3 = string5;
        }
        this.handleContentDesc(inputStream, string2);
        return this.handleContentEncoding(inputStream, string3);
    }

    private void handleContentDesc(InputStream inputStream, String string) throws IOException, DODSException {
        if (string != null && string.equals("dods_error")) {
            DODSException dODSException = new DODSException();
            dODSException.parse(inputStream);
            throw dODSException;
        }
    }

    private InputStream handleContentEncoding(InputStream inputStream, String string) {
        if (string != null && string.equals("deflate")) {
            return new InflaterInputStream(inputStream);
        }
        return inputStream;
    }
}

