/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs.ui;

import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;
import ucar.util.prefs.ui.ComboBox;
import ucar.util.prefs.ui.PersistenceManager;
import ucar.util.prefs.ui.PrefPanel;

public abstract class Field {
    protected String name;
    protected PersistenceManager storeData;
    protected EventListenerList listenerList = null;
    protected String label;
    protected Object acceptedValue;
    protected Object oldValue;
    protected boolean showFormat = true;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    protected Field(String name, String label, PersistenceManager storeData) {
        this.name = name;
        this.label = label;
        this.storeData = storeData;
        if (storeData != null) {
            storeData.addPreferenceChangeListener(new PreferenceChangeListener(){

                public void preferenceChange(PreferenceChangeEvent evt) {
                    if (evt.getKey().equals(Field.this.getName())) {
                        Field.this.setNewValueFromStore();
                    }
                }
            });
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public PersistenceManager getPersistenceManager() {
        return this.storeData;
    }

    public void setPersistenceManager(PersistenceManager storeData) {
        this.storeData = storeData;
    }

    public boolean isEnabled() {
        return this.getEditComponent().isEnabled();
    }

    public void setEnabled(boolean enable) {
        this.getEditComponent().setEnabled(enable);
    }

    public boolean isEditable() {
        return this.isEnabled();
    }

    public void setEditable(boolean editable) {
        this.setEnabled(editable);
    }

    public void setToolTipText(String tip) {
        this.getEditComponent().setToolTipText(tip);
    }

    public String getToolTipText() {
        return this.getEditComponent().getToolTipText();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Field.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.listenerList.remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Field.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, pcl);
    }

    public abstract JComponent getEditComponent();

    protected abstract boolean validate(StringBuffer var1);

    protected abstract Object getEditValue();

    protected abstract void setEditValue(Object var1);

    protected abstract Object getStoreValue(Object var1);

    protected abstract void setStoreValue(Object var1);

    protected Object getValue() {
        return this.acceptedValue;
    }

    protected boolean accept(StringBuffer buff) {
        if (!this.validate(buff)) {
            return false;
        }
        if (this.acceptIfDifferent(this.getEditValue())) {
            this.setStoreValue(this.acceptedValue);
            this.sendEvent();
        }
        return true;
    }

    protected boolean acceptIfDifferent(Object newValue) {
        if (newValue == null) {
            return false;
        }
        if (this.acceptedValue != null && this.acceptedValue.equals(newValue)) {
            return false;
        }
        this.oldValue = this.getValue();
        this.acceptedValue = newValue;
        return true;
    }

    protected boolean checkIfValid(StringBuffer buff) {
        if (buff == null) {
            buff = new StringBuffer();
        }
        if (!this.validate(buff)) {
            try {
                JOptionPane.showMessageDialog(PrefPanel.findActiveFrame(), buff.toString());
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    protected void restoreValue(Object defValue) {
        if (this.storeData != null) {
            this.acceptedValue = this.getStoreValue(defValue);
            this.setEditValue(this.acceptedValue);
        }
    }

    protected void setNewValueFromStore() {
        Object newValue = this.getStoreValue(this.acceptedValue);
        if (this.acceptIfDifferent(newValue)) {
            this.setEditValue(newValue);
            this.sendEvent();
        }
    }

    protected void sendEvent() {
        if (this.listenerList != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, this.name, this.oldValue, this.getValue());
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
            }
        }
    }

    protected void next() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.getEditComponent());
    }

    private static void showFormatInfo(JFormattedTextField tf) {
        JFormattedTextField.AbstractFormatter ff = tf.getFormatter();
        System.out.println("AbstractFormatter  " + ff.getClass().getName());
        if (ff instanceof NumberFormatter) {
            NumberFormatter nf = (NumberFormatter)ff;
            Format f = nf.getFormat();
            System.out.println(" Format  = " + f.getClass().getName());
            if (f instanceof NumberFormat) {
                NumberFormat nfat = (NumberFormat)f;
                System.out.println(" getMinimumIntegerDigits=" + nfat.getMinimumIntegerDigits());
                System.out.println(" getMaximumIntegerDigits=" + nfat.getMaximumIntegerDigits());
                System.out.println(" getMinimumFractionDigits=" + nfat.getMinimumFractionDigits());
                System.out.println(" getMaximumFractionDigits=" + nfat.getMaximumFractionDigits());
            }
            if (f instanceof DecimalFormat) {
                DecimalFormat df = (DecimalFormat)f;
                System.out.println(" Pattern  = " + df.toPattern());
            }
        }
    }

    public static String dfrac(double d, int fixed_decimals) {
        return Field.formatDouble(d, 100, fixed_decimals).trim();
    }

    private static String formatDouble(double d, int min_sigFigs, int fixed_decimals) {
        StringBuffer fraction;
        StringBuffer number;
        String exponent;
        String mantissa;
        String unsigned;
        String sign;
        String s = java.lang.Double.toString(d);
        if (s.startsWith("-") || s.startsWith("+")) {
            sign = s.substring(0, 1);
            unsigned = s.substring(1);
        } else {
            sign = "";
            unsigned = s;
        }
        int eInd = unsigned.indexOf(69);
        if (eInd == -1) {
            eInd = unsigned.indexOf(101);
        }
        if (eInd == -1) {
            mantissa = unsigned;
            exponent = "";
        } else {
            mantissa = unsigned.substring(0, eInd);
            exponent = unsigned.substring(eInd);
        }
        int dotInd = mantissa.indexOf(46);
        if (dotInd == -1) {
            number = new StringBuffer(mantissa);
            fraction = new StringBuffer("");
        } else {
            number = new StringBuffer(mantissa.substring(0, dotInd));
            fraction = new StringBuffer(mantissa.substring(dotInd + 1));
        }
        int numFigs = number.length();
        int fracFigs = fraction.length();
        if (fixed_decimals != -1) {
            if (fixed_decimals == 0) {
                fraction.setLength(0);
            } else if (fixed_decimals > fracFigs) {
                int want = fixed_decimals - fracFigs;
                for (int i = 0; i < want; ++i) {
                    fraction.append("0");
                }
            } else if (fixed_decimals < fracFigs) {
                int chop = fracFigs - fixed_decimals;
                fraction.setLength(fraction.length() - chop);
            }
            fracFigs = fixed_decimals;
        } else {
            int sigFigs;
            int i;
            if ((numFigs == 0 || number.toString().equals("0")) && fracFigs > 0) {
                numFigs = 0;
                number = new StringBuffer("");
                for (i = 0; i < fraction.length() && fraction.charAt(i) == '0'; ++i) {
                    --fracFigs;
                }
            }
            if (fracFigs == 0 && numFigs > 0) {
                for (i = number.length() - 1; i > 0 && number.charAt(i) == '0'; --i) {
                    --numFigs;
                }
            }
            if ((sigFigs = numFigs + fracFigs) > min_sigFigs) {
                int chop = Math.min(sigFigs - min_sigFigs, fracFigs);
                fraction.setLength(fraction.length() - chop);
                fracFigs -= chop;
            }
        }
        if (fraction.length() == 0) {
            return sign + number + exponent;
        }
        return sign + number + "." + fraction + exponent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class BeanTable
    extends Field {
        protected BeanTableSorted table;

        public BeanTable(String fldName, String label, ArrayList defBeans, Class beanClass, PreferencesExt prefs, PersistenceManager storeData) {
            super(fldName, label, storeData);
            this.table = new BeanTableSorted(beanClass, prefs, true);
            this.setEditValue(this.getStoreValue(defBeans));
        }

        protected boolean validate(StringBuffer buff) {
            return true;
        }

        public JComponent getEditComponent() {
            return this.table;
        }

        protected Object getEditValue() {
            return this.table.getBeans();
        }

        protected void setEditValue(Object value) {
            this.table.setBeans((ArrayList)value);
        }

        protected Object getStoreValue(Object defValue) {
            return this.storeData.getList(this.name, (List)defValue);
        }

        protected void setStoreValue(Object newValue) {
            this.storeData.putList(this.name, (List)newValue);
        }
    }

    public static class EnumCombo
    extends Field {
        protected ComboBox combo = new ComboBox(null, 0);
        private boolean debugCombo = false;

        public EnumCombo(String fldName, String label, Collection choices, PersistenceManager storeData) {
            super(fldName, label, storeData);
            this.combo.setItemList(choices);
            this.setEditValue(this.getStoreValue(null));
        }

        protected boolean validate(StringBuffer buff) {
            return true;
        }

        public JComponent getEditComponent() {
            return this.combo;
        }

        protected Object getEditValue() {
            return this.combo.getSelectedItem();
        }

        protected void setEditValue(Object value) {
            if (value == null) {
                return;
            }
            this.combo.setSelectedItem(value);
        }

        protected Object getStoreValue(Object defValue) {
            Object val = null;
            if (this.storeData != null) {
                val = this.storeData.getObject(this.name);
            }
            return val == null ? defValue : val;
        }

        protected void setStoreValue(Object newValue) {
            if (this.storeData != null) {
                this.storeData.putObject(this.name, newValue);
            }
        }

        public void setValue(Object value) {
            this.combo.addItem(value);
            this.accept(null);
        }

        public Object getValue() {
            return super.getValue();
        }

        public boolean isEditable() {
            return this.combo.isEditable();
        }

        public void setEditable(boolean isEditable) {
            this.combo.setEditable(isEditable);
        }
    }

    public static class TextCombo
    extends Field {
        protected ComboBox combo;
        private boolean eventsOK = true;
        private int nKeep;
        private boolean debugCombo = false;

        public TextCombo(String fldName, String label, Collection defValues, int n, PersistenceManager storeData) {
            super(fldName, label, storeData);
            this.nKeep = n;
            this.combo = new ComboBox(storeData);
            ArrayList prevChoices = this.combo.getItemList();
            if (defValues != null) {
                Iterator iter = defValues.iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    if (prevChoices.contains(o)) continue;
                    prevChoices.add(o);
                }
                this.combo.setItemList(prevChoices);
            }
            if (this.combo.getItemCount() > 0) {
                this.combo.setSelectedIndex(0);
                this.acceptedValue = this.combo.getItemAt(0);
            }
        }

        protected boolean validate(StringBuffer buff) {
            return true;
        }

        public JComponent getEditComponent() {
            return this.combo;
        }

        protected Object getEditValue() {
            return this.combo.getItemList();
        }

        protected void setEditValue(Object value) {
            if (value == null) {
                return;
            }
            this.eventsOK = false;
            this.combo.setItemList((List)value);
            this.eventsOK = true;
        }

        protected Object getStoreValue(Object defValue) {
            return this.combo.getStoreValue(defValue);
        }

        protected void setStoreValue(Object newValue) {
            this.combo.setStoreValue((List)newValue);
        }

        protected boolean accept() {
            this.eventsOK = false;
            Object newValue = this.combo.getSelectedItem();
            this.combo.addItem(newValue);
            if (this.acceptIfDifferent(this.getEditValue())) {
                this.setEditValue(this.acceptedValue);
                this.setStoreValue(this.acceptedValue);
                this.sendEvent();
            }
            this.eventsOK = true;
            return true;
        }

        public String getText() {
            Object current = this.combo.getSelectedItem();
            return current.toString();
        }

        public void setText(String newValue) {
            newValue = newValue.trim();
            this.combo.addItem(newValue);
            this.accept(null);
        }

        public void setValue(Object value) {
            this.combo.addItem(value);
            this.accept(null);
        }

        public boolean isEditable() {
            return this.combo.isEditable();
        }

        public void setEditable(boolean isEditable) {
            this.combo.setEditable(isEditable);
        }
    }

    public static class CheckBox
    extends Field {
        private JCheckBox checkbox;

        public CheckBox(String fldName, String label, boolean defValue, PersistenceManager storeData) {
            super(fldName, label, storeData);
            this.acceptedValue = this.getStoreValue(new Boolean(defValue));
            this.checkbox = new JCheckBox();
            this.checkbox.setSelected(this.isSelected());
        }

        protected boolean validate(StringBuffer buff) {
            return true;
        }

        public JComponent getEditComponent() {
            return this.checkbox;
        }

        protected Object getEditValue() {
            return new Boolean(this.checkbox.isSelected());
        }

        protected void setEditValue(Object value) {
            boolean bv = (Boolean)value;
            this.checkbox.setSelected(bv);
        }

        protected void setStoreValue(Object value) {
            if (this.storeData != null) {
                this.storeData.putBoolean(this.name, (Boolean)value);
            }
        }

        protected Object getStoreValue(Object defValue) {
            if (this.storeData == null) {
                return defValue;
            }
            boolean def = defValue == null ? false : (Boolean)defValue;
            boolean bv = this.storeData.getBoolean(this.name, def);
            return new Boolean(bv);
        }

        public boolean isSelected() {
            return (Boolean)this.acceptedValue;
        }

        public void setSelected(boolean v) {
            this.setEditValue(new Boolean(v));
            this.accept(null);
        }
    }

    public static class Date
    extends Field {
        protected JFormattedTextField tf = new JFormattedTextField();

        public Date(String name, String label, java.util.Date defValue, PersistenceManager storeData) {
            super(name, label, storeData);
            this.acceptedValue = this.getStoreValue(defValue);
            if (null == this.acceptedValue) {
                this.acceptedValue = new java.util.Date();
            }
            this.tf.setValue(this.acceptedValue);
            this.tf.addActionListener(new ActionListener(this){
                private final /* synthetic */ Date this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.this$0.checkIfValid(null)) {
                        this.this$0.next();
                    }
                }
            });
            try {
                JFormattedTextField.AbstractFormatter format = this.tf.getFormatter();
                this.setToolTipText("eg " + format.valueToString(new java.util.Date(234098876L)));
            }
            catch (ParseException e) {
                // empty catch block
            }
        }

        public JComponent getEditComponent() {
            return this.tf;
        }

        protected boolean validate(StringBuffer buff) {
            try {
                this.tf.commitEdit();
            }
            catch (ParseException e) {
                buff.append(this.label + " has invalid format: should be a date\n");
                return false;
            }
            return true;
        }

        protected Object getEditValue() {
            return this.tf.getValue();
        }

        protected void setEditValue(Object value) {
            this.tf.setValue(value);
        }

        public boolean isEditable() {
            return this.tf.isEditable();
        }

        public void setEditable(boolean isEditable) {
            this.tf.setEditable(isEditable);
        }

        protected void setStoreValue(Object value) {
            if (this.storeData != null) {
                this.storeData.putObject(this.name, value);
            }
        }

        protected Object getStoreValue(Object defValue) {
            if (this.storeData == null) {
                return defValue;
            }
            Object value = this.storeData.getObject(this.name);
            return value == null ? defValue : value;
        }

        public java.util.Date getDate() {
            return (java.util.Date)this.acceptedValue;
        }

        public void setDate(java.util.Date newValue) {
            this.setEditValue(newValue);
            this.accept(null);
        }
    }

    public static class Int
    extends Field {
        private JTextField tf;

        public Int(String name, String label, int defValue, PersistenceManager storeData) {
            super(name, label, storeData);
            this.acceptedValue = this.getStoreValue(new Integer(defValue));
            this.tf = new JTextField();
            this.setEditValue(this.acceptedValue);
            this.tf.addActionListener(new ActionListener(this){
                private final /* synthetic */ Int this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.this$0.checkIfValid(null)) {
                        this.this$0.next();
                    }
                }
            });
            this.tf.setHorizontalAlignment(4);
        }

        protected boolean validate(StringBuffer buff) {
            try {
                Integer.parseInt(this.tf.getText());
            }
            catch (NumberFormatException e) {
                buff.append(this.label + " has invalid format: must be an integer number\n");
                return false;
            }
            return true;
        }

        public JComponent getEditComponent() {
            return this.tf;
        }

        protected Object getEditValue() {
            try {
                return new Integer(this.tf.getText());
            }
            catch (NumberFormatException e) {
                return new java.lang.Double(0.0);
            }
        }

        protected void setEditValue(Object value) {
            this.tf.setText(((Integer)value).toString());
        }

        protected void setStoreValue(Object value) {
            if (this.storeData != null) {
                this.storeData.putInt(this.name, (Integer)value);
            }
        }

        protected Object getStoreValue(Object defValue) {
            int def;
            int value;
            if (this.storeData != null && (value = this.storeData.getInt(this.name, def = Integer.MAX_VALUE)) != def) {
                return new Integer(value);
            }
            return defValue;
        }

        public int getInt() {
            return (Integer)this.getValue();
        }

        public void setInt(int value) {
            this.setEditValue(new Integer(value));
            this.accept(null);
        }
    }

    public static class Double
    extends Field {
        private JTextField tf;
        private int nfracDig = 3;

        public Double(String name, String label, double defValue, int nfracDig, PersistenceManager storeData) {
            super(name, label, storeData);
            if (nfracDig >= 0) {
                this.nfracDig = nfracDig;
            }
            this.acceptedValue = this.getStoreValue(new java.lang.Double(defValue));
            this.tf = new JTextField();
            this.setEditValue(this.acceptedValue);
            this.tf.addActionListener(new ActionListener(this){
                private final /* synthetic */ Double this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.this$0.checkIfValid(null)) {
                        this.this$0.next();
                    }
                }
            });
            this.tf.setHorizontalAlignment(4);
        }

        protected boolean validate(StringBuffer buff) {
            try {
                new java.lang.Double(this.tf.getText());
            }
            catch (NumberFormatException e) {
                buff.append(this.label + " has invalid format: must be floating point number\n");
                return false;
            }
            return true;
        }

        public JComponent getEditComponent() {
            return this.tf;
        }

        protected Object getEditValue() {
            try {
                return new java.lang.Double(this.tf.getText());
            }
            catch (NumberFormatException e) {
                return new java.lang.Double(0.0);
            }
        }

        protected void setEditValue(Object value) {
            double dv = (java.lang.Double)value;
            this.tf.setText(Double.dfrac(dv, this.nfracDig));
        }

        protected void setStoreValue(Object value) {
            if (this.storeData != null) {
                this.storeData.putDouble(this.name, (java.lang.Double)value);
            }
        }

        protected Object getStoreValue(Object defValue) {
            double def;
            double value;
            if (this.storeData != null && (value = this.storeData.getDouble(this.name, def = java.lang.Double.NaN)) != def) {
                return new java.lang.Double(value);
            }
            return defValue;
        }

        public double getDouble() {
            return (java.lang.Double)this.getValue();
        }

        public void setDouble(double value) {
            this.setEditValue(new java.lang.Double(value));
            this.accept(null);
        }
    }

    public static class Password
    extends Text {
        public Password(String name, String label, String defValue, PersistenceManager storeData) {
            super(name, label, storeData);
            this.acceptedValue = this.getStoreValue(defValue);
            this.tf = new JPasswordField((String)this.acceptedValue);
        }

        public char[] getPassword() {
            return ((JPasswordField)this.tf).getPassword();
        }
    }

    public static class TextArea
    extends Text {
        public TextArea(String name, String label, String defValue, int nrows, PersistenceManager storeData) {
            super(name, label, storeData);
            this.acceptedValue = this.getStoreValue(defValue);
            JTextArea ta = new JTextArea((String)this.acceptedValue);
            ta.setLineWrap(true);
            ta.setWrapStyleWord(true);
            ta.setRows(nrows);
            this.tf = ta;
        }
    }

    public static class Text
    extends Field {
        protected JTextComponent tf;

        protected Text(String name, String label, PersistenceManager storeData) {
            super(name, label, storeData);
        }

        public Text(String name, String label, String defValue, PersistenceManager storeData) {
            super(name, label, storeData);
            this.acceptedValue = this.getStoreValue(defValue);
            this.tf = new JTextField((String)this.acceptedValue);
        }

        public JComponent getEditComponent() {
            return this.tf;
        }

        protected boolean validate(StringBuffer buff) {
            return true;
        }

        protected Object getEditValue() {
            return this.normalize(this.tf.getText());
        }

        protected void setEditValue(Object value) {
            this.tf.setText((String)value);
        }

        public boolean isEditable() {
            return this.tf.isEditable();
        }

        public void setEditable(boolean isEditable) {
            this.tf.setEditable(isEditable);
        }

        protected void setStoreValue(Object value) {
            if (this.storeData != null) {
                this.storeData.put(this.name, (String)value);
            }
        }

        protected Object getStoreValue(Object defValue) {
            if (this.storeData != null) {
                return this.storeData.get(this.name, (String)defValue);
            }
            return defValue;
        }

        public String getText() {
            return this.normalize((String)this.acceptedValue);
        }

        public void setText(String newValue) {
            this.setEditValue(this.normalize(newValue));
            this.accept(null);
        }

        protected String normalize(String s) {
            String trimValue = s.trim();
            return trimValue.length() > 0 ? trimValue : s;
        }
    }
}

