/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.PersistenceManager;

public class ComboBox
extends JComboBox {
    private static final String LIST = "ComboBoxList";
    private PersistenceManager prefs;
    private int nkeep = 20;
    private static long lastEvent;

    public ComboBox(PersistenceManager prefs) {
        this(prefs, 20);
    }

    public ComboBox(PersistenceManager prefs, int nkeep) {
        this.prefs = prefs;
        this.nkeep = nkeep;
        this.setEditable(true);
        if (prefs != null) {
            ArrayList list = (ArrayList)prefs.getList(LIST, null);
            this.setItemList(list);
        }
    }

    public void addItem(Object item) {
        if (item == null) {
            return;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!item.equals(this.getItemAt(i))) continue;
            if (i == 0) {
                return;
            }
            this.removeItemAt(i);
        }
        this.insertItemAt(item, 0);
        this.setSelectedIndex(0);
    }

    public void save() {
        if (this.prefs != null) {
            this.prefs.putList(LIST, this.getItemList());
        }
    }

    public ArrayList getItemList() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.getItemCount() && i < this.nkeep; ++i) {
            list.add(this.getItemAt(i));
        }
        return list;
    }

    public void setItemList(Collection list) {
        if (list == null) {
            return;
        }
        this.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        if (list.size() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void setNkeep(int nkeep) {
        this.nkeep = nkeep;
    }

    public int getNkeep() {
        return this.nkeep;
    }

    protected Object getStoreValue(Object defValue) {
        if (this.prefs == null) {
            return defValue;
        }
        return ((PreferencesExt)this.prefs).getBean(LIST, defValue);
    }

    protected void setStoreValue(List newValue) {
        if (this.prefs != null) {
            this.prefs.putList(LIST, newValue);
        }
    }

    public static void main(String[] args) throws IOException {
        JFrame frame = new JFrame("Test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        final ComboBox cb = new ComboBox(null);
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("**** cb event=" + e);
                if (e.getWhen() != lastEvent) {
                    System.out.println("CALL = " + cb.getSelectedItem());
                }
                cb.addItem(cb.getSelectedItem());
                lastEvent = e.getWhen();
            }
        });
        JButton butt = new JButton("accept");
        butt.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("butt accept");
            }
        });
        JPanel main = new JPanel();
        main.add(cb);
        main.add(butt);
        frame.getContentPane().add(main);
        frame.pack();
        frame.setLocation(300, 300);
        frame.setVisible(true);
    }
}

