/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;

public class BeanTable
extends JPanel {
    protected Class beanClass;
    protected PreferencesExt store;
    protected JTable jtable;
    protected JScrollPane scrollPane;
    protected EventListenerList listenerList = new EventListenerList();
    protected ArrayList beans;
    protected TableBeanModel model;
    protected boolean debug = false;
    protected boolean debugStore = false;
    protected boolean debugBean = false;
    protected boolean debugSelected = false;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$ucar$util$prefs$ui$BeanTable$TestBean;

    public BeanTable(Class bc, PreferencesExt pstore, boolean canAddDelete) {
        this.beanClass = bc;
        this.store = pstore;
        this.beans = (ArrayList)this.store.getBean("beanList", new ArrayList());
        this.model = new TableBeanModel(this.beanClass);
        this.jtable = new JTable(this.model);
        this.jtable.setAutoResizeMode(1);
        this.jtable.setDefaultRenderer(class$java$util$Date == null ? (class$java$util$Date = BeanTable.class$("java.util.Date")) : class$java$util$Date, new DateRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.jtable);
        this.restoreState();
        TableColumnModel tcm = this.jtable.getColumnModel();
        for (int i = 0; i < this.jtable.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            int model_idx = tc.getModelIndex();
            tc.setHeaderRenderer(new HeaderRenderer(model_idx));
        }
        this.jtable.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = BeanTable.class$("java.lang.String")) : class$java$lang$String, new DefaultCellEditor(new JTextField()));
        this.jtable.setDefaultEditor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanTable.class$("java.lang.Boolean")) : class$java$lang$Boolean, new DefaultCellEditor(new JCheckBox()));
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.jtable);
        this.add((Component)this.scrollPane, "Center");
        if (canAddDelete) {
            JPanel buttPanel = new JPanel();
            JButton newButton = new JButton("New");
            buttPanel.add((Component)newButton, null);
            JButton deleteButton = new JButton("Delete");
            buttPanel.add((Component)deleteButton, null);
            this.add((Component)buttPanel, "South");
            newButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        Object bean = BeanTable.this.beanClass.newInstance();
                        BeanTable.this.addBean(bean);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (JOptionPane.showConfirmDialog(null, "Do you want to delete all selected records", "Delete Records", 0) != 0) {
                        return;
                    }
                    Iterator iter = BeanTable.this.getSelectedBeans().iterator();
                    while (iter.hasNext()) {
                        BeanTable.this.beans.remove(iter.next());
                    }
                    BeanTable.this.model.fireTableDataChanged();
                }
            });
        }
        this.listenerList = new EventListenerList();
        ListSelectionModel rowSM = this.jtable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    BeanTable.this.fireEvent(e);
                }
            }
        });
    }

    public String getToolTipText(MouseEvent event) {
        String text = super.getToolTipText(event);
        System.out.println("BeanTable tooltip " + text);
        return text;
    }

    public void setProperty(String propertyName, String displayName, String toolTipText) {
        this.model.setProperty(propertyName, displayName, toolTipText);
    }

    public void setPropertyEditable(String propertyName, boolean isHidden) {
    }

    public void setPropertyHidden(String propertyName, boolean isHidden) {
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.listenerList.add(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = BeanTable.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listenerList.remove(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = BeanTable.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, l);
    }

    private void fireEvent(ListSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ListSelectionListener)listeners[i + 1]).valueChanged(event);
        }
    }

    protected int modelIndex(int viewIndex) {
        return viewIndex;
    }

    protected int viewIndex(int rowIndex) {
        return rowIndex;
    }

    public Object getSelectedBean() {
        int r = this.jtable.getSelectedRow();
        return (r = this.modelIndex(r)) < 0 || r >= this.beans.size() ? null : this.beans.get(r);
    }

    public ArrayList getSelectedBeans() {
        ArrayList list = new ArrayList();
        int[] r = this.jtable.getSelectedRows();
        for (int i = 0; i < r.length; ++i) {
            int mr = this.modelIndex(r[i]);
            list.add(this.beans.get(mr));
            if (!this.debugSelected) continue;
            System.out.println(" bean selected= " + mr + " " + this.beans.get(mr));
        }
        return list;
    }

    public ArrayList getSelectedCells() {
        ArrayList<Object> list = new ArrayList<Object>();
        int[] r = this.jtable.getSelectedRows();
        int[] c = this.jtable.getSelectedColumns();
        for (int i = 0; i < r.length; ++i) {
            int j = 0;
            while (i < c.length) {
                int mr = this.modelIndex(r[i]);
                list.add(this.model.getValueAt(mr, c[j]));
                ++j;
            }
        }
        return list;
    }

    public void clearSelectedCells() {
        int[] r = this.jtable.getSelectedRows();
        int[] c = this.jtable.getSelectedColumns();
        TableColumnModel tcm = this.jtable.getColumnModel();
        for (int j = 0; j < c.length; ++j) {
            TableColumn tc = tcm.getColumn(c[j]);
            int colModelIdx = tc.getModelIndex();
            Class<?> colClass = this.jtable.getColumnClass(c[j]);
            Object zeroValue = this.model.zeroValue(colClass);
            for (int i = 0; i < r.length; ++i) {
                int mr = this.modelIndex(r[i]);
                this.model.setValueAt(zeroValue, mr, colModelIdx);
            }
        }
    }

    public void addBean(Object bean) {
        this.beans.add(bean);
        int row = this.beans.size() - 1;
        this.model.fireTableRowsInserted(row, row);
    }

    public void addBeans(ArrayList newBeans) {
        this.beans.addAll(newBeans);
        int row = this.beans.size() - 1;
        this.model.fireTableRowsInserted(row - newBeans.size(), row);
    }

    public void setBeans(ArrayList beans) {
        if (beans == null) {
            return;
        }
        this.beans = beans;
        this.model.fireTableDataChanged();
    }

    public ArrayList getBeans() {
        return this.beans;
    }

    public JTable getJTable() {
        return this.jtable;
    }

    public void setFontSize(int size) {
        this.jtable.setFont(this.jtable.getFont().deriveFont((float)size));
    }

    public void setSelectionMode(int mode) {
        this.jtable.setSelectionMode(mode);
    }

    public void setSelectedBean(Object bean) {
        if (bean == null) {
            return;
        }
        int row = this.beans.indexOf(bean);
        int vr = this.viewIndex(row);
        if (row >= 0) {
            this.jtable.getSelectionModel().setSelectionInterval(vr, vr);
        }
        this.makeRowVisible(row);
    }

    public void setSelectedBeans(List beans) {
        for (int i = 0; i < beans.size(); ++i) {
            Object bean = beans.get(i);
            int row = beans.indexOf(bean);
            int vr = this.viewIndex(row);
            if (row < 0) continue;
            this.jtable.getSelectionModel().setSelectionInterval(vr, vr);
        }
    }

    private void makeRowVisible(int modelRow) {
        int row = this.viewIndex(modelRow);
        Rectangle visibleRect = this.jtable.getCellRect(row, 0, true);
        if (this.debugSelected) {
            System.out.println("----ensureRowIsVisible = " + visibleRect);
        }
        if (visibleRect != null) {
            visibleRect.x = this.scrollPane.getViewport().getViewPosition().x;
            this.jtable.scrollRectToVisible(visibleRect);
            this.jtable.repaint();
        }
    }

    public void setColumnSelectionAllowed(boolean b) {
        this.jtable.setColumnSelectionAllowed(b);
    }

    public void saveState(boolean saveData) {
        if (this.store == null) {
            return;
        }
        try {
            if (saveData) {
                this.store.putBeanCollection("beanList", this.beans);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<PropertyCol> pcols = new ArrayList<PropertyCol>();
        TableColumnModel tcm = this.jtable.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            PropertyCol pcol = new PropertyCol();
            pcol.setName(this.model.getColumnName(tc.getModelIndex()));
            pcol.setWidth(tc.getWidth());
            pcol.setWidth(tc.getWidth());
            pcols.add(pcol);
        }
        this.store.putBeanCollection("propertyCol", pcols);
    }

    protected void restoreState() {
        if (this.store == null) {
            return;
        }
        ArrayList pcols = (ArrayList)this.store.getBean("propertyCol", new ArrayList());
        TableColumnModel tcm = this.jtable.getColumnModel();
        int count = 0;
        for (int i = 0; i < pcols.size(); ++i) {
            PropertyCol pcol = (PropertyCol)pcols.get(i);
            int idx = this.model.getPropertyIndex(pcol.getName());
            if (idx >= 0) {
                if (this.debugStore) {
                    System.out.println(count + "  has " + pcol.getName());
                }
                TableColumn tc = tcm.getColumn(count++);
                tc.setModelIndex(idx);
                tc.setPreferredWidth(pcol.getWidth());
                tc.setHeaderValue(pcol.getName());
                tc.setIdentifier(pcol.getName());
                continue;
            }
            if (!this.debugStore) continue;
            System.out.println(count + "  col deleted " + pcol.getName());
        }
        if (this.model.getColumnCount() > count) {
            for (int col = 0; col < this.model.getColumnCount(); ++col) {
                if (this.model.wasUsed(col)) continue;
                TableColumn tc = tcm.getColumn(count++);
                tc.setModelIndex(col);
                tc.setHeaderValue(this.model.getColumnName(col));
                tc.setIdentifier(this.model.getColumnName(col));
                if (!this.debugStore) continue;
                System.out.println(count + "  added " + this.model.getColumnName(col));
            }
        }
    }

    public static void main2(String[] args) {
        TestBean testBean = new TestBean();
        Class<?> beanClass = testBean.getClass();
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass, class$java$lang$Object == null ? (class$java$lang$Object = BeanTable.class$("java.lang.Object")) : class$java$lang$Object);
            System.out.println("Bean " + beanClass.getName());
            System.out.println("Properties:");
            PropertyDescriptor[] pd = info.getPropertyDescriptors();
            for (int i = 0; i < pd.length; ++i) {
                System.out.println(" " + pd[i].getName() + " " + pd[i].getPropertyType().getName());
                String propName = pd[i].getName();
                char first = Character.toUpperCase(propName.charAt(0));
                String method_name = "get" + first + propName.substring(1);
                System.out.println(" " + propName + " " + first + " " + method_name);
                try {
                    Method method = beanClass.getMethod(method_name, null);
                    System.out.println(" method = " + method);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        Date now = new Date();
        DateFormat formatter = DateFormat.getDateInstance();
        System.out.println("date : " + now + " // " + formatter.format(now));
        final XMLStore xstore = XMLStore.createFromFile("C:/dev/prefs/test/data/testBeanTable.xml", null);
        PreferencesExt store = xstore.getPreferences();
        final BeanTable bt = new BeanTable(class$ucar$util$prefs$ui$BeanTable$TestBean == null ? (class$ucar$util$prefs$ui$BeanTable$TestBean = BeanTable.class$("ucar.util.prefs.ui.BeanTable$TestBean")) : class$ucar$util$prefs$ui$BeanTable$TestBean, store, true);
        JFrame frame = new JFrame("Test BeanTable");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    bt.saveState(true);
                    xstore.save();
                    System.exit(0);
                }
                catch (IOException ee) {
                    ee.printStackTrace();
                }
            }
        });
        frame.getContentPane().add(bt);
        bt.setPreferredSize(new Dimension(500, 200));
        frame.pack();
        frame.setLocation(300, 300);
        frame.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class TestBean {
        private String name;
        private String path;
        private String sbase;
        private String dtype;
        private String stype;
        private String ddhref;
        private boolean u;
        private int i;
        private Date now = new Date();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPath() {
            return this.path;
        }

        void setPath(String path) {
            this.path = path;
        }

        String getServerBase() {
            return this.sbase;
        }

        void setServerBase(String sbase) {
            this.sbase = sbase;
        }

        String getDataType() {
            return this.dtype;
        }

        public void setDataType(String dtype) {
            this.dtype = dtype;
        }

        public String getServerType() {
            return this.stype;
        }

        public void setServerType(String stype) {
            this.stype = stype;
        }

        public String getDDref() {
            return this.ddhref;
        }

        public void setDDref(String ddhref) {
            this.ddhref = ddhref;
        }

        public boolean getUse() {
            return this.u;
        }

        public void setUse(boolean u) {
            this.u = u;
        }

        public int getII() {
            return this.i;
        }

        public void setII(int i) {
            this.i = i;
        }

        public Date getNow() {
            return this.now;
        }

        public void setNow(Date now) {
            this.now = now;
        }

        public static String editableProperties() {
            return "name path serverbase serverType DDref use II now";
        }
    }

    protected class HeaderRenderer
    implements TableCellRenderer {
        protected int modelIdx;
        protected JPanel compPanel;
        protected JLabel headerLabel;

        protected HeaderRenderer(int modelIdx) {
            this.modelIdx = modelIdx;
            PropertyDescriptor pd = BeanTable.this.model.getProperty(modelIdx);
            this.headerLabel = new JLabel(pd.getDisplayName());
            this.compPanel = new JPanel(new BorderLayout());
            this.compPanel.setBorder(new BevelBorder(0));
            this.compPanel.add((Component)this.headerLabel, "Center");
            this.compPanel.setToolTipText(pd.getShortDescription());
            ToolTipManager.sharedInstance().registerComponent(this.compPanel);
            pd.setValue("Header", this.headerLabel);
            pd.setValue("ToolTipComp", this.compPanel);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.compPanel;
        }
    }

    protected class TableBeanModel
    extends AbstractTableModel {
        private ArrayList properties = new ArrayList();
        private boolean[] used;
        private ArrayList editP = null;
        private ArrayList hiddenP = null;

        protected TableBeanModel(Class beanClass) {
            int i;
            BeanInfo info = null;
            try {
                info = !beanClass.isInterface() ? Introspector.getBeanInfo(beanClass, class$java$lang$Object == null ? (class$java$lang$Object = BeanTable.class$("java.lang.Object")) : class$java$lang$Object) : Introspector.getBeanInfo(beanClass);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            if (BeanTable.this.debugBean) {
                System.out.println("Bean " + beanClass.getName());
            }
            String editableProperties = "";
            MethodDescriptor[] mds = info.getMethodDescriptors();
            for (int i2 = 0; i2 < mds.length; ++i2) {
                Method m = mds[i2].getMethod();
                if (!m.getName().equals("editableProperties")) continue;
                try {
                    editableProperties = (String)m.invoke(null, null);
                    if (!BeanTable.this.debugBean) continue;
                    System.out.println(" editableProperties: " + editableProperties);
                    continue;
                }
                catch (Exception ee) {
                    System.out.println("BeanTable: Bad editableProperties ");
                    ee.printStackTrace();
                }
            }
            String hiddenProperties = "";
            for (int i3 = 0; i3 < mds.length; ++i3) {
                Method m = mds[i3].getMethod();
                if (!m.getName().equals("hiddenProperties")) continue;
                try {
                    hiddenProperties = (String)m.invoke(null, null);
                    if (!BeanTable.this.debugBean) continue;
                    System.out.println(" hiddenProperties: " + hiddenProperties);
                    continue;
                }
                catch (Exception ee) {
                    System.out.println("BeanTable: Bad hiddenProperties ");
                    ee.printStackTrace();
                }
            }
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            for (i = 0; i < pds.length; ++i) {
                if (pds[i].getReadMethod() == null || this.isHidden(pds[i], hiddenProperties)) continue;
                this.properties.add(pds[i]);
                this.setEditable(pds[i], editableProperties);
            }
            if (BeanTable.this.debugBean) {
                System.out.println("Properties:");
                System.out.println("  display name  type   read()       write()         editable");
                for (i = 0; i < pds.length; ++i) {
                    String displayName = pds[i].getDisplayName();
                    String name = pds[i].getName();
                    Class<?> type = pds[i].getPropertyType();
                    Method rm = pds[i].getReadMethod();
                    Method wm = pds[i].getWriteMethod();
                    System.out.println("  " + displayName + " " + name + " " + type.getName() + " " + rm + " " + wm + " " + pds[i].isPreferred());
                }
            }
            this.used = new boolean[this.properties.size()];
        }

        public void setProperty(String propertyName, String displayName, String toolTipText) {
            PropertyDescriptor pd = this.getProperty(propertyName);
            if (pd != null) {
                if (displayName != null) {
                    pd.setDisplayName(displayName);
                    JLabel hl = (JLabel)pd.getValue("Header");
                    if (hl != null) {
                        hl.setText(displayName);
                    }
                }
                if (toolTipText != null) {
                    pd.setShortDescription(toolTipText);
                    JComponent jc = (JComponent)pd.getValue("ToolTipComp");
                    if (jc != null) {
                        jc.setToolTipText(toolTipText);
                    }
                }
            } else {
                System.out.println("BeanTable.setProperty " + BeanTable.this.beanClass.getName() + " no property named " + propertyName);
            }
        }

        public int getRowCount() {
            return BeanTable.this.beans.size();
        }

        public int getColumnCount() {
            return this.properties.size();
        }

        public String getColumnName(int col) {
            return ((PropertyDescriptor)this.properties.get(col)).getDisplayName();
        }

        public Object getValueAt(int row, int col) {
            Object bean = BeanTable.this.beans.get(row);
            Object value = "N/A";
            PropertyDescriptor pd = (PropertyDescriptor)this.properties.get(col);
            try {
                Method m = pd.getReadMethod();
                value = m.invoke(bean, null);
            }
            catch (Exception ee) {
                System.out.println("BeanTable: Bad getReadMethod " + row + " " + col + " " + BeanTable.this.beanClass.getName() + " " + pd.getDisplayName());
                ee.printStackTrace();
            }
            return value;
        }

        public Object getValueAt(Object bean, int col) {
            Object value = "N/A";
            try {
                Method m = ((PropertyDescriptor)this.properties.get(col)).getReadMethod();
                value = m.invoke(bean, null);
            }
            catch (Exception ee) {
                System.out.println("BeanTable: Bad Bean " + bean + " " + col + " " + BeanTable.this.beanClass.getName());
                ee.printStackTrace();
            }
            return value;
        }

        public Class getColumnClass(int col) {
            Class c = this.wrapPrimitives(((PropertyDescriptor)this.properties.get(col)).getPropertyType());
            return c;
        }

        private void checkColumnRenderer(int col) {
            TableColumnModel colModel = BeanTable.this.jtable.getColumnModel();
            TableColumn tabCol = colModel.getColumn(col);
            TableCellEditor editor = tabCol.getCellEditor();
            TableCellRenderer render = tabCol.getCellRenderer();
            System.out.println(col + "  editor = " + (editor == null ? "null" : editor.getClass().getName()));
            System.out.println(col + "  render = " + (render == null ? "null" : render.getClass().getName()));
        }

        public boolean isCellEditable(int row, int col) {
            PropertyDescriptor pd = (PropertyDescriptor)this.properties.get(col);
            if (!pd.isPreferred()) {
                return false;
            }
            Class<?> type = pd.getPropertyType();
            return type.isPrimitive() || type == (class$java$lang$String == null ? (class$java$lang$String = BeanTable.class$("java.lang.String")) : class$java$lang$String);
        }

        public void setValueAt(Object value, int row, int col) {
            Object bean = BeanTable.this.beans.get(row);
            try {
                Object[] params = new Object[]{value};
                Method m = ((PropertyDescriptor)this.properties.get(col)).getWriteMethod();
                if (m != null) {
                    m.invoke(bean, params);
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            this.fireTableCellUpdated(row, col);
        }

        protected Class wrapPrimitives(Class c) {
            if (c == Boolean.TYPE) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanTable.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (c == Integer.TYPE) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = BeanTable.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (c == Float.TYPE) {
                return class$java$lang$Float == null ? (class$java$lang$Float = BeanTable.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (c == Double.TYPE) {
                return class$java$lang$Double == null ? (class$java$lang$Double = BeanTable.class$("java.lang.Double")) : class$java$lang$Double;
            }
            if (c == Short.TYPE) {
                return class$java$lang$Short == null ? (class$java$lang$Short = BeanTable.class$("java.lang.Short")) : class$java$lang$Short;
            }
            if (c == Long.TYPE) {
                return class$java$lang$Long == null ? (class$java$lang$Long = BeanTable.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (c == Byte.TYPE) {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = BeanTable.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            return c;
        }

        protected Object zeroValue(Class c) {
            if (c == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanTable.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return Boolean.FALSE;
            }
            if (c == (class$java$lang$Integer == null ? (class$java$lang$Integer = BeanTable.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new Integer(0);
            }
            if (c == (class$java$lang$Float == null ? (class$java$lang$Float = BeanTable.class$("java.lang.Float")) : class$java$lang$Float)) {
                return new Float(0.0);
            }
            if (c == (class$java$lang$Double == null ? (class$java$lang$Double = BeanTable.class$("java.lang.Double")) : class$java$lang$Double)) {
                return new Double(0.0);
            }
            if (c == (class$java$lang$Short == null ? (class$java$lang$Short = BeanTable.class$("java.lang.Short")) : class$java$lang$Short)) {
                return new Short(0);
            }
            if (c == (class$java$lang$Long == null ? (class$java$lang$Long = BeanTable.class$("java.lang.Long")) : class$java$lang$Long)) {
                return new Long(0L);
            }
            if (c == (class$java$lang$Byte == null ? (class$java$lang$Byte = BeanTable.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return new Byte(0);
            }
            return null;
        }

        protected int getPropertyIndex(String wantName) {
            for (int i = 0; i < this.properties.size(); ++i) {
                String name = ((PropertyDescriptor)this.properties.get(i)).getName();
                if (!name.equals(wantName)) continue;
                this.used[i] = true;
                return i;
            }
            return -1;
        }

        protected PropertyDescriptor getProperty(String wantName) {
            for (int i = 0; i < this.properties.size(); ++i) {
                PropertyDescriptor p = (PropertyDescriptor)this.properties.get(i);
                if (!p.getName().equals(wantName)) continue;
                return p;
            }
            return null;
        }

        protected PropertyDescriptor getProperty(int idx) {
            return (PropertyDescriptor)this.properties.get(idx);
        }

        protected boolean wasUsed(int col) {
            return this.used[col];
        }

        private void setEditable(PropertyDescriptor pd, String editableProperties) {
            if (this.editP == null) {
                this.editP = new ArrayList();
                StringTokenizer toke = new StringTokenizer(editableProperties);
                while (toke.hasMoreTokens()) {
                    this.editP.add(toke.nextToken());
                }
            }
            pd.setPreferred(this.editP.contains(pd.getName()));
        }

        private boolean isHidden(PropertyDescriptor pd, String hiddenProperties) {
            if (this.hiddenP == null) {
                this.hiddenP = new ArrayList();
                StringTokenizer toke = new StringTokenizer(hiddenProperties);
                while (toke.hasMoreTokens()) {
                    this.hiddenP.add(toke.nextToken());
                }
            }
            return this.hiddenP.contains(pd.getName());
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        private SimpleDateFormat newForm;
        private SimpleDateFormat oldForm = new SimpleDateFormat("yyyy MMM dd HH:mm z");
        private Date cutoff;

        DateRenderer() {
            this.oldForm.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.newForm = new SimpleDateFormat("MMM dd, HH:mm z");
            this.newForm.setTimeZone(TimeZone.getTimeZone("GMT"));
            Calendar cal = Calendar.getInstance();
            cal.setTimeZone(TimeZone.getTimeZone("GMT"));
            cal.add(1, -1);
            this.cutoff = cal.getTime();
        }

        public void setValue(Object value) {
            if (value == null) {
                this.setText("");
            } else {
                Date date = (Date)value;
                if (date.before(this.cutoff)) {
                    this.setText(this.oldForm.format(date));
                } else {
                    this.setText(this.newForm.format(date));
                }
            }
        }
    }

    public static class PropertyCol {
        private String name;
        private int modelIndex;
        private int width;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }
    }
}

