/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.AnimationControl;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Display;
import visad.DisplayException;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Set;
import visad.VisADException;

public class AnimationWidget
extends JPanel
implements ActionListener,
ChangeListener,
ControlListener,
ScalarMapListener {
    private static final boolean DEBUG = false;
    private boolean aDir;
    private boolean aAnim;
    private int aMs;
    private JRadioButton forward;
    private JRadioButton reverse;
    private JButton onOff;
    private JButton step;
    private JTextField ms;
    private JSlider TimeSlider;
    private AnimationControl control;

    public AnimationWidget(ScalarMap smap) throws VisADException, RemoteException {
        this(smap, -1);
    }

    public AnimationWidget(ScalarMap smap, int st) throws VisADException, RemoteException {
        if (!Display.Animation.equals(smap.getDisplayScalar())) {
            throw new DisplayException("AnimationWidget: ScalarMap must be to Display.Animation");
        }
        this.aAnim = false;
        this.aDir = true;
        this.aMs = st;
        JPanel top = new JPanel();
        JPanel bottom = new JPanel();
        JPanel left = new JPanel();
        JPanel right = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        top.setLayout(new BoxLayout(top, 0));
        bottom.setLayout(new BoxLayout(bottom, 0));
        left.setLayout(new BoxLayout(left, 1));
        right.setLayout(new BoxLayout(right, 1));
        this.forward = new JRadioButton("Forward", this.aDir);
        this.reverse = new JRadioButton("Reverse", !this.aDir);
        this.onOff = new JButton("Stop");
        this.step = new JButton("Step");
        this.ms = new JTextField("????????");
        Dimension msize = this.ms.getMaximumSize();
        Dimension psize = this.ms.getPreferredSize();
        msize.height = psize.height;
        this.ms.setMaximumSize(msize);
        JLabel msLabel = new JLabel("ms/frame");
        this.TimeSlider = new JSlider(1, 1, 1);
        Color fore = msLabel.getForeground();
        this.forward.setForeground(fore);
        this.reverse.setForeground(fore);
        this.onOff.setForeground(fore);
        this.step.setForeground(fore);
        this.ms.setForeground(fore);
        this.TimeSlider.setPaintTicks(true);
        this.onOff.setMaximumSize(this.step.getMaximumSize());
        ButtonGroup group = new ButtonGroup();
        group.add(this.forward);
        group.add(this.reverse);
        left.setAlignmentX(0.5f);
        left.setAlignmentY(0.0f);
        right.setAlignmentX(0.5f);
        right.setAlignmentY(0.0f);
        this.onOff.setAlignmentX(0.5f);
        this.step.setAlignmentX(0.5f);
        this.ms.setAlignmentY(0.5f);
        msLabel.setAlignmentX(0.5f);
        left.add(this.forward);
        left.add(this.reverse);
        right.add(this.onOff);
        right.add(this.step);
        top.add(left);
        top.add(right);
        this.add(top);
        bottom.add(this.ms);
        bottom.add(msLabel);
        this.add(bottom);
        this.add(this.TimeSlider);
        this.getControlSettings((AnimationControl)((Object)smap.getControl()));
        if (st > 0) {
            this.aMs = st;
            if (this.control != null) {
                this.control.setStep(this.aMs);
            }
        }
        this.fixControlUI();
        if (this.control != null) {
            this.control.addControlListener(this);
        }
        smap.addScalarMapListener(this);
        this.forward.addActionListener(this);
        this.forward.setActionCommand("forward");
        this.reverse.addActionListener(this);
        this.reverse.setActionCommand("reverse");
        this.onOff.addActionListener(this);
        this.onOff.setActionCommand("go");
        this.step.addActionListener(this);
        this.step.setActionCommand("step");
        this.ms.addActionListener(this);
        this.ms.setActionCommand("ms");
        this.TimeSlider.addChangeListener(this);
    }

    private void getControlSettings(AnimationControl ctl) {
        this.control = ctl;
        if (this.control != null) {
            this.aDir = this.control.getDirection();
            this.aAnim = this.control.getOn();
            this.aMs = (int)this.control.getStep();
        }
    }

    private void fixAnimUI() {
        if (this.aAnim) {
            this.onOff.setText("Stop");
            this.step.setEnabled(false);
        } else {
            this.onOff.setText("Go");
            this.step.setEnabled(true);
        }
    }

    private void fixDirUI() {
        if (this.aDir) {
            this.forward.setSelected(true);
        } else {
            this.reverse.setSelected(true);
        }
    }

    private void fixSpeedUI() {
        this.ms.setText(Integer.toString(this.aMs));
    }

    private void fixSliderUI() {
        int max = 1;
        int cur = 1;
        Set set = null;
        if (this.control != null) {
            try {
                set = this.control.getSet();
                if (set != null) {
                    max = set.getLength();
                }
            }
            catch (VisADException exc) {
                // empty catch block
            }
            cur = this.control.getCurrent() + 1;
            if (cur < 1) {
                cur = 1;
            } else if (cur > max) {
                cur = max;
            }
        }
        this.TimeSlider.setMaximum(max);
        this.TimeSlider.setMinimum(1);
        this.TimeSlider.setValue(cur);
        int maj = max < 20 ? max / 4 : (max < 30 ? max / 6 : max / 8);
        this.TimeSlider.setMajorTickSpacing(maj);
        this.TimeSlider.setMinorTickSpacing(maj / 4);
        this.TimeSlider.setPaintLabels(set != null);
        this.TimeSlider.repaint();
    }

    private void fixControlUI() {
        this.fixAnimUI();
        this.fixDirUI();
        this.fixSpeedUI();
        this.fixSliderUI();
    }

    public void actionPerformed(ActionEvent e) {
        block25: {
            if (this.control == null) {
                System.out.println("control == null in AnimationWidget.actionPerformed");
                return;
            }
            String cmd = e.getActionCommand();
            if (cmd.equals("forward")) {
                try {
                    this.control.setDirection(true);
                    this.aDir = true;
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
            }
            if (cmd.equals("reverse")) {
                try {
                    this.control.setDirection(false);
                    this.aDir = false;
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
            }
            if (cmd.equals("ms") || cmd.equals("go") && !this.aAnim) {
                int fr = -1;
                try {
                    fr = Integer.parseInt(this.ms.getText());
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
                if (fr > 0) {
                    try {
                        this.control.setStep(fr);
                        this.aMs = fr;
                        if (this.aDir) {
                            this.forward.requestFocus();
                        } else {
                            this.reverse.requestFocus();
                        }
                    }
                    catch (VisADException exc) {
                    }
                    catch (RemoteException exc) {
                        // empty catch block
                    }
                }
                this.fixSpeedUI();
            }
            if (cmd.equals("go")) {
                try {
                    this.control.setOn(!this.aAnim);
                    this.aAnim = !this.aAnim;
                    this.fixAnimUI();
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
            }
            if (!cmd.equals("step")) break block25;
            try {
                this.control.takeStep();
            }
            catch (VisADException exc) {
            }
            catch (RemoteException exc) {}
        }
    }

    public void stateChanged(ChangeEvent e) {
        try {
            if (this.control != null) {
                this.control.setCurrent(this.TimeSlider.getValue() - 1);
            }
        }
        catch (VisADException exc) {
        }
        catch (RemoteException exc) {}
    }

    public void controlChanged(ControlEvent e) {
        if (this.control != null) {
            int newMs;
            boolean newAnim;
            boolean newDir = this.control.getDirection();
            if (newDir != this.aDir) {
                this.aDir = newDir;
                this.fixDirUI();
            }
            if ((newAnim = this.control.getOn()) != this.aAnim) {
                this.aAnim = newAnim;
                this.fixAnimUI();
            }
            if ((newMs = (int)this.control.getStep()) != this.aMs) {
                this.aMs = newMs;
                this.fixSpeedUI();
            }
            this.fixSliderUI();
        }
    }

    public void mapChanged(ScalarMapEvent e) {
        this.fixSliderUI();
    }

    public void controlChanged(ScalarMapControlEvent evt) {
        int id = evt.getId();
        if (id == 4 || id == 5) {
            evt.getControl().removeControlListener(this);
            if (id == 4) {
                this.control = null;
            }
        }
        if (id == 5 || id == 3) {
            this.control = (AnimationControl)((Object)evt.getScalarMap().getControl());
            this.getControlSettings(this.control);
            this.fixControlUI();
            if (this.control != null) {
                this.control.addControlListener(this);
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(d.width, d.height + 18);
    }
}

