/*
 * Decompiled with CFR 0.152.
 */
package visad.math;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import visad.Data;
import visad.DataReferenceImpl;
import visad.Display;
import visad.Field;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Integer2DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.SetType;
import visad.TypeException;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public class Histogram {
    public static FlatField makeHistogram(Data[] datums) {
        FlatField result = null;
        try {
            if (datums == null || datums.length != 2) {
                throw new VisADException("bad arguments");
            }
            if (!(datums[0] instanceof Field)) {
                throw new VisADException("first argument must be a Field");
            }
            if (!(datums[1] instanceof Set)) {
                throw new VisADException("second argument must be a Set");
            }
            result = Histogram.makeHistogram((Field)datums[0], (Set)datums[1]);
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (result == null) {
            System.out.println("result == null");
        }
        return result;
    }

    public static FlatField makeHistogram(Field field, Set set) throws VisADException, RemoteException {
        FunctionType ftype = (FunctionType)field.getType();
        RealType[] frealComponents = ftype.getRealComponents();
        RealTupleType stype = ((SetType)set.getType()).getDomain();
        RealType[] srealComponents = stype.getRealComponents();
        RealType count = RealType.getRealType("count");
        FunctionType htype = new FunctionType(stype, count);
        int dim = srealComponents.length;
        float[][] field_values = field.getFloats(false);
        float[][] set_values = new float[dim][];
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < frealComponents.length) {
                if (srealComponents[i].equals(frealComponents[j])) {
                    set_values[i] = field_values[j];
                    break;
                }
                ++j;
            }
            if (set_values[i] == null) {
                throw new TypeException("set component " + srealComponents[i] + " does not occur in " + ftype);
            }
            ++i;
        }
        int[] indices = set.valueToIndex(set_values);
        int len = set.getLength();
        float[][] hist_values = new float[1][len];
        int i2 = 0;
        while (i2 < len) {
            hist_values[0][i2] = 0.0f;
            ++i2;
        }
        int j = 0;
        while (j < indices.length) {
            if (indices[j] >= 0) {
                float[] fArray = hist_values[0];
                int n = indices[j];
                fArray[n] = fArray[n] + 1.0f;
            }
            ++j;
        }
        FlatField result = new FlatField(htype, set);
        result.setSamples(hist_values, false);
        return result;
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        int SIZE = 64;
        RealType X = RealType.getRealType("X");
        RealType Y = RealType.getRealType("Y");
        RealType A = RealType.getRealType("A");
        RealType B = RealType.getRealType("B");
        RealType[] domain2d = new RealType[]{X, Y};
        RealTupleType Domain2d = new RealTupleType(domain2d);
        Integer2DSet Domain2dSet = new Integer2DSet((MathType)Domain2d, SIZE, SIZE);
        RealType[] range2d = new RealType[]{A, B};
        RealTupleType Range2d = new RealTupleType(range2d);
        FunctionType Field2d2 = new FunctionType(Domain2d, Range2d);
        FlatField image = new FlatField(Field2d2, Domain2dSet);
        int len = Domain2dSet.getLength();
        int ADD = len * len / 16;
        float[][] values = new float[2][len];
        int i = 0;
        while (i < len) {
            values[0][i] = i;
            values[1][i] = (float)((double)(i * i + ADD) * Math.random());
            ++i;
        }
        image.setSamples(values, false);
        Linear2DSet histSet = new Linear2DSet((MathType)Range2d, 0.5 * (double)SIZE, (double)len - 0.5 * (double)SIZE, len / SIZE, 0.5 * (double)SIZE * (double)len, (double)(len * len + ADD) - 0.5 * (double)SIZE * (double)len, len / SIZE);
        FlatField hist = Histogram.makeHistogram(image, histSet);
        RealType count = RealType.getRealType("count");
        DisplayImplJ3D display1 = new DisplayImplJ3D("display1");
        display1.addMap(new ScalarMap(A, Display.XAxis));
        display1.addMap(new ScalarMap(B, Display.YAxis));
        if (args.length == 0) {
            display1.addMap(new ScalarMap(count, Display.ZAxis));
        }
        display1.addMap(new ScalarMap(count, Display.RGB));
        GraphicsModeControl gmc = display1.getGraphicsModeControl();
        gmc.setScaleEnable(true);
        gmc.setCurvedSize(1);
        DataReferenceImpl hist_ref = new DataReferenceImpl("hist_ref");
        hist_ref.setData(hist);
        display1.addReference(hist_ref);
        JFrame frame = new JFrame("VisAD HSV Color Coordinates");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(display1.getComponent());
        int WIDTH = 500;
        int HEIGHT = 600;
        frame.setSize(WIDTH, HEIGHT);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        frame.setVisible(true);
    }
}

