/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DoubleSet;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.Function;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.IntegerNDSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.ProductSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.SimpleSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.Unit;
import visad.data.DefaultFamily;

public class DumpType {
    private static boolean init = true;
    private static OutputStream os;

    public static void dumpDataType(Data d) {
        DumpType.dumpDataType(d, System.out);
    }

    public static void dumpDataType(Data d, OutputStream uos) {
        os = uos;
        DumpType.dumpDT(d, " ");
    }

    private static void dumpDT(Data d, String prefix) {
        if (init) {
            System.out.println("VisAD Data analysis");
        }
        init = false;
        try {
            if (d instanceof FlatField) {
                int nr = ((FlatField)d).getRangeDimension();
                int nd = ((FlatField)d).getDomainDimension();
                Set ds = ((FlatField)d).getDomainSet();
                prefix = prefix + "  ";
                System.out.println(prefix + " FlatField of length = " + ((FlatField)d).getLength());
                System.out.println(prefix + " " + ((FlatField)d).getType().prettyString());
                prefix = prefix + "  ";
                System.out.println(prefix + " Domain has " + nd + " components:");
                DumpType.dumpDT(ds, prefix + "  ");
                DumpType.dumpDomainCS(ds, prefix + "  ");
                System.out.println(prefix + " Range has " + nr + " components:");
                Set[] dr = ((FlatField)d).getRangeSets();
                float[][] samples = ((FlatField)d).getFloats(false);
                int i = 0;
                while (i < dr.length) {
                    DumpType.dumpDT(dr[i], prefix + "   " + i + ".");
                    int nmiss = 0;
                    if (samples[i] == null) {
                        nmiss = ((FlatField)d).getLength();
                    } else {
                        int j = 0;
                        while (j < samples[i].length) {
                            if (samples[i][j] != samples[i][j]) {
                                ++nmiss;
                            }
                            ++j;
                        }
                    }
                    System.out.println(prefix + "   " + i + ". number missing = " + nmiss);
                    ++i;
                }
            } else if (d instanceof FieldImpl) {
                int nd = ((FieldImpl)d).getDomainDimension();
                Set ds = ((FieldImpl)d).getDomainSet();
                System.out.println(prefix + " FieldImpl of length = " + ((FieldImpl)d).getLength());
                System.out.println(prefix + " " + ((FieldImpl)d).getType().prettyString());
                System.out.println(prefix + " Domain has " + nd + " components:");
                DumpType.dumpDT(ds, prefix + "  ");
                System.out.println(prefix + " first sample = ");
                DumpType.dumpDT(((FieldImpl)d).getSample(0, false), prefix + "   " + 0 + ".");
            } else if (d instanceof Field) {
                System.out.println(prefix + " Field: ");
            } else if (d instanceof Function) {
                System.out.println(prefix + " Function: ");
                System.out.println(prefix + "    Domain dimension= " + ((Function)d).getDomainDimension());
            } else if (d instanceof Irregular3DSet) {
                System.out.println(prefix + " Irregular3DSet " + DumpType.name(((Irregular3DSet)d).getType().toString()) + " Length = " + ((Irregular3DSet)d).getLength());
            } else if (d instanceof Irregular2DSet) {
                System.out.println(prefix + " Irregular2DSet " + DumpType.name(((Irregular2DSet)d).getType().toString()) + " Length = " + ((Irregular2DSet)d).getLength());
            } else if (d instanceof Irregular1DSet) {
                System.out.println(prefix + " Irregular1DSet " + DumpType.name(((Irregular1DSet)d).getType().toString()) + " Length = " + ((Irregular1DSet)d).getLength());
            } else if (d instanceof IrregularSet) {
                System.out.println(prefix + " IrregularSet " + DumpType.name(((IrregularSet)d).getType().toString()) + " Length = " + ((IrregularSet)d).getLength());
            } else if (d instanceof Integer3DSet) {
                System.out.println(prefix + " Integer3DSet: Length = " + ((Integer3DSet)d).getLength());
                int i = 0;
                while (i < 3) {
                    DumpType.dumpDT(((Linear3DSet)d).getLinear1DComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d instanceof Linear3DSet) {
                System.out.println(prefix + " Linear3DSet: Length = " + ((Linear3DSet)d).getLength());
                int i = 0;
                while (i < 3) {
                    DumpType.dumpDT(((Linear3DSet)d).getLinear1DComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d instanceof Gridded3DSet) {
                System.out.println(prefix + " Gridded3DSet " + DumpType.name(((Gridded3DSet)d).getType().toString()) + " Length = " + ((Gridded3DSet)d).getLength());
            } else if (d instanceof Integer2DSet) {
                System.out.println(prefix + " Integer2DSet: Length = " + ((Integer2DSet)d).getLength());
                int i = 0;
                while (i < 2) {
                    DumpType.dumpDT(((Linear2DSet)d).getLinear1DComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d instanceof Linear2DSet) {
                System.out.println(prefix + " Linear2DSet: Length = " + ((Linear2DSet)d).getLength());
                int i = 0;
                while (i < 2) {
                    DumpType.dumpDT(((Linear2DSet)d).getLinear1DComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d instanceof Gridded2DSet) {
                System.out.println(prefix + " Gridded2DSet " + DumpType.name(((Gridded2DSet)d).getType().toString()) + " Length = " + ((Gridded2DSet)d).getLength());
            } else if (d instanceof Integer1DSet) {
                System.out.println(prefix + " Integer1DSet " + DumpType.name(((Integer1DSet)d).getType().toString()) + " Range = 0 to " + (((Integer1DSet)d).getLength() - 1));
            } else if (d instanceof Linear1DSet) {
                System.out.println(prefix + " Linear1DSet " + DumpType.name(((Linear1DSet)d).getType().toString()) + " Range = " + ((Linear1DSet)d).getFirst() + " to " + ((Linear1DSet)d).getLast() + " step " + ((Linear1DSet)d).getStep());
            } else if (d instanceof Gridded1DSet) {
                System.out.println(prefix + " Gridded1DSet " + DumpType.name(((Gridded1DSet)d).getType().toString()) + "  Length = " + ((Gridded1DSet)d).getLength());
            } else if (d instanceof IntegerNDSet) {
                System.out.println(prefix + " IntegerNDSet: Dimension = " + ((IntegerNDSet)d).getDimension());
                int i = 0;
                while (i < ((IntegerNDSet)d).getDimension()) {
                    DumpType.dumpDT(((LinearNDSet)d).getLinear1DComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d instanceof LinearNDSet) {
                System.out.println(prefix + " LinearNDSet: Dimension = " + ((LinearNDSet)d).getDimension());
                int i = 0;
                while (i < ((LinearNDSet)d).getDimension()) {
                    DumpType.dumpDT(((LinearNDSet)d).getLinear1DComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d instanceof GriddedSet) {
                System.out.println(prefix + " GriddedSet " + DumpType.name(((GriddedSet)d).getType().toString()) + "  Dimension = " + ((GriddedSet)d).getDimension());
            } else if (d instanceof UnionSet) {
                System.out.println(prefix + " UnionSet " + DumpType.name(((UnionSet)d).getType().toString()) + "  Dimension = " + ((UnionSet)d).getDimension());
            } else if (d instanceof ProductSet) {
                System.out.println(prefix + " ProductSet " + DumpType.name(((ProductSet)d).getType().toString()) + "  Dimension = " + ((ProductSet)d).getDimension());
            } else if (d instanceof SampledSet) {
                System.out.println(prefix + " SampledSet " + DumpType.name(((SampledSet)d).getType().toString()) + "  Dimension = " + ((SampledSet)d).getDimension());
            } else if (d instanceof FloatSet) {
                System.out.println(prefix + " FloatSet " + DumpType.name(((FloatSet)d).getType().toString()) + " Dimension = " + ((FloatSet)d).getDimension());
            } else if (d instanceof DoubleSet) {
                System.out.println(prefix + " DoubleSet " + DumpType.name(((DoubleSet)d).getType().toString()) + "  Dimension = " + ((DoubleSet)d).getDimension());
            } else if (d instanceof SimpleSet) {
                System.out.println(prefix + " SimpleSet: ");
            } else if (d instanceof Set) {
                System.out.println(prefix + " Set: ");
            } else if (d instanceof RealTuple) {
                int n = ((RealTuple)d).getDimension();
                System.out.println(prefix + " RealTuple has " + n + " components:");
                RealTuple df = (RealTuple)d;
                int i = 0;
                while (i < n) {
                    DumpType.dumpDT(((RealTuple)d).getComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d instanceof Tuple) {
                int n = ((Tuple)d).getDimension();
                System.out.println(prefix + " Tuple has " + n + " components:");
                Tuple df = (Tuple)d;
                int i = 0;
                while (i < n) {
                    System.out.println("  ");
                    DumpType.dumpDT(((Tuple)d).getComponent(i), prefix + "   " + i + ".");
                    ++i;
                }
            } else if (d instanceof Text) {
                System.out.println(prefix + " Text: " + d);
            } else if (d instanceof Real) {
                System.out.println(prefix + " Real: " + d);
            } else {
                System.out.println("Unknown type for " + d);
            }
        }
        catch (Exception e) {
            System.out.println("Exception:" + e);
            return;
        }
    }

    private static String name(String n) {
        return n.substring(n.lastIndexOf("("));
    }

    public static void dumpMathType(MathType t) {
        DumpType.dumpMathType(t, System.out);
    }

    public static void dumpMathType(MathType t, OutputStream uos) {
        os = uos;
        DumpType.dumpMT(t, " ");
    }

    private static void dumpMT(MathType t, String prefix) {
        if (init) {
            System.out.println("VisAD MathType analysis");
        }
        init = false;
        try {
            if (t instanceof FunctionType) {
                System.out.println(prefix + " FunctionType: ");
                RealTupleType domain = ((FunctionType)t).getDomain();
                int num = domain.getDimension();
                System.out.println(prefix + " Domain has " + num + " components:");
                int i = 0;
                while (i < num) {
                    MathType comp = domain.getComponent(i);
                    DumpType.dumpMT(comp, prefix + "  " + i + ".");
                    ++i;
                }
                System.out.println(prefix + " Range:");
                MathType range = ((FunctionType)t).getRange();
                DumpType.dumpMT(range, prefix + "  ");
            } else if (t instanceof SetType) {
                System.out.println(prefix + " SetType: " + t);
            } else if (t instanceof RealTupleType) {
                int num = ((RealTupleType)t).getDimension();
                System.out.println(prefix + " RealTupleType has " + num + " components:");
                int i = 0;
                while (i < num) {
                    MathType comp = ((RealTupleType)t).getComponent(i);
                    DumpType.dumpMT(comp, prefix + "  " + i + ".");
                    ++i;
                }
            } else if (t instanceof TupleType) {
                int num = ((TupleType)t).getDimension();
                System.out.println(prefix + " TupleType has " + num + " components:");
                int i = 0;
                while (i < num) {
                    MathType comp = ((TupleType)t).getComponent(i);
                    DumpType.dumpMT(comp, prefix + "  " + i + ".");
                    ++i;
                }
            } else if (t instanceof TextType) {
                System.out.println(prefix + " TextType: " + t);
            } else if (t instanceof RealType) {
                Set ds;
                System.out.println(prefix + " RealType: " + t);
                prefix = prefix + "  ";
                System.out.println(prefix + " Name = " + ((RealType)t).toString());
                Unit du = ((RealType)t).getDefaultUnit();
                String s = null;
                if (du != null) {
                    s = du.toString();
                }
                if (s != null) {
                    System.out.println(prefix + " Unit: " + s);
                }
                if ((ds = ((RealType)t).getDefaultSet()) != null) {
                    MathType dsmt = ds.getType();
                    System.out.println(prefix + " Set: " + dsmt);
                }
            } else if (t instanceof ScalarType) {
                System.out.println(prefix + " ScaleType: " + t);
            } else {
                System.out.println("Unknown type for " + t);
            }
        }
        catch (Exception e) {
            System.out.println("Exception:" + e);
            return;
        }
    }

    private static void dumpDomainCS(Set s, String prefix) {
        RealTupleType ref;
        RealTupleType rtt = ((SetType)s.getType()).getDomain();
        CoordinateSystem cs = s.getCoordinateSystem();
        if (cs != null && (ref = cs.getReference()) != null) {
            System.out.println(prefix + " CoordinateSystem: " + rtt.prettyString() + " ==> " + ref.prettyString());
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: visad.jmet.DumpType <infile> ");
            System.exit(1);
            return;
        }
        DefaultFamily fr = new DefaultFamily("sample");
        URL url = null;
        try {
            url = new URL(args[0]);
        }
        catch (MalformedURLException exc) {
            // empty catch block
        }
        try {
            if (url != null) {
                System.out.println("Trying URL " + url.toString());
            } else {
                System.out.println("Trying file " + args[0]);
            }
            DataImpl data = url == null ? fr.open(args[0]) : fr.open(url);
            System.out.println(args[0] + ": " + data.getType().prettyString());
            System.out.println("  ");
            if (data != null) {
                DumpType.dumpDataType(data, System.out);
                MathType t = data.getType();
                init = true;
                System.out.println("  ");
                DumpType.dumpMathType(t, System.out);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(1);
        }
        System.exit(0);
    }
}

