/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.AxisScale;
import visad.ColorAlphaControl;
import visad.ColorControl;
import visad.ContourControl;
import visad.Control;
import visad.ControlEvent;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayRenderer;
import visad.Flow1Control;
import visad.Flow2Control;
import visad.MouseBehavior;
import visad.RangeControl;
import visad.RealType;
import visad.RendererControl;
import visad.RendererSourceListener;
import visad.ScalarMap;
import visad.ShapeControl;
import visad.TextControl;
import visad.VisADAppearance;
import visad.VisADException;
import visad.VisADGroup;
import visad.VisADLineArray;
import visad.VisADRay;
import visad.VisADSwitch;
import visad.VisADTriangleArray;
import visad.java2d.AnimationControlJ2D;
import visad.java2d.DefaultRendererJ2D;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java2d.KeyboardBehaviorJ2D;
import visad.java2d.MouseBehaviorJ2D;
import visad.java2d.ProjectionControlJ2D;
import visad.java2d.RendererJ2D;
import visad.java2d.ValueControlJ2D;
import visad.java2d.VisADCanvasJ2D;
import visad.util.Util;

public abstract class DisplayRendererJ2D
extends DisplayRenderer
implements RendererSourceListener {
    private VisADCanvasJ2D canvas;
    private VisADGroup root = null;
    private AffineTransform trans = null;
    private VisADGroup direct = null;
    private VisADGroup non_direct = null;
    private MouseBehaviorJ2D mouse = null;
    private VisADAppearance box = null;
    private VisADAppearance cursor = null;
    private AffineTransform cursor_trans = null;
    private VisADSwitch cursor_switch = null;
    private VisADGroup cursor_on = null;
    private VisADGroup cursor_off = null;
    private boolean cursorOn = false;
    private boolean directOn = false;
    private boolean scaleOn = false;
    private VisADSwitch box_switch = null;
    private VisADGroup box_on = null;
    private VisADGroup box_off = null;
    private boolean boxOn = false;
    private VisADSwitch scale_switch = null;
    private VisADGroup scale_on = null;
    private VisADGroup scale_off = null;
    private Vector directs = new Vector();
    private float cursorX;
    private float cursorY;
    private float cursorZ;
    private float line_x;
    private float line_y;
    private float line_z;
    private float point_x;
    private float point_y;
    private float point_z;
    static /* synthetic */ Class class$visad$java2d$AnimationControlJ2D;
    static /* synthetic */ Class class$visad$Flow1Control;
    static /* synthetic */ Class class$visad$Flow2Control;

    public void setDisplay(DisplayImpl dpy) throws VisADException {
        super.setDisplay(dpy);
        dpy.addRendererSourceListener(this);
        this.boxOn = this.getRendererControl().getBoxOn();
    }

    public VisADGroup getRoot() {
        return this.root;
    }

    public void setClip(float xlow, float xhi, float ylow, float yhi) {
        this.canvas.setClip(xlow, xhi, ylow, yhi);
    }

    public void unsetClip() {
        this.canvas.unsetClip();
    }

    public void initControl(RendererControl ctl) {
        if (this.box != null) {
            try {
                ctl.setBoxColor(this.box.red, this.box.green, this.box.blue);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.cursor != null) {
            try {
                ctl.setBoxColor(this.cursor.red, this.cursor.green, this.cursor.blue);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.canvas != null) {
            float[] ca = this.canvas.getBackgroundColor();
            try {
                ctl.setBackgroundColor(ca[0], ca[1], ca[2]);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            ctl.setBoxOn(this.boxOn);
        }
        catch (Throwable t) {}
    }

    private final boolean updateColors(VisADAppearance appear, float[] colors) {
        if (appear == null) {
            return false;
        }
        boolean fixed = false;
        int i = 0;
        while (i < 3) {
            float a;
            switch (i) {
                case 0: {
                    a = appear.red;
                    break;
                }
                case 1: {
                    a = appear.green;
                    break;
                }
                default: {
                    a = appear.blue;
                }
            }
            if (!Util.isApproximatelyEqual(a, colors[i])) {
                switch (i) {
                    case 0: {
                        appear.red = colors[i];
                        break;
                    }
                    case 1: {
                        appear.green = colors[i];
                        break;
                    }
                    default: {
                        appear.blue = colors[i];
                    }
                }
                fixed = true;
            }
            ++i;
        }
        return fixed;
    }

    public void controlChanged(ControlEvent evt) throws VisADException, RemoteException {
        boolean on;
        float[] ct;
        float[] ca;
        RendererControl ctl = (RendererControl)evt.getControl();
        float[] color = ctl.getBoxColor();
        if (this.updateColors(this.box, color)) {
            this.getCanvas().scratchImages();
        }
        if (this.updateColors(this.cursor, color = ctl.getCursorColor())) {
            this.render_trigger();
        }
        if (!(Util.isApproximatelyEqual((ca = this.canvas.getBackgroundColor())[0], (ct = ctl.getBackgroundColor())[0]) && Util.isApproximatelyEqual(ca[1], ct[1]) && Util.isApproximatelyEqual(ca[2], ct[2]))) {
            this.canvas.setBackgroundColor(ct[0], ct[1], ct[2]);
            this.canvas.scratchImages();
        }
        if ((on = ctl.getBoxOn()) != this.boxOn) {
            this.boxOn = on;
            this.box_switch.setWhichChild(this.boxOn ? 1 : 0);
            this.canvas.scratchImages();
        }
    }

    public AffineTransform getTrans() {
        return this.trans;
    }

    public VisADCanvasJ2D getCanvas() {
        return this.canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage() {
        BufferedImage image = null;
        while (image == null) {
            try {
                DisplayRendererJ2D displayRendererJ2D = this;
                synchronized (displayRendererJ2D) {
                    this.canvas.captureFlag = true;
                    this.canvas.renderTrigger();
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            image = this.canvas.captureImage;
            this.canvas.captureImage = null;
        }
        if (this.getDisplay().getComponent() == null) {
            int i = 0;
            while (i < 2) {
                try {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    JPEGEncodeParam jepar = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)image);
                    jepar.setQuality(1.0f, true);
                    JPEGImageEncoder jpege = JPEGCodec.createJPEGEncoder((OutputStream)bout);
                    jpege.encode(image, jepar);
                    bout.flush();
                    bout.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                ++i;
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCapture() {
        DisplayRendererJ2D displayRendererJ2D = this;
        synchronized (displayRendererJ2D) {
            this.notify();
        }
    }

    public VisADGroup getCursorOnBranch() {
        return this.cursor_on;
    }

    public VisADGroup getBoxOnBranch() {
        return this.box_on;
    }

    public void setCursorOn(boolean on) {
        this.cursorOn = on;
        if (on) {
            this.cursor_switch.setWhichChild(1);
            this.setCursorStringVector();
        } else {
            this.cursor_switch.setWhichChild(0);
            this.setCursorStringVector(null);
        }
        this.render_trigger();
    }

    public void setDirectOn(boolean on) {
        this.directOn = on;
        if (!on) {
            this.setCursorStringVector(null);
            this.render_trigger();
        }
    }

    public VisADGroup getDirect() {
        return this.direct;
    }

    public VisADGroup getNonDirect() {
        return this.non_direct;
    }

    public abstract VisADGroup createSceneGraph(VisADCanvasJ2D var1) throws DisplayException;

    public VisADGroup createBasicSceneGraph(VisADCanvasJ2D c, MouseBehaviorJ2D m) throws DisplayException {
        VisADAppearance box = new VisADAppearance();
        VisADAppearance cursor = new VisADAppearance();
        return this.createBasicSceneGraph(c, m, box, cursor);
    }

    public VisADGroup createBasicSceneGraph(VisADCanvasJ2D c, MouseBehaviorJ2D m, VisADAppearance bx, VisADAppearance cr) throws DisplayException {
        if (this.root != null) {
            return this.root;
        }
        this.mouse = m;
        this.canvas = c;
        this.box = bx;
        this.cursor = cr;
        this.canvas.addMouseBehavior(this.mouse);
        this.root = new VisADGroup();
        this.direct = new VisADGroup();
        this.root.addChild(this.direct);
        this.directOn = false;
        this.non_direct = new VisADGroup();
        this.root.addChild(this.non_direct);
        this.canvas.setDirect(this.direct, this.non_direct);
        this.cursor_trans = new AffineTransform();
        this.cursor_switch = new VisADSwitch();
        this.cursor_on = new VisADGroup();
        this.cursor_off = new VisADGroup();
        this.cursor_switch.addChild(this.cursor_off);
        this.cursor_switch.addChild(this.cursor_on);
        this.cursor_switch.setWhichChild(0);
        this.cursorOn = false;
        this.box_switch = new VisADSwitch();
        this.box_on = new VisADGroup();
        this.box_off = new VisADGroup();
        this.box_switch.addChild(this.box_off);
        this.box_switch.addChild(this.box_on);
        this.box_switch.setWhichChild(1);
        this.root.addChild(this.box_switch);
        try {
            this.setBoxOn(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.scale_switch = new VisADSwitch();
        this.root.addChild(this.scale_switch);
        this.scale_on = new VisADGroup();
        this.scale_off = new VisADGroup();
        this.scale_switch.addChild(this.scale_off);
        this.scale_switch.addChild(this.scale_on);
        this.scale_switch.setWhichChild(0);
        this.scaleOn = false;
        float[] ctlBg = this.getRendererControl().getBackgroundColor();
        this.canvas.setBackgroundColor(ctlBg[0], ctlBg[1], ctlBg[2]);
        return this.root;
    }

    public MouseBehavior getMouseBehavior() {
        return this.mouse;
    }

    public void addSceneGraphComponent(VisADGroup group) throws DisplayException {
        this.non_direct.addChild(group);
    }

    public void addDirectManipulationSceneGraphComponent(VisADGroup group, DirectManipulationRendererJ2D renderer) throws DisplayException {
        this.direct.addChild(group);
        this.directs.addElement(renderer);
    }

    public void clearScene(DataRenderer renderer) {
        this.directs.removeElement(renderer);
    }

    public double[] getCursor() {
        double[] cursor = new double[]{this.cursorX, this.cursorY, this.cursorZ};
        return cursor;
    }

    public void depth_cursor(VisADRay ray) {
        this.line_x = (float)ray.vector[0];
        this.line_y = (float)ray.vector[1];
        this.line_z = (float)ray.vector[2];
        this.point_x = this.cursorX;
        this.point_y = this.cursorY;
        this.point_z = this.cursorZ;
    }

    public void drag_depth(float diff) {
        this.cursorX = this.point_x + diff * this.line_x;
        this.cursorY = this.point_y + diff * this.line_y;
        this.cursorZ = this.point_z + diff * this.line_z;
        this.setCursorLoc();
    }

    public void drag_cursor(VisADRay ray, boolean first) {
        float o_x = (float)ray.position[0];
        float o_y = (float)ray.position[1];
        float o_z = (float)ray.position[2];
        float d_x = (float)ray.vector[0];
        float d_y = (float)ray.vector[1];
        float d_z = (float)ray.vector[2];
        if (first) {
            this.line_x = d_x;
            this.line_y = d_y;
            this.line_z = d_z;
        }
        float dot = (this.cursorX - o_x) * this.line_x + (this.cursorY - o_y) * this.line_y + (this.cursorZ - o_z) * this.line_z;
        float dot2 = d_x * this.line_x + d_y * this.line_y + d_z * this.line_z;
        if ((double)dot2 == 0.0) {
            return;
        }
        this.cursorX = o_x + (dot /= dot2) * d_x;
        this.cursorY = o_y + dot * d_y;
        this.cursorZ = o_z + dot * d_z;
        this.setCursorLoc();
    }

    private void setCursorLoc() {
        this.cursor_trans.setToTranslation(this.cursorX, this.cursorY);
        if (this.cursorOn) {
            this.setCursorStringVector();
        } else {
            this.render_trigger();
        }
    }

    public void render_trigger() {
        this.canvas.renderTrigger();
    }

    public boolean anyCursorStringVector() {
        if (this.cursorOn) {
            return true;
        }
        Enumeration renderers = ((Vector)this.directs.clone()).elements();
        while (renderers.hasMoreElements()) {
            DirectManipulationRendererJ2D r = (DirectManipulationRendererJ2D)renderers.nextElement();
            VisADGroup extra_branch = r.getExtraBranch();
            if (extra_branch == null) continue;
            return true;
        }
        if ((this.cursorOn || this.directOn) && !this.getCursorStringVector().isEmpty()) {
            return true;
        }
        Vector rendererVector = this.getDisplay().getRendererVector();
        renderers = rendererVector.elements();
        while (renderers.hasMoreElements()) {
            DataRenderer renderer = (DataRenderer)renderers.nextElement();
            if (renderer.getExceptionVector().isEmpty()) continue;
            return true;
        }
        return this.getWaitFlag();
    }

    public void drawCursorStringVector(Graphics graphics, AffineTransform tgeometry, int width, int height) {
        float[] c3;
        AffineTransform t = new AffineTransform(tgeometry);
        if (this.cursorOn) {
            t.concatenate(this.cursor_trans);
            VisADAppearance appearance = (VisADAppearance)this.cursor_on.getChild(0);
            if (appearance != null) {
                VisADCanvasJ2D.drawAppearance(graphics, appearance, t, null);
            }
            t = new AffineTransform(tgeometry);
        }
        Enumeration renderers = ((Vector)this.directs.clone()).elements();
        while (renderers.hasMoreElements()) {
            DirectManipulationRendererJ2D r = (DirectManipulationRendererJ2D)renderers.nextElement();
            VisADGroup extra_branch = r.getExtraBranch();
            if (extra_branch == null) continue;
            Vector children = extra_branch.getChildren();
            Enumeration childs = children.elements();
            while (childs.hasMoreElements()) {
                VisADAppearance child = (VisADAppearance)childs.nextElement();
                VisADCanvasJ2D.drawAppearance(graphics, child, t, null);
            }
        }
        try {
            c3 = this.getCursorColor();
        }
        catch (Exception e) {
            System.err.println("Yikes!  Couldn't get cursor color");
            c3 = new float[]{1.0f, 1.0f, 1.0f};
        }
        graphics.setColor(new Color(c3[0], c3[1], c3[2]));
        graphics.setFont(new Font("Times New Roman", 0, 10));
        int x = 1;
        int y = 10;
        if (this.cursorOn || this.directOn) {
            Enumeration strings = this.getCursorStringVector().elements();
            while (strings.hasMoreElements()) {
                String string = (String)strings.nextElement();
                graphics.drawString(string, x, y);
                y += 12;
            }
        }
        x = 1;
        y = height - 2;
        Vector rendererVector = this.getDisplay().getRendererVector();
        renderers = rendererVector.elements();
        while (renderers.hasMoreElements()) {
            DataRenderer renderer = (DataRenderer)renderers.nextElement();
            Vector exceptionVector = renderer.getExceptionVector();
            Enumeration exceptions = exceptionVector.elements();
            while (exceptions.hasMoreElements()) {
                Exception error = (Exception)exceptions.nextElement();
                String string = error.getMessage();
                graphics.drawString(string, x, y);
                y -= 12;
            }
        }
        if (this.getWaitFlag()) {
            graphics.drawString("please wait . . .", x, y);
            y -= 12;
        }
    }

    public DataRenderer findDirect(VisADRay ray, int mouseModifiers) {
        DirectManipulationRendererJ2D renderer = null;
        float distance = Float.MAX_VALUE;
        Enumeration renderers = ((Vector)this.directs.clone()).elements();
        while (renderers.hasMoreElements()) {
            DirectManipulationRendererJ2D r = (DirectManipulationRendererJ2D)renderers.nextElement();
            if (!r.getEnabled()) continue;
            r.setLastMouseModifiers(mouseModifiers);
            float d = r.checkClose(ray.position, ray.vector);
            if (!(d < distance)) continue;
            distance = d;
            renderer = r;
        }
        if (distance < this.getPickThreshhold()) {
            return renderer;
        }
        return null;
    }

    public boolean anyDirects() {
        return !this.directs.isEmpty();
    }

    public void setScaleOn(boolean on) {
        boolean oldOn = this.scaleOn;
        this.scaleOn = on;
        if (on) {
            this.scale_switch.setWhichChild(1);
        } else {
            this.scale_switch.setWhichChild(0);
        }
        if (this.scaleOn != oldOn) {
            this.canvas.scratchImages();
        }
    }

    public void setScale(AxisScale axisScale) throws VisADException {
        this.setScale(axisScale.getAxis(), axisScale.getAxisOrdinal(), axisScale.getScaleArray(), axisScale.getLabelArray(), axisScale.getColor().getColorComponents(null));
    }

    public void setScale(int axis, int axis_ordinal, VisADLineArray array, float[] scale_color) throws VisADException {
        this.setScale(axis, axis_ordinal, array, null, scale_color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScale(int axis, int axis_ordinal, VisADLineArray array, VisADTriangleArray labels, float[] scale_color) throws VisADException {
        VisADAppearance appearance = new VisADAppearance();
        appearance.red = scale_color[0];
        appearance.green = scale_color[1];
        appearance.blue = scale_color[2];
        appearance.color_flag = true;
        appearance.array = array;
        VisADGroup group = new VisADGroup();
        group.addChild(appearance);
        if (labels != null) {
            VisADAppearance labelAppearance = new VisADAppearance();
            labelAppearance.red = scale_color[0];
            labelAppearance.green = scale_color[1];
            labelAppearance.blue = scale_color[2];
            labelAppearance.color_flag = true;
            labelAppearance.array = labels;
            group.addChild(labelAppearance);
        }
        int dim = this.getMode2D() ? 2 : 3;
        VisADGroup visADGroup = this.scale_on;
        synchronized (visADGroup) {
            int n = this.scale_on.numChildren();
            int m = dim * axis_ordinal + axis;
            if (m >= n) {
                int i = n;
                while (i <= m) {
                    VisADGroup empty = new VisADGroup();
                    this.scale_on.addChild(empty);
                    ++i;
                }
            }
            this.scale_on.setChild(group, m);
        }
        this.canvas.scratchImages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearScales() {
        if (this.scale_on != null) {
            VisADGroup visADGroup = this.scale_on;
            synchronized (visADGroup) {
                int n = this.scale_on.numChildren();
                int i = n - 1;
                while (i >= 0) {
                    this.scale_on.removeChild(i);
                    --i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearScale(AxisScale axisScale) {
        int axis = axisScale.getAxis();
        int axis_ordinal = axisScale.getAxisOrdinal();
        int dim = this.getMode2D() ? 2 : 3;
        try {
            VisADGroup visADGroup = this.scale_on;
            synchronized (visADGroup) {
                int n = this.scale_on.numChildren();
                int m = dim * axis_ordinal + axis;
                if (m >= n) {
                    int i = n;
                    while (i <= m) {
                        VisADGroup empty = new VisADGroup();
                        this.scale_on.addChild(empty);
                        ++i;
                    }
                }
                VisADGroup empty = new VisADGroup();
                this.scale_on.setChild(empty, m);
                this.canvas.scratchImages();
            }
        }
        catch (VisADException ve) {}
    }

    public void setTransform2D(AffineTransform t) {
        this.trans = new AffineTransform(t);
    }

    public Control makeControl(ScalarMap map) {
        DisplayRealType type = map.getDisplayScalar();
        DisplayImplJ2D display = (DisplayImplJ2D)this.getDisplay();
        if (type == null) {
            return null;
        }
        if (type.equals(Display.XAxis) || type.equals(Display.YAxis) || type.equals(Display.ZAxis) || type.equals(Display.Latitude) || type.equals(Display.Longitude) || type.equals(Display.Radius)) {
            return (ProjectionControlJ2D)display.getProjectionControl();
        }
        if (type.equals(Display.RGB) || type.equals(Display.HSV) || type.equals(Display.CMY)) {
            return new ColorControl(display);
        }
        if (type.equals(Display.RGBA)) {
            return new ColorAlphaControl(display);
        }
        if (type.equals(Display.Animation)) {
            Control control = display.getControl(class$visad$java2d$AnimationControlJ2D == null ? (class$visad$java2d$AnimationControlJ2D = DisplayRendererJ2D.class$("visad.java2d.AnimationControlJ2D")) : class$visad$java2d$AnimationControlJ2D);
            if (control != null) {
                return control;
            }
            return new AnimationControlJ2D(display, (RealType)map.getScalar());
        }
        if (type.equals(Display.SelectValue)) {
            return new ValueControlJ2D(display);
        }
        if (type.equals(Display.SelectRange)) {
            return new RangeControl(display);
        }
        if (type.equals(Display.IsoContour)) {
            return new ContourControl(display);
        }
        if (type.equals(Display.Flow1X) || type.equals(Display.Flow1Y) || type.equals(Display.Flow1Z) || type.equals(Display.Flow1Elevation) || type.equals(Display.Flow1Azimuth) || type.equals(Display.Flow1Radial)) {
            Control control = display.getControl(class$visad$Flow1Control == null ? (class$visad$Flow1Control = DisplayRendererJ2D.class$("visad.Flow1Control")) : class$visad$Flow1Control);
            if (control != null) {
                return control;
            }
            return new Flow1Control(display);
        }
        if (type.equals(Display.Flow2X) || type.equals(Display.Flow2Y) || type.equals(Display.Flow2Z) || type.equals(Display.Flow2Elevation) || type.equals(Display.Flow2Azimuth) || type.equals(Display.Flow2Radial)) {
            Control control = display.getControl(class$visad$Flow2Control == null ? (class$visad$Flow2Control = DisplayRendererJ2D.class$("visad.Flow2Control")) : class$visad$Flow2Control);
            if (control != null) {
                return control;
            }
            return new Flow2Control(display);
        }
        if (type.equals(Display.Shape)) {
            return new ShapeControl(display);
        }
        if (type.equals(Display.Text)) {
            return new TextControl(display);
        }
        return null;
    }

    public DataRenderer makeDefaultRenderer() {
        return new DefaultRendererJ2D();
    }

    public boolean legalDataRenderer(DataRenderer renderer) {
        return renderer instanceof RendererJ2D;
    }

    public void rendererDeleted(DataRenderer renderer) {
        this.clearScene(renderer);
    }

    public void setLineWidth(float width) {
    }

    public void addKeyboardBehavior(KeyboardBehaviorJ2D behavior) {
        this.getCanvas().addKeyboardBehavior(behavior);
    }

    public void setWaitFlag(boolean b) {
        boolean old = this.getWaitFlag();
        super.setWaitFlag(b);
        if (b != old && this.canvas != null) {
            this.canvas.renderTrigger();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

