/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.rmi.RemoteException;
import visad.Data;
import visad.DataDisplayLink;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.VisADException;
import visad.VisADGroup;
import visad.collab.CollabUtil;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.RendererJ2D;
import visad.java2d.ShadowTypeJ2D;

public class DefaultRendererJ2D
extends RendererJ2D {
    DataDisplayLink link;

    public void setLinks(DataDisplayLink[] links, DisplayImpl d) throws VisADException {
        if (links == null || links.length != 1) {
            throw new DisplayException("DefaultRendererJ2D.setLinks: must be exactly one DataDisplayLink");
        }
        super.setLinks(links, d);
    }

    public VisADGroup doTransform() throws VisADException, RemoteException {
        Data data;
        DataDisplayLink[] Links = this.getLinks();
        if (Links == null || Links.length == 0) {
            this.link = null;
            return null;
        }
        this.link = Links[0];
        ShadowTypeJ2D type = (ShadowTypeJ2D)this.link.getShadow();
        VisADGroup branch = new VisADGroup();
        int valueArrayLength = this.getDisplay().getValueArrayLength();
        float[] valueArray = new float[valueArrayLength];
        int i = 0;
        while (i < valueArrayLength) {
            valueArray[i] = Float.NaN;
            ++i;
        }
        try {
            data = this.link.getData();
        }
        catch (RemoteException re) {
            if (CollabUtil.isDisconnectException(re)) {
                this.getDisplay().connectionFailed(this, this.link);
                this.removeLink(this.link);
                return null;
            }
            throw re;
        }
        if (data == null) {
            branch = null;
            this.addException(new DisplayException("Data is null: DefaultRendererJ2D.doTransform"));
        } else {
            boolean post_process;
            this.link.start_time = System.currentTimeMillis();
            this.link.time_flag = false;
            type.preProcess();
            try {
                post_process = type.doTransform(branch, data, valueArray, this.link.getDefaultValues(), this);
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.getDisplay().connectionFailed(this, this.link);
                    this.removeLink(this.link);
                    return null;
                }
                throw re;
            }
            if (post_process) {
                type.postProcess(branch);
            }
        }
        this.link.clearData();
        return branch;
    }

    void addSwitch(DisplayRendererJ2D displayRenderer, VisADGroup branch) throws VisADException {
        displayRenderer.addSceneGraphComponent(branch);
    }

    public DataDisplayLink getLink() {
        return this.link;
    }

    public Object clone() {
        return new DefaultRendererJ2D();
    }
}

