/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Path {
    private ArrayList path;

    public Path(String pathStr) throws IllegalArgumentException {
        if (pathStr == null) {
            throw new IllegalArgumentException("Null path string");
        }
        if (pathStr.length() == 0) {
            throw new IllegalArgumentException("Empty path string");
        }
        StringTokenizer tok = new StringTokenizer(pathStr, File.pathSeparator);
        int numTokens = tok.countTokens();
        if (numTokens == 0) {
            throw new IllegalArgumentException("Empty path string");
        }
        this.path = new ArrayList();
        boolean i = false;
        while (tok.hasMoreTokens()) {
            this.path.add(tok.nextToken());
        }
    }

    public ArrayList find(String file) {
        if (file == null || file.length() == 0) {
            return null;
        }
        int pathLen = this.path.size();
        ArrayList<File> list = null;
        int i = 0;
        while (i < pathLen) {
            File f = new File((String)this.path.get(i), file);
            if (f.isFile()) {
                if (list == null) {
                    list = new ArrayList<File>();
                }
                list.add(f);
            }
            ++i;
        }
        if (list == null) {
            return null;
        }
        return list;
    }

    public ArrayList findMatch(String file) {
        if (file == null || file.length() == 0) {
            return null;
        }
        int pathLen = this.path.size();
        ArrayList<File> list = null;
        int i = 0;
        while (i < pathLen) {
            File f;
            String pElem = (String)this.path.get(i);
            if (pElem.endsWith(File.separator + file) && (f = new File(pElem)).exists()) {
                if (list == null) {
                    list = new ArrayList<File>();
                }
                list.add(f);
            }
            ++i;
        }
        return list;
    }

    public String toString() {
        if (this.path == null || this.path.size() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer((String)this.path.get(0));
        int i = 1;
        while (i < this.path.size()) {
            buf.append(File.pathSeparator);
            buf.append(this.path.get(i));
            ++i;
        }
        return buf.toString();
    }

    public static final void main(String[] args) throws IllegalArgumentException {
        if (args.length < 2) {
            System.err.println("Usage: java Path pathString file [file ...]");
            System.exit(1);
            return;
        }
        Path p = new Path(args[0]);
        int i = 1;
        while (i < args.length) {
            ArrayList l = p.findMatch(args[i]);
            if (l == null && (l = p.find(args[i])) == null) {
                System.err.println("Couldn't find \"" + args[i] + "\"");
            } else {
                System.out.println(args[i] + ":");
                int j = 0;
                while (j < l.size()) {
                    System.out.println("  " + l.get(j));
                    ++j;
                }
            }
            ++i;
        }
        System.exit(0);
    }
}

