/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.BaseUnit;
import visad.CommonUnit;
import visad.Unit;
import visad.VisADException;
import visad.data.units.Parser;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryString;

public class BinaryUnit
implements BinaryObject {
    public static final int computeBytes(Unit u) {
        return 4 + BinaryString.computeBytes(u.getIdentifier()) + BinaryString.computeBytes(u.getDefinition().trim()) + 1;
    }

    public static final int computeBytes(Unit[] array) {
        return BinaryIntegerArray.computeBytes(array);
    }

    public static final int[] lookupList(BinaryObjectCache cache, Unit[] units) {
        boolean empty = true;
        int i = 0;
        while (i < units.length) {
            if (units[i] != null) {
                empty = false;
                break;
            }
            ++i;
        }
        if (empty) {
            return null;
        }
        int[] indices = new int[units.length];
        int i2 = 0;
        while (i2 < units.length) {
            indices[i2] = units[i2] == null ? -1 : cache.getIndex(units[i2]);
            ++i2;
        }
        return indices;
    }

    public static final Unit read(BinaryReader reader) throws IOException, VisADException {
        Unit u;
        BinaryObjectCache cache = reader.getUnitCache();
        DataInput file = reader.getInput();
        int objLen = file.readInt();
        int index = file.readInt();
        String idStr = BinaryString.read(reader);
        String defStr = BinaryString.read(reader);
        byte endByte = file.readByte();
        if (endByte != 80) {
            throw new IOException("Corrupted file (no Unit end-marker)");
        }
        if (defStr.equals("promiscuous") || defStr.equals("UniversalUnit")) {
            u = CommonUnit.promiscuous;
        } else {
            try {
                u = Parser.parse(defStr);
            }
            catch (Exception e) {
                throw new VisADException("Couldn't parse Unit specification \"" + defStr + "\"");
            }
            if (!(u instanceof BaseUnit)) {
                try {
                    Unit namedUnit;
                    u = namedUnit = u.clone(idStr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        cache.add(index, u);
        return u;
    }

    public static final Unit[] readList(BinaryReader reader) throws IOException {
        BinaryObjectCache cache = reader.getUnitCache();
        DataInput file = reader.getInput();
        int len = file.readInt();
        if (len < 1) {
            throw new IOException("Corrupted file (bad Unit array length " + len + ")");
        }
        Unit[] units = new Unit[len];
        int i = 0;
        while (i < len) {
            int index = file.readInt();
            units[i] = index < 0 ? null : (Unit)cache.get(index);
            ++i;
        }
        return units;
    }

    public static final int write(BinaryWriter writer, Unit u, Object token) throws IOException {
        BinaryObjectCache cache = writer.getUnitCache();
        int index = cache.getIndex(u);
        if (index >= 0) {
            return index;
        }
        String uDef = u.getDefinition().trim();
        String uId = u.getIdentifier();
        index = cache.add(u);
        if (index < 0) {
            throw new IOException("Couldn't cache Unit " + u);
        }
        int objLen = BinaryUnit.computeBytes(u);
        DataOutput file = writer.getOutput();
        file.writeByte(7);
        file.writeInt(objLen);
        file.writeInt(index);
        BinaryString.write(writer, uId, token);
        BinaryString.write(writer, uDef, token);
        file.writeByte(80);
        return index;
    }

    public static final int[] writeList(BinaryWriter writer, Unit[] units, Object token) throws IOException {
        boolean empty = true;
        int i = 0;
        while (i < units.length) {
            if (units[i] != null) {
                empty = false;
                break;
            }
            ++i;
        }
        if (empty) {
            return null;
        }
        int[] indices = new int[units.length];
        int i2 = 0;
        while (i2 < units.length) {
            indices[i2] = units[i2] == null ? -1 : BinaryUnit.write(writer, units[i2], token);
            ++i2;
        }
        return indices;
    }
}

