/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.MathType;
import visad.RealTupleType;
import visad.TupleType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryMathType;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryRealTupleType;
import visad.data.visad.object.BinarySerializedObject;

public class BinaryTupleType
implements BinaryObject {
    static /* synthetic */ Class class$visad$TupleType;

    public static final int computeBytes(TupleType tt) {
        return 5 + tt.getDimension() * 4 + 1;
    }

    public static final TupleType read(BinaryReader reader, int index, int objLen) throws IOException, VisADException {
        MathType[] list = BinaryMathType.readList(reader, (objLen - 1) / 4);
        BinaryObjectCache cache = reader.getTypeCache();
        DataInput file = reader.getInput();
        byte endByte = file.readByte();
        if (endByte != 80) {
            throw new IOException("Corrupted file (no TupleType end-marker)");
        }
        TupleType tt = new TupleType(list);
        cache.add(index, tt);
        return tt;
    }

    public static final int write(BinaryWriter writer, TupleType tt, Object token) throws IOException {
        if (tt instanceof RealTupleType) {
            return BinaryRealTupleType.write(writer, (RealTupleType)tt, token);
        }
        int dim = tt.getDimension();
        int[] types = new int[dim];
        int i = 0;
        while (i < dim) {
            MathType comp;
            try {
                comp = tt.getComponent(i);
            }
            catch (VisADException ve) {
                throw new IOException("Couldn't get TupleType component #" + i + ": " + ve.getMessage());
            }
            types[i] = BinaryMathType.write(writer, comp, token);
            ++i;
        }
        BinaryObjectCache cache = writer.getTypeCache();
        int index = cache.getIndex(tt);
        if (index < 0) {
            index = cache.add(tt);
            if (index < 0) {
                throw new IOException("Couldn't cache TupleType " + tt);
            }
            if (!(tt.getClass().equals(class$visad$TupleType == null ? (class$visad$TupleType = BinaryTupleType.class$("visad.TupleType")) : class$visad$TupleType) || tt instanceof TupleType && tt instanceof Saveable)) {
                BinarySerializedObject.write(writer, (byte)6, tt, token);
                return index;
            }
            int objLen = BinaryTupleType.computeBytes(tt);
            DataOutput file = writer.getOutput();
            file.writeByte(5);
            file.writeInt(objLen);
            file.writeInt(index);
            file.writeByte(6);
            int i2 = 0;
            while (i2 < dim) {
                file.writeInt(types[i2]);
                ++i2;
            }
            file.writeByte(80);
        }
        return index;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

