/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.Text;
import visad.TextType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryString;
import visad.data.visad.object.BinaryTextType;

public class BinaryText
implements BinaryObject {
    public static final int computeBytes(String value) {
        return 10 + BinaryString.computeBytes(value) + 1;
    }

    public static final Text read(BinaryReader reader) throws IOException, VisADException {
        BinaryObjectCache cache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        TextType tt = (TextType)cache.get(typeIndex);
        String value = BinaryString.read(reader);
        byte endByte = file.readByte();
        if (endByte != 80) {
            throw new IOException("Corrupted file (no Text end-marker)");
        }
        return new Text(tt, value);
    }

    public static final void writeDependentData(BinaryWriter writer, TextType type, Object token) throws IOException {
        BinaryTextType.write(writer, type, BinaryObject.SAVE_DATA);
    }

    public static final void write(BinaryWriter writer, TextType type, String value, boolean missing, Text text, Object token) throws IOException {
        BinaryText.writeDependentData(writer, type, token);
        if (token == BinaryObject.SAVE_DEPEND || token == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        int typeIndex = writer.getTypeCache().getIndex(type);
        if (typeIndex < 0) {
            throw new IOException("TextType " + type + " not cached");
        }
        int objLen = BinaryText.computeBytes(value);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(2);
        file.writeInt(typeIndex);
        BinaryString.write(writer, value, token);
        file.writeByte(80);
    }
}

