/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.SampledSet;
import visad.VisADException;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryObject;

public class BinarySampledSet
implements BinaryObject {
    public static final int computeBytes(SampledSet[] sets) {
        if (sets == null) {
            return 0;
        }
        int setsLen = 5;
        int i = 0;
        while (i < sets.length) {
            int len = BinaryGeneric.computeBytes(sets[i]);
            if (len < 0) {
                return -1;
            }
            setsLen += len;
            ++i;
        }
        return setsLen;
    }

    public static final SampledSet[] readList(BinaryReader reader) throws IOException, VisADException {
        DataInput file = reader.getInput();
        int len = file.readInt();
        SampledSet[] sets = new SampledSet[len];
        int i = 0;
        while (i < sets.length) {
            sets[i] = (SampledSet)BinaryGeneric.read(reader);
            ++i;
        }
        return sets;
    }

    public static final void writeList(BinaryWriter writer, SampledSet[] sets, Object token) throws IOException {
        if (sets == null) {
            return;
        }
        DataOutput file = writer.getOutput();
        file.writeByte(11);
        file.writeInt(sets.length);
        int i = 0;
        while (i < sets.length) {
            BinaryGeneric.write(writer, sets[i], token);
            ++i;
        }
    }
}

