/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.DisplayTupleType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.Set;
import visad.TypeException;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryDisplayTupleType;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryMathType;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryRealType;
import visad.data.visad.object.BinaryRealVectorType;
import visad.data.visad.object.BinarySerializedObject;

public class BinaryRealTupleType
implements BinaryObject {
    static /* synthetic */ Class class$visad$RealTupleType;

    public static final int computeBytes(RealTupleType rtt) {
        return 9 + rtt.getDimension() * 4 + (rtt.getCoordinateSystem() == null ? 0 : 5) + (rtt.getDefaultSet() == null ? 0 : 1) + 1;
    }

    public static final RealTupleType read(BinaryReader reader, int index) throws IOException, VisADException {
        RealTupleType rtt;
        block11: {
            BinaryObjectCache cSysCache = reader.getCoordinateSystemCache();
            BinaryObjectCache typeCache = reader.getTypeCache();
            DataInput file = reader.getInput();
            int dim = file.readInt();
            MathType[] mtList = BinaryMathType.readList(reader, dim);
            RealType[] list = new RealType[mtList.length];
            int i = 0;
            while (i < mtList.length) {
                list[i] = (RealType)mtList[i];
                ++i;
            }
            CoordinateSystem cs = null;
            boolean setFollowsType = false;
            boolean reading = true;
            while (reading) {
                byte directive;
                try {
                    directive = file.readByte();
                }
                catch (EOFException eofe) {
                    return null;
                }
                switch (directive) {
                    case 32: {
                        int csIndex = file.readInt();
                        cs = (CoordinateSystem)cSysCache.get(csIndex);
                        break;
                    }
                    case 70: {
                        setFollowsType = true;
                        break;
                    }
                    case 80: {
                        reading = false;
                        break;
                    }
                    default: {
                        throw new IOException("Unknown RealTupleType directive " + directive);
                    }
                }
            }
            rtt = new RealTupleType(list, cs, null);
            typeCache.add(index, rtt);
            if (!setFollowsType) break block11;
            Set set = (Set)BinaryGeneric.read(reader);
            try {
                rtt.setDefaultSet(set);
            }
            catch (TypeException te) {}
        }
        return rtt;
    }

    public static final int write(BinaryWriter writer, RealTupleType rtt, Object token) throws IOException {
        BinaryObjectCache cache = writer.getTypeCache();
        if (rtt instanceof DisplayTupleType) {
            return BinaryDisplayTupleType.write(writer, (DisplayTupleType)rtt, token);
        }
        if (rtt instanceof RealVectorType) {
            return BinaryRealVectorType.write(writer, (RealVectorType)rtt, token);
        }
        int index = cache.getIndex(rtt);
        if (index < 0) {
            index = cache.add(rtt);
            if (index < 0) {
                throw new IOException("Couldn't cache RealTupleType " + rtt);
            }
            if (!(rtt.getClass().equals(class$visad$RealTupleType == null ? (class$visad$RealTupleType = BinaryRealTupleType.class$("visad.RealTupleType")) : class$visad$RealTupleType) || rtt instanceof RealTupleType && rtt instanceof Saveable)) {
                BinarySerializedObject.write(writer, (byte)6, rtt, token);
                return index;
            }
            int dim = rtt.getDimension();
            Set dfltSet = rtt.getDefaultSet();
            int[] types = new int[dim];
            int i = 0;
            while (i < dim) {
                RealType comp;
                try {
                    comp = (RealType)rtt.getComponent(i);
                }
                catch (VisADException ve) {
                    throw new IOException("Couldn't get RealTupleType component #" + i + ": " + ve.getMessage());
                }
                types[i] = BinaryRealType.write(writer, comp, token);
                ++i;
            }
            CoordinateSystem cs = rtt.getCoordinateSystem();
            int csIndex = -1;
            if (cs != null) {
                csIndex = BinaryCoordinateSystem.write(writer, cs, token);
            }
            int objLen = BinaryRealTupleType.computeBytes(rtt);
            DataOutput file = writer.getOutput();
            file.writeByte(5);
            file.writeInt(objLen);
            file.writeInt(index);
            file.writeByte(3);
            file.writeInt(dim);
            int i2 = 0;
            while (i2 < dim) {
                file.writeInt(types[i2]);
                ++i2;
            }
            if (csIndex >= 0) {
                file.writeByte(32);
                file.writeInt(csIndex);
            }
            if (dfltSet != null) {
                file.writeByte(70);
            }
            file.writeByte(80);
            if (dfltSet != null) {
                Object dependToken = token == BinaryObject.SAVE_DEPEND_BIG ? token : BinaryObject.SAVE_DEPEND;
                BinaryGeneric.write(writer, dfltSet, dependToken);
                BinaryGeneric.write(writer, dfltSet, BinaryObject.SAVE_DATA);
            }
        }
        return index;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

